<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use App\Models\Customers;
use App\Models\CriminalRecords;
use App\Models\CustomerDocuments;
use App\Models\Room;
use App\Models\Staffs;
use App\Models\Country;
use App\Models\Complaints;
use App\Models\Properties;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use App\Models\IdProofTypes;
use DataTables;
use File;
use Carbon\CarbonPeriod;

class CustomersController extends Controller
{
    
     public function index(Request $request){
        $datas = $request->all();
        $user_type = Auth::user()->user_type ;
        $main_id = Auth::user()->id ;
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();

        //check if logged in user in govt admin staff for property filter
        if($user_type == 3 || $user_type == 5 || $user_type == 6){ //govt admin staff
            $propertiesq = Properties::where('status_id','1');
            
            if($user_type == 3){
                $propertiesq->where('created_by',$main_id);
            }
            $properties = $propertiesq->get();
        } else {
            $properties = array();
        }
        $created_by_id = '';
        if($user_type == 3){
            $h_admin = HotelAdmin::where('main_user_id',$main_id)->first();
            $created_by_id = $h_admin->main_user_id;
        } else  if($user_type == 4 ){//4 = hotel admin staff
            $staff_details = Staffs::where('main_user_id',Auth::user()->id)->first();
            $created_by_id = $staff_details->created_by;
        } else {
            $created_by_id = $main_id;
        }
        //  echo $h_main_id;exit;
        //manage privilege if its staff user
        if($user_type == 4 || $user_type == 6){//4 = hotel admin staff and govt admin staff

            //get staff info for group 
            $getGroup = DB::table('staffs')->select('group_id')->where('main_user_id', Auth::user()->id)->first();
            
            //get groups and privileges
            $getPrivileges = DB::table('groups_privileges')->where('group_id', $getGroup->group_id)->where('module_id','5')->first();//module_id = 5(Only customer module)

        } else {
            $getPrivileges = array();
        }

        if(array_key_exists('is_gov',$datas)){
            if(array_key_exists('govt_propVal',$datas)){
                $preData = DB::table('customers')->select('*');
                if($datas['govt_propVal']){
                    $preData->where('property_id',$datas['govt_propVal']);
                }
                if($datas['govt_stayVal'] == 1 || $datas['govt_stayVal'] == 2){
                    $preData->where('checkout_date_time',''); 
                }
                $data = $preData->orderBy('id','desc')->where('deleted_at',null)->get();
            } else {
                $data = array();
            }

        } else {
        
               //get customers list only of checking in
            // $dataq = Customers::where('customers.created_by',$created_by_id)->orderBy('customers.id','desc')->where('customers.deleted_at',null);
            $dataq = DB::table('customers')->select('customers.*','rooms.title as room_title')->where('customers.created_by',$created_by_id)->orderBy('customers.id','desc')->where('customers.deleted_at',null);

            $dataq->join('rooms','rooms.id','=','customers.room_id','left');
            if(array_key_exists('stay_vals',$datas) || array_key_exists('property_id',$datas)){
                if($datas['stay_vals'] == 1){  //get customers only checked in currently
                    $dataq->where('customers.checkout_date_time','')->orWhere('customers.checkout_date_time','=',NULL);
                } else {//get customer datewise
                    $fromd = date('Y-m-d',strtotime($datas['from_date']));
                    $post_start_date =  \Carbon\Carbon::parse($fromd);
                     
                    $tod = date('Y-m-d',strtotime($datas['to_date']));
                    $post_end_date =  \Carbon\Carbon::parse($tod);
                    $dataq->where('customers.checkin_date_time','!=','')->whereBetween('customers.checkin_date_time', [$post_start_date, $post_end_date]);
                }
            }
            if(array_key_exists('property_id',$datas) && $datas['property_id'] > 0){ 
                $dataq->where('customers.property_id',$datas['property_id']);
            }

            if(array_key_exists('room',$datas) && $datas['room'] > 0){
                $dataq->where('customers.room_id',$datas['room']);
            }
            $dataq->where('customers.checkin_date_time','!=','null null ');
            $data = $dataq->get();
        }
        // echo "<pre>";print_r($data);exit;
        // and then you can get query log
       
        foreach($data as $customer){
            if($customer->room_id == '7'){
            if(Auth::user()->user_type == 4){  //hotel admin staff
                $assigned_properties = DB::table('staff_assigned_properties')->where('property_id',  $customer->property_id)->first();
            
                if(!empty($assigned_properties)){
                    $customer = $customer;
                } else {
                    $customer = array();
                }
            }
            
            //create full name 
            // $customer->first_name =  $customer->first_name.' '.$customer->last_name;
            $customer->first_name =  $customer->full_name;
            $customer->full_name =  $customer->full_name;
            //get room title
            // echo "<pre>";print_r($customer);exit;
            $room_details = Room::find($customer->room_id);
            
            if($customer->room_id){
                $customer->room_id =  $room_details->title;
            } else {
                $customer->room_id =  '';
            }
            
            //get country title
            if($customer->nationality){
                $country_title = Country::find($customer->nationality);
                if(empty($country_title)){
                    $customer->nationality = '';
                } else {
                    $customer->nationality = $country_title->name;
                }
                
            } else {
                $customer->nationality = 'India';
            }

            //get customer id
            $id = $customer->id;

            //check if date range is requested and get customer accordingly
            if(array_key_exists('stay_vals',$datas)){
                if($datas['stay_vals'] == 2){  
                    $from = $datas['from_date'].' 00:00:00';
                    $to = $datas['to_date'].' 00:00:00'; 
                   if($customer->checkin_date_time < $from && $customer->checkout_date_time > $to ){
                    $customer = $customer;
                   } else {
                    $customer = array();
                   }
                } 
            }
            
            //check if property id for filter
            if(array_key_exists('property_id',$datas)){
                if($datas['property_id']) {
                    $from = $datas['from_date'].' 00:00:00';
                    $to = $datas['to_date'].' 00:00:00'; 
                    if($customer->checkin_date_time < $from && $customer->checkout_date_time > $to ){
                        $customer = $customer;
                    } else {
                        $customer = array();
                    }
                }
            }
            $final_customer[] =  $customer;
        }
        }
        // echo "<pre>";print_r(collect($final_customer));exit;

        if($user_type == 5){
            $action = '<a href="{{ route("customers.viewdetails",["id"=>base64_encode($id)]) }}" style="width: 51px;padding: 7px;color: black;margin-left:7px;margin-top:-147px;" data-toggle="tooltip" data-placement="top" title="View Details" class="view_cust_details" ><i class="fa fa-eye"></i></a>';
        } else {
            if(!empty($getPrivileges)){
                if($getPrivileges->edit ==1 && $getPrivileges->delete ==1){ //allow delete and edit access
                    $action = '<a href="/customers/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
                } else if($getPrivileges->edit ==1 && $getPrivileges->delete !=1){//allow edit access
                    $action = '<a href="/customers/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>';
                } else if($getPrivileges->delete == 1 && $getPrivileges->edit != 1){
                    $action = '<button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
                } else {
                    $action =  '';
                }
            } else {
                $action = '<a href="/customers/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button><a href="{{ route("complaints.create",["id"=>$id]) }}" style="width: 51px;padding: 7px;color: black;margin-left:7px;margin-top:-147px;" data-toggle="tooltip" data-placement="top" title="File Complaint" ><i class="fa fa-folder"></i></a>';
            }
        }

        if ($request->ajax()) {
            return Datatables::of($data)
                    ->addColumn('action', $action)
                    // ->addColumn('action', '<a href="/customers/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>')
                    ->rawColumns(['action'])
                    ->make(true);
        }
        return view('dashboard.customers.customersList',['privileges'=>$getPrivileges,'properties'=>$properties]);
    }
    
    
    public function index_org_23_08_2023(Request $request){
        $datas = $request->all();
        $user_type = Auth::user()->user_type ;
        $main_id = Auth::user()->id ;

        //check if logged in user in govt admin staff for property filter
        if($user_type == 5 || $user_type == 6){ //govt admin staff
            $properties = Properties::where('status_id','1')->get();
        } else {
            $properties = array();
        }

        if($user_type == 3){
            $h_admin = HotelAdmin::where('main_user_id',$main_id)->first();
            $h_main_id = $h_admin->main_user_id;
        } else {
            $h_main_id = $main_id;
        }
        //  echo $h_main_id;exit;
        //manage privilege if its staff user
        if($user_type == 4 || $user_type == 6){//4 = hotel admin staff and govt admin staff

            //get staff info for group 
            $getGroup = DB::table('staffs')->select('group_id')->where('main_user_id', Auth::user()->id)->first();
            
            //get groups and privileges
            $getPrivileges = DB::table('groups_privileges')->where('group_id', $getGroup->group_id)->where('module_id','5')->first();//module_id = 5(Only customer module)

        } else {
            $getPrivileges = array();
        }

        if(array_key_exists('is_gov',$datas)){
            if(array_key_exists('govt_propVal',$datas)){
                $preData = DB::table('customers')->select('*');
                if($datas['govt_propVal']){
                    $preData->where('property_id',$datas['govt_propVal']);
                }
                if($datas['govt_stayVal'] == 1 || $datas['govt_stayVal'] == 2){
                    $preData->where('checkout_date_time',''); 
                }
                $data = $preData->orderBy('id','desc')->where('deleted_at',null)->get();
            } else {
                $data = array();
            }

        } else {
        
            //get customers list only of checking in
            if(array_key_exists('stay_vals',$datas)){
                if($datas['stay_vals'] == 1){  //get customers only checked in currently
                    $data = Customers::where('checkout_date_time','')->where('created_by',$h_main_id)->orderBy('id','desc')->where('deleted_at',null)->get();
                } else {//get customer datewise
                    $data = Customers::orderBy('id','desc')->where('created_by',$h_main_id)->where('deleted_at',null)->get();
                    $from = $datas['from_date'].' 00:00:00';
                    $to = $datas['to_date'].' 00:00:00'; 
                    
                     $fromd = date('Y-m-d',strtotime($datas['from_date']));
                    $post_start_date =  \Carbon\Carbon::parse($fromd);
                     
                    $tod = date('Y-m-d',strtotime($datas['to_date']));
                    $post_end_date =  \Carbon\Carbon::parse($tod);
            
            
                    $data = Customers::orderBy('checkin_date_time','desc')
                            ->where('checkin_date_time','!=','')
                            // ->where('checkin_date_time','!=','')
                             ->whereBetween('checkin_date_time', [$post_start_date, $post_end_date])
                            ->where('deleted_at',null)->get();
                }
            } else { 
                $data = Customers::where('checkout_date_time','=',NULL)->orWhere('checkout_date_time','=','')->where('created_by',$h_main_id)->orderBy('id','desc')->where('deleted_at',null)->get();
            }
            // echo "<pre>";print_r($data);exit;
            if(array_key_exists('property_id',$datas) && $datas['property_id'] > 0){
                $data = Customers::where('checkout_date_time','=',NULL)->orWhere('checkout_date_time','=','')->where('created_by',$h_main_id)->where('property_id',$datas['property_id'])->orderBy('id','desc')->where('deleted_at',null)->get();
            } else {
                $data = Customers::where('checkout_date_time','=',NULL)->orWhere('checkout_date_time','=','')->where('created_by',$h_main_id)->orderBy('id','desc')->where('deleted_at',null)->get();
            }
            
            if($user_type == 4 ){//4 = hotel admin staff
             $staff_details = Staffs::where('main_user_id',Auth::user()->id)->first();
                $data = Customers::where('checkout_date_time','=',NULL)->orWhere('checkout_date_time','=','')->where('created_by',$staff_details->created_by)->orderBy('id','desc')->where('deleted_at',null)->get();
            }
        }
// echo "<pre>";print_r($data);exit;
        // and then you can get query log
        foreach($data as $customer){
  
            
         if(Auth::user()->user_type == 4){  //hotel admin staff
            $assigned_properties = DB::table('staff_assigned_properties')->where('property_id',  $customer->property_id)->first();
        
                if(!empty($assigned_properties)){
                    $customer = $customer;
                } else {
                    $customer = array();
                }
            }
            
            //create full name 
            $customer->first_name =  $customer->first_name.' '.$customer->last_name;
            //get room title
            // echo "<pre>";print_r($customer);exit;
            $room_details = Room::find($customer->room_id);
            
            if($customer->room_id){
                $customer->room_id =  $room_details->title;
            } else {
                $customer->room_id =  '';
            }
            

            //get country title
            if($customer->nationality){
                $country_title = Country::find($customer->nationality);
                if(empty($country_title)){
                    $customer->nationality = '';
                } else {
                    $customer->nationality = $country_title->name;
                }
                
            } else {
                $customer->nationality = 'India';
            }

            //get customer id
            $id = $customer->id;

            //check if date range is requested and get customer accordingly
            if(array_key_exists('stay_vals',$datas)){
                if($datas['stay_vals'] == 2){  
                    $from = $datas['from_date'].' 00:00:00';
                    $to = $datas['to_date'].' 00:00:00'; 
                   if($customer->checkin_date_time < $from && $customer->checkout_date_time > $to ){
                    $customer = $customer;
                   } else {
                    $customer = array();
                   }
                } 
            }
            
            
            //check if property id for filter
            if(array_key_exists('property_id',$datas)){
                if($datas['property_id']) {
                    $from = $datas['from_date'].' 00:00:00';
                    $to = $datas['to_date'].' 00:00:00'; 
                    if($customer->checkin_date_time < $from && $customer->checkout_date_time > $to ){
                        $customer = $customer;
                    } else {
                        $customer = array();
                    }
                }
            }
        }

        if($user_type == 5){
            $action = '<a href="{{ route("customers.viewdetails",["id"=>base64_encode($id)]) }}" style="width: 51px;padding: 7px;color: black;margin-left:7px;margin-top:-147px;" data-toggle="tooltip" data-placement="top" title="View Details" class="view_cust_details" ><i class="fa fa-eye"></i></a>';
        } else {
            if(!empty($getPrivileges)){
                if($getPrivileges->edit ==1 && $getPrivileges->delete ==1){ //allow delete and edit access
                    $action = '<a href="/customers/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
                } else if($getPrivileges->edit ==1 && $getPrivileges->delete !=1){//allow edit access
                    $action = '<a href="/customers/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>';
                } else if($getPrivileges->delete == 1 && $getPrivileges->edit != 1){
                    $action = '<button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
                } else {
                    $action =  '';
                }
            } else {
                $action = '<a href="/customers/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button><a href="{{ route("complaints.create",["id"=>$id]) }}" style="width: 51px;padding: 7px;color: black;margin-left:7px;margin-top:-147px;" data-toggle="tooltip" data-placement="top" title="File Complaint" ><i class="fa fa-folder"></i></a>';
            }
        }

        if ($request->ajax()) {
            return Datatables::of($data)
                    ->addColumn('action', $action)
                    // ->addColumn('action', '<a href="/customers/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>')
                    ->rawColumns(['action'])
                    ->make(true);
        }
        return view('dashboard.customers.customersList',['privileges'=>$getPrivileges,'properties'=>$properties]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   
        $rooms = Room::where('created_by',Auth::user()->id)->get();
        $id_proof_type = IdProofTypes::where('created_by',Auth::user()->id)->get();
        $countries = Country::all(); 
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();    
        $cust = array();
        return view('dashboard.customers.create',['customer'=>$cust,'rooms'=>$rooms,'types'=>$id_proof_type,'docs'=>array(),'countries'=>$countries,'properties'=>$properties]);
    }

     /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $hotel_admin_id = Auth::user()->id;

        // $validatedData = $request->validate([
        //     'first_name'      => 'required|min:1|max:64',
        //     'last_name'       => 'required|min:1|max:64',
        //     // 'email'           => 'required|email|unique:customers',
        //     'mobile'          => 'required|max:10',
        //     'profile_pic' => 'required|image|mimes:jpg,png,jpeg,gif,svg|max:2048',
        // ]);
       
        //insert new hotel admin in users table
        //get recently adde cust
        $check_if_exists = Customers::where('email',$request->input('email'))->first();
        if(!$check_if_exists){
            $customer = new Customers();
        } else {
            $customerID = $check_if_exists->id;
            $customer = Customers::find($customerID);
        }
        
        //for basic info tab details
        // $customer = new Customers();
        $customer->full_name    = $request->input('full_name');
        $customer->first_name    = $request->input('first_name');
        $customer->middle_name    = $request->input('middle_name');
        $customer->last_name    = $request->input('last_name');
        $customer->email   =  $request->input('email');
        $customer->mobile   =  $request->input('mobile');
        $customer->nationality   =  $request->input('nationality');
        $customer->date_of_birth   =  $request->input('date_of_birth');
        $customer->gender   =  $request->input('gender');
        $customer->passport_number   =  $request->input('passport_number');
        $customer->passport_expiry_date   =  $request->input('passport_expiry_date');
        $customer->country_of_issue   =  $request->input('country_of_issue');
        $customer->room_id   =  $request->input('room_id');
        $customer->property_id   =  $request->input('property_id');
        $customer->checkin_date_time   =  $request->input('checkin_date').' '.$request->input('checkin_time');
        $customer->checkout_date_time   =  $request->input('checkout_date').' '.$request->input('checkout_time');

        //for address tab details
        // $customer->address_line_1    = $request->input('address_line_1');
        // $customer->address_line_2    = $request->input('address_line_2');
        $customer->address    = $request->input('address');

        $customer->city    = $request->input('city');
        $customer->state   =  $request->input('state');
        $customer->pin   =  $request->input('pin');
        $customer->country   =  $request->input('country');
        
        $customer->created_by = Auth::user()->id;
        $customer->save();

        //get recently adde cust
        $recent = Customers::where('email',$request->input('email'))->first();
        $recent_cust_id = $recent->id;

        //create guest code
        $property = Properties::find($request->input('property_id'));
        $total_cnt_q = DB::table('customers')
            ->select('id')
            ->Where('property_id', $request->input('property_id'))
            ->get();
        $total_cnt = count($total_cnt_q);
        $total_cnt = $total_cnt + 1;
        $cust_code = sprintf("%'.04d\n", $total_cnt);
       
        $guest_code =   $property->code.'-'.date('d-m-Y').'-'.$cust_code;    
        $update_guest_code_ar = array('guest_code' => $guest_code);
        DB::table('customers')->where('id', $recent_cust_id)->update($update_guest_code_ar);

            //for custoomer uploaded document
            //Create hotel admin folder if not exists
            $hotel_admin_path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id);
            if(!File::isDirectory($hotel_admin_path)){
                File::makeDirectory($hotel_admin_path, 0777, true, true);
                File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents', 0777, true, true);//create  customer_documents folder
            }
            
            // create or update file in directory if exists in hotel admin folder
            $path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$recent_cust_id);
            if(!File::isDirectory($path)){
                File::makeDirectory($path, 0777, true, true);
                File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$recent_cust_id.'/display_picture', 0777, true, true);
            }

            //for customer dp
            if ($request->hasFile('profile_pic')) {

                $filenameWithExt = $request->file('profile_pic')->getClientOriginalName ();
                // Get Filename
                $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
                // Get just Extension
                $extension = $request->file('profile_pic')->getClientOriginalExtension();
                // Filename To store
                $fileNameToStore = $filename. '_'. time().'.'.$extension;
                // Upload Image$path = 
                $img = $request->file('profile_pic')->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents'.'/'.$recent_cust_id.'/display_picture', $fileNameToStore);
                $dp_array = array('profile_image'=>$fileNameToStore,);
                DB::table('customers')->where('id', $recent_cust_id)->update($dp_array);
                
            } else {
                $fileNameToStore = '';
                $img = '';
            }

            // $cnt = count($request->input('document_type'));
            // $cust_docs_arr = array();
            // for ($i=0; $i < $cnt; $i++){
            //     //store uploaded docs
            //     if ($request->hasFile('uploaded_document')) {

            //          // Get filename with the extension
            //         $custDocsfilenameWithExt = $request->file('uploaded_document')[$i]->getClientOriginalName();
            //         // Get Filename
            //         $custDocfilename = pathinfo($custDocsfilenameWithExt, PATHINFO_FILENAME);
            //         // Get just Extension
            //         $custDocsextension = $request->file('uploaded_document')[$i]->getClientOriginalExtension();
            //         // 
            //         $custDocsfileNameToStore = $custDocfilename. '_'. time().'.'.$custDocsextension;
                
            //         $cust_doc = $request->file('uploaded_document')[$i]->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents'.'/'.$recent_cust_id,$custDocsfileNameToStore);
            //     } else {
            //         $custDocsfileNameToStore = '';
            //         $cust_doc = '';
            //     }
            
            //     $cust_docs_arr = array(
            //         'customer_id'=>$recent_cust_id,
            //         'document_type'=>$request->input('document_type')[$i],
            //         'number'=>$request->input('number')[$i],
            //         'uploaded_document'=>$custDocsfileNameToStore,
            //     );
            //     $insert_cust_docs = DB::table('customer_documents')->insertGetId($cust_docs_arr);
            // }	

        $request->session()->flash('message', 'Customer Created Successfully.');
        return redirect()->route('customers.index');
    }

    //for editing gov admin
    public function edit($id)
    {
        $customer = Customers::find($id);
        $rooms = Room::where('created_by',Auth::user()->id)->get();
        $countries = Country::all();
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();    
        $id_proof_type = IdProofTypes::where('created_by',Auth::user()->id)->get();
        $docs = DB::table('customer_documents')->where('customer_id',$id)->where('deleted_at',null)->get();
        $docs_array = array();
       
        $all_notes = DB::table('customer_notes')->where('customer_id',$id)->where('deleted_at','0')->get();
        $notes_ar = array();
        foreach($all_notes as $note){
            $notes_ar[] = $note;
        }
        if($customer->checkin_date_time){
            $checkin_date_time = explode(' ',$customer->checkin_date_time);
            $customer->checkin_date = '';
            $customer->checkin_time = '';
            $customer->checkin_date = $checkin_date_time[0];
            $customer->checkin_time = $checkin_date_time[1];
        } else {
            $customer->checkin_date = '';
            $customer->checkin_time = '';
        }
        
        if($customer->checkout_date_time){
        $checkout_date_time = explode(' ',$customer->checkout_date_time);
        $customer->checkout_date = '';
        $customer->checkout_time = '';
        $customer->checkout_date = $checkout_date_time[0];
        $customer->checkout_time = $checkout_date_time[1];
        } else {
            $customer->checkout_date = '';
            $customer->checkout_time = '';
        }
        //customer profile image path
        $customer->profile_image = 'public/storage/uploads/hotel_admins/'.$customer->created_by.'/customer_documents'.'/'.$customer->id.'/display_picture'.'/'.$customer->profile_image;
        // echo $customer->profile_image;exit;
        if($docs){
            $docs_array = $docs;
            foreach($docs_array as $doc){
                $path = 'public/storage/uploads/hotel_admins/'.$customer->created_by.'/'.'customer_documents/'.$customer->id.'/'.$doc->uploaded_document;
                $doc->uploaded_document= $path;

                //get doc type
                $types = IdProofTypes::find($doc->document_type);
                $doc->document_type = $types->title;
                
            }
        } else {
            $docs_array = array();
        }
         //complaint found if any for complaint tab
          $complaintExists = DB::table('customers as cs')
          ->select('cs.id','cs.passport_number')
          ->join('complaints as cp','cp.complaint_against','=','cs.id','left')
          ->where('cs.passport_number',$customer->passport_number)
          ->orWhere('cs.first_name', 'like', '%' . $customer->first_name . '%')
          ->orWhere('cs.last_name', 'like', '%' . $customer->last_name . '%')
          ->get();
            $complaint_cust_str = '';
            if(!empty($complaintExists)){
                foreach($complaintExists as $cust ){
                    $complaints_list = Complaints::where('complaint_against',$cust->id)->first();
                    if(!empty($complaints_list)){
                        if($cust->passport_number == $customer->passport_number){
                            $complaint_cust_str .= $cust->id.',';
                        }
                    }
                }
            }

            //complaint found if any for complaint tab
            $criminalExists = DB::table('criminal_records as cr')
            ->select('id')
            ->orWhere('first_name', 'like', '%' . $customer->full_name . '%')
            ->orWhere('last_name', 'like', '%' . $customer->full_name . '%')
            // ->orWhere('full_name', 'like', '%' . $customer->full_name . '%')
            ->get();
            $crminal_cust_str = '';
            foreach($criminalExists as $cust ){
                $crminal_cust_str .= $customer->id.',';
            }
            // echo "<pre>";print_r( $crminal_cust_str)  ;exit;
        // echo "<pre>";print_r($customer);exit;
        return view('dashboard.customers.edit', ['notes_ar'=>$notes_ar,'rooms'=>$rooms, 'customer' => $customer,'docs'=>$docs_array ,'types'=>$id_proof_type,'countries'=>$countries,'properties'=>$properties,'cust_complaints'=>$complaint_cust_str,'crminal_cust_str'=>$crminal_cust_str]);
        // return response()->json(array('cust_id'=>$recent_cust_id, 'cust_complaints'=>$complaint_cust_str,'crminal_cust_str'=>$crminal_cust_str));
   
    }

        /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'full_name'      => 'required|min:1|max:64',
            // 'first_name'      => 'required|min:1|max:64',
            // 'last_name'       => 'required|min:1|max:64',
            // 'email'           => 'required|email|unique:customers',
            'mobile'          => 'max:10',
            // 'profile_pic' => 'mimes:jpg,png,jpeg|min:1|max:1000',
        ]);

        $customer = Customers::find($id);
       
        //Create hotel admin folder if not exists
        $hotel_admin_id  = Auth::user()->id;
        $hotel_admin_path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id);
        if(!File::isDirectory($hotel_admin_path)){
            File::makeDirectory($hotel_admin_path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents', 0777, true, true);//create  customer_documents folder
        }

        // create or update file in directory if exists in hotel admin folder
        $path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$id);
        if(!File::isDirectory($path)){
            File::makeDirectory($path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$id.'/display_picture', 0777, true, true);
        }

        //if customer display image
        if ($request->hasFile('profile_pic')) {

            $filenameWithExt = $request->file('profile_pic')->getClientOriginalName ();
            // Get Filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $extension = $request->file('profile_pic')->getClientOriginalExtension();
            // Filename To store
            $fileNameToStore = $filename. '_'. time().'.'.$extension;
            // Upload Image$path = 
            $img = $request->file('profile_pic')->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents'.'/'.$id.'/display_picture', $fileNameToStore);
        } else {
            $fileNameToStore = $customer->profile_image;
            $img = '';
        }

        //create guest code
        if(!$request->input('guest_code')){
            $property = Properties::find($request->input('property_id'));
            $total_cnt_q = DB::table('customers')
                ->select('id')
                ->Where('property_id', $request->input('property_id'))
                ->get();
            $total_cnt = count($total_cnt_q);
            $total_cnt = $total_cnt + 1;
            $cust_code = sprintf("%'.04d\n", $total_cnt);
            $customer->guest_code =   $property->code.'-'.date('d-m-Y').'-'.$cust_code;    
        } else {
            $customer->guest_code = $request->input('guest_code');
        }
   
        //for basic info tab details
        $customer->full_name    = $request->input('full_name');
        $customer->first_name    = $request->input('first_name');
        $customer->middle_name    = $request->input('middle_name');
        $customer->last_name    = $request->input('last_name');
        $customer->email   =  $request->input('email');
        $customer->mobile   =  $request->input('mobile');
        $customer->nationality   =  $request->input('nationality');
        $customer->date_of_birth   =  $request->input('date_of_birth');
        $customer->gender   =  $request->input('gender');
        $customer->passport_number   =  $request->input('passport_number');
        $customer->passport_expiry_date   =  $request->input('passport_expiry_date');
        $customer->country_of_issue   =  $request->input('country_of_issue');
        $customer->room_id   =  $request->input('room_id');
        $customer->property_id   =  $request->input('property_id');
        $customer->checkin_date_time   =  $request->input('checkin_date').' '.$request->input('checkin_time');
        $customer->checkout_date_time   =  $request->input('checkout_date').' '.$request->input('checkout_time');

        $customer->profile_image   =  $fileNameToStore;

        //for address tab details
        $customer->address    = $request->input('address');
        // $customer->address_line_1    = $request->input('address_line_1');
        // $customer->address_line_2    = $request->input('address_line_2');
        $customer->city    = $request->input('city');
        $customer->state   =  $request->input('state');
        $customer->pin   =  $request->input('pin');
        $customer->country   =  $request->input('country');

        $customer->created_by = Auth::user()->id;
        $customer->save();

        //for custoomer uploaded document

        // $cnt = count($request->input('document_type'));
        // $cust_docs_arr = array();
        // for ($i=0; $i < $cnt; $i++){
        //     //store uploaded docs
        //     if ($request->hasFile('uploaded_document')) { 
        //         if(empty($request->file('uploaded_document')[$i])){

        //         } else {
        //             // Get filename with the extension
        //             $custDocsfilenameWithExt = $request->file('uploaded_document')[$i]->getClientOriginalName();
        //             // Get Filename
        //             $custDocfilename = pathinfo($custDocsfilenameWithExt, PATHINFO_FILENAME);
        //             // Get just Extension
        //             $custDocsextension = $request->file('uploaded_document')[$i]->getClientOriginalExtension();
        //             $custDocsfileNameToStore = $custDocfilename. '_'. time().'.'.$custDocsextension;
        //             $cust_doc = $request->file('uploaded_document')[$i]->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents'.'/'.$id,$custDocsfileNameToStore);
                    
        //             $cust_docs_arr = array(
        //                 'customer_id'=>$id,
        //                 'document_type'=>$request->input('document_type')[$i],
        //                 'number'=>$request->input('number')[$i],
        //                 'uploaded_document'=>$custDocsfileNameToStore,
        //             );
        //             $insert_cust_docs = DB::table('customer_documents')->insertGetId($cust_docs_arr);
        //         }    
        //     } 
        // }	

        $request->session()->flash('message', 'Customer Updated Successfully.');
        return redirect()->route('customers.index');
    }

       /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = $request->all();  
        $id = $data['id'];
        // if delete request is for remove doument for removing document
      
        if($data['type'] == 'remove_document'){
            //here $id is primary id of document table
            $custDocs = CustomerDocuments::find($id);
            $curr_doc = $custDocs->uploaded_document;
            $customer_id = $custDocs->customer_id;
            $customer = Customers::find($customer_id);
            // echo $customer_id.' - '.$curr_doc;exit;
            $custDocs->delete();
            $path = public_path('storage/trash/hotel_admins/'.$customer->created_by.'/removed_customer_documents/'.$customer_id);
            if(!File::isDirectory($path)){
                File::makeDirectory($path, 0777, true, true);
            }
            $existing_file_path = public_path('storage/uploads/hotel_admins/'.$customer->created_by.'/'.'customer_documents/'.$customer_id.'/'.$curr_doc);
            $trash_file_path_dir = public_path('storage/trash/hotel_admins/'.$customer->created_by.'/'.'removed_customer_documents/'.$customer_id.'/'.$curr_doc);
        
            File::move($existing_file_path, $trash_file_path_dir);

            $docs = DB::table('customer_documents')->where('customer_id',$customer_id)->where('deleted_at',null)->get();
            $docs_array_updated = array();
            if($docs){
                $docs_array = $docs;
                foreach($docs_array as $doc){
                    $path = 'public/storage/uploads/hotel_admins/'.$customer->created_by.'/'.'customer_documents/'.$customer->id.'/'.$doc->uploaded_document;
                    $doc->uploaded_document= $path;
    
                    //get doc type
                    $types = IdProofTypes::find($doc->document_type);
                    $doc->document_type = $types->title;
                    $docs_array_updated[] = $doc;
                }
            } else {
                $docs_array_updated = array();
            }
            $baseUrl = url('/');
            $tbl = "<table class='table table-striped table-bordered datatable docs'>
                            <thead>
                                <tr>
                                    <th>Document Type</th>
                                    <th>Number</th>
                                    <th>Uploaded File</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>";
            if(!empty($docs_array_updated)){
                foreach($docs_array_updated as $docs){
                    $tbl .=   "<tr>
                                    <td>".$docs->document_type."</td>
                                    <td>".$docs->number."</td>
                                    <td><img src='{$baseUrl}/{$docs->uploaded_document}' style='width: 50px;'></td>
                                    <td>
                                        <a data-toggle='tooltip' data-placement='top' title='View Document' href='{$baseUrl}/{$docs->uploaded_document}' target='_blank' style='color: black;'><i class='fa fa-eye' aria-hidden='true' id='doc_{$docs->id}'></i></a>
                                        <button style='padding: 0;border: none;background: none;' class='remove-doc' id='{$docs->id}' data-toggle='tooltip' data-placement='top' title='Remove Document' ><i class='fa fa-trash' style='font-size: 20px;margin-left: 9px;'></i></button>
        
                                    </td>
                                </tr>";
                }
            } else {
                $tbl .=   "<tr><td>No documents found</td>
                <td></td>
                <td></td>
                <td></td></tr>";
            }
            $tbl .= "</tbody></html>";
            return response()->json(array('success'=>true, 'html'=>$tbl));

        } else if($data['type'] == 'remove_note'){//remove note
            $notes_array = array('deleted_at'=>'1');
            $notes_info = DB::table('customer_notes')->where('id', $id)->first();
            $cid =$notes_info->customer_id;
            $cid = DB::table('customer_notes')->where('id', $id)->update($notes_array);
            $all_notes = DB::table('customer_notes')->where('customer_id',$cid)->where('deleted_at','0')->get();
            
            $request->session()->flash('message', 'Customer Deleted Successfully.');
            $tbl = "<table class='table table-striped table-bordered datatable docs'>
            <thead>
                <tr>
                    <th>Date & Time</th>
                    <th>Note</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>'";
            if(!empty($all_notes)){
                foreach($all_notes as $note){
                    $tbl .=   "'<tr>
                    <td>".$note->date_time."</td>
                    <td>".$note->note."</td>
                    <td>
                        <button style='padding: 0;border: none;background: none;' class='remove-note' id='{$note->id}'  data-toggle='tooltip' data-placement='top' title='Remove Note' ><i class='fa fa-trash' style='font-size: 20px;margin-left: 9px;'></i></button>
                    </td>
                </tr>";
                }
            } else {
                $tbl .=   "<tr><td>No Notes found</td>
                <td></td>
                <td></td></tr>";
            }
            $tbl .= "</tbody></html>";
            return response()->json(array('success'=>true, 'html'=>$tbl));
        } else {    
            //here $id is for primary id of customer table for deleteing customer
            $customer = Customers::find($id);
            if($customer){
                $customer->delete();
            } 
            $request->session()->flash('message', 'Customer Deleted Successfully.');
            return redirect()->route('customers.index');
        }        
    }

   /*
    Save the customers additional info
    */
    public function saveAdditionalInfo(Request $request)
    { 
        $data = $request->all();  
        $validatedData = $request->validate([
        ]);
        // echo "<pre>";print_r($data);exit;
        $rooms = Room::all();
        $id_proof_type = IdProofTypes::all();

        $recent = Customers::orderBy('id','desc')->first();
        $recent_cust_id = $recent->id;

        $docs = DB::table('customer_documents')->where('customer_id',$recent_cust_id)->where('deleted_at',null)->get();
        $docs_array = array();
        $hotel_admin_id = Auth::user()->id;
        //Create hotel admin folder if not exists
        $hotel_admin_path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id);
        if(!File::isDirectory($hotel_admin_path)){
            File::makeDirectory($hotel_admin_path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents', 0777, true, true);//create  customer_documents folder
        }
        
        // create or update file in directory if exists in hotel admin folder
        $path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$recent_cust_id);
        if(!File::isDirectory($path)){
            File::makeDirectory($path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$recent_cust_id.'/display_picture', 0777, true, true);
        }

        //customer profile image path
        $recent->profile_image = 'public/storage/uploads/hotel_admins/'.$recent->created_by.'/customer_documents'.'/'.$recent->id.'/display_picture'.'/'.$recent->profile_image;
        if($docs){
            $docs_array = $docs;
            foreach($docs_array as $doc){
                $path = 'public/storage/uploads/hotel_admins/'.$recent->created_by.'/'.'customer_documents/'.$recent->id.'/'.$doc->uploaded_document;
                $doc->uploaded_document= $path;
            }
        } else {
            $docs_array = array();
        }

        //complaint found if any for complaint tab
        $complaintExists = DB::table('customers as cs')
                            ->select('cs.id','cs.passport_number')
                            ->join('complaints as cp','cp.complaint_against','=','cs.id','left')
                            ->where('cs.passport_number',$recent->passport_number)
                            ->orWhere('cs.first_name', 'like', '%' . $recent->first_name . '%')
                            ->orWhere('cs.last_name', 'like', '%' . $recent->last_name . '%')
                            ->get();
        $complaint_cust_str = '';
        if(!empty($complaintExists)){
            foreach($complaintExists as $cust ){
                $complaints_list = Complaints::where('complaint_against',$cust->id)->first();
                if(!empty($complaints_list)){
                    if($cust->passport_number == $recent->passport_number){
                        $complaint_cust_str .= $cust->id.',';
                    }
                }
            }
        }
        
        //complaint found if any for complaint tab
        $criminalExists = DB::table('criminal_records as cr')
        ->select('id')
        ->orWhere('first_name', 'like', '%' . $recent->first_name . '%')
        ->orWhere('last_name', 'like', '%' . $recent->last_name . '%')
        ->get();
        $crminal_cust_str = '';
        foreach($criminalExists as $cust ){
            $crminal_cust_str .= $recent_cust_id.',';
        }

        // return $recent_cust_id;
        return response()->json(array('cust_id'=>$recent_cust_id, 'cust_complaints'=>$complaint_cust_str,'crminal_cust_str'=>$crminal_cust_str));
    }

    public function saveBasicInfo(Request $request)
    { 
        $data = $request->all();  
        $validatedData = $request->validate([
            'full_name'      => 'required|min:1|max:64',
            // 'last_name'       => 'required|min:1|max:64',
            // 'nationality'     => 'required',
            // 'checkin_date'    => 'required',
            // 'checkin_time'    => 'required',
            // 'email'           => 'required|email|unique:customers',
            // 'mobile'          => 'required|max:10',
            // 'passport_number'=> 'required',
            // 'profile_pic' => 'simage|mimes:jpg,png,jpeg|max:2048',
        ]);
        // echo "<pre>";print_r($data);exit;
        $rooms = Room::all();
        $id_proof_type = IdProofTypes::all();

        //insert new hotel admin in users table
        // $customer = new Customers();
        // //for basic info tab details
        // $customer->first_name    = $request->input('first_name');
        // $customer->middle_name    = $request->input('middle_name');
        // $customer->last_name    = $request->input('last_name');
        // $customer->email   =  $request->input('email');
        // $customer->mobile   =  $request->input('mobile');
        // $customer->date_of_birth   =  $request->input('date_of_birth');
        // $customer->gender   =  $request->input('gender');
        // $customer->room_id   =  $request->input('room_id');
        // $customer->nationality   =  $request->input('nationality');
        // $customer->checkin_date_time   =  $request->input('checkin_date').' '.$request->input('checkin_time');
        // $customer->checkout_date_time   =  $request->input('checkout_date').' '.$request->input('checkout_time');
        // $customer->passport_expiry_date   =  $request->input('passport_expiry_date');
        // $customer->country_of_issue   =  $request->input('country_of_issue');
        // $customer->passport_number   =  $request->input('passport_number');
        // $customer->property_id   =  $request->input('property_id');
        // $customer->created_by = Auth::user()->id;
        // $customer->save();
        //get recently adde cust
        // $recent = Customers::where('full_name',$request->input('email'))->first();
        // $recent_cust_id = $recent->id;

        $recent = Customers::orderBy('id','desc')->first();
        $recent_cust_id = $recent->id;


        $docs = DB::table('customer_documents')->where('customer_id',$recent_cust_id)->where('deleted_at',null)->get();
        $docs_array = array();
        $hotel_admin_id = Auth::user()->id;
        //Create hotel admin folder if not exists
        $hotel_admin_path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id);
        if(!File::isDirectory($hotel_admin_path)){
            File::makeDirectory($hotel_admin_path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents', 0777, true, true);//create  customer_documents folder
        }
        
        // create or update file in directory if exists in hotel admin folder
        $path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$recent_cust_id);
        if(!File::isDirectory($path)){
            File::makeDirectory($path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$recent_cust_id.'/display_picture', 0777, true, true);
        }

        // //for customer dp
        // if ($request->hasFile('profile_pic')) {

        //     $filenameWithExt = $request->file('profile_pic')->getClientOriginalName ();
        //     // Get Filename
        //     $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        //     // Get just Extension
        //     $extension = $request->file('profile_pic')->getClientOriginalExtension();
        //     // Filename To store
        //     $fileNameToStore = $filename. '_'. time().'.'.$extension;
        //     // Upload Image$path = 
        //     $img = $request->file('profile_pic')->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/customer_documents'.'/'.$recent_cust_id.'/display_picture', $fileNameToStore);
        //     $dp_array = array('profile_image'=>$fileNameToStore,);
        //     DB::table('customers')->where('id', $recent_cust_id)->update($dp_array);
            
        // } else {
        //     $fileNameToStore = '';
        //     $img = '';
        // }

        //customer profile image path
        $recent->profile_image = 'public/storage/uploads/hotel_admins/'.$recent->created_by.'/customer_documents'.'/'.$recent->id.'/display_picture'.'/'.$recent->profile_image;
        if($docs){
            $docs_array = $docs;
            foreach($docs_array as $doc){
                $path = 'public/storage/uploads/hotel_admins/'.$recent->created_by.'/'.'customer_documents/'.$recent->id.'/'.$doc->uploaded_document;
                $doc->uploaded_document= $path;
            }
        } else {
            $docs_array = array();
        }

        //complaint found if any for complaint tab
        $complaintExists = DB::table('customers as cs')
                            ->select('cs.id','cs.passport_number')
                            ->join('complaints as cp','cp.complaint_against','=','cs.id','left')
                            ->where('cs.passport_number',$recent->passport_number)
                            ->orWhere('cs.first_name', 'like', '%' . $recent->first_name . '%')
                            ->orWhere('cs.last_name', 'like', '%' . $recent->last_name . '%')
                            ->get();
        $complaint_cust_str = '';
        if(!empty($complaintExists)){
            foreach($complaintExists as $cust ){
                $complaints_list = Complaints::where('complaint_against',$cust->id)->first();
                if(!empty($complaints_list)){
                    if($cust->passport_number == $recent->passport_number){
                        $complaint_cust_str .= $cust->id.',';
                    }
                }
            }
        }
        
        //complaint found if any for complaint tab
        $criminalExists = DB::table('criminal_records as cr')
        ->select('id')
        ->orWhere('first_name', 'like', '%' . $recent->first_name . '%')
        ->orWhere('last_name', 'like', '%' . $recent->last_name . '%')
        ->get();
        $crminal_cust_str = '';
        foreach($criminalExists as $cust ){
            $crminal_cust_str .= $recent_cust_id.',';
        }

        // return $recent_cust_id;
        return response()->json(array('cust_id'=>$recent_cust_id, 'cust_complaints'=>$complaint_cust_str,'crminal_cust_str'=>$crminal_cust_str));

        // return view('dashboard.customers.create',['customer'=>$recent,'rooms'=>$rooms,'types'=>$id_proof_type,'docs'=>$docs_array]);
    }
   /*
    Save the customers note info
    */
    public function saveNotesInfo(Request $request)
    { 
        $customer_id = $request->input('note_customer_id');
        $w_customer_id = $request->input('customer_id');
        // echo $customer_id.' - '.$w_customer_id;exit;
        $hotel_admin_id = Auth::user()->id;
        $data = $request->all();  
        $customer = Customers::find($customer_id);
        $notes_array = array('customer_id'=>$customer_id,'note'=>$data['note']);
        $insert_cust_docs = DB::table('customer_notes')->insertGetId($notes_array);
        $all_notes = DB::table('customer_notes')->where('customer_id',$customer_id)->where('deleted_at','0')->get();
        $all_notes_arr = array();
        
        $tbl = "<table class='table table-striped table-bordered datatable docs'>
        <thead>
            <tr>
                <th>Date & Time</th>
                <th>Note</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>'";
        if(!empty($all_notes)){
    
            foreach($all_notes as $note){
                $tbl .=   "'<tr>
                <td>".$note->date_time."</td>
                <td>".$note->note."</td>
                <td>
                    <button style='padding: 0;border: none;background: none;' class='remove-note' id='{$note->id}' data-toggle='tooltip' data-placement='top' title='Remove Note' ><i class='fa fa-trash' style='font-size: 20px;margin-left: 9px;'></i></button>

                </td>
            </tr>";
            }
        } else {
            $tbl .= "<tr><td>Notes not found</td>
            <td></td>
            <td></td></tr>";
        }
        $tbl .= '</tbody></table>';
        return response()->json(array('success'=>true, 'html'=>$tbl));
    }
     
    /*
    Save the customers document info
    */
    public function saveDocumentInfo(Request $request)
    { 
        $customer_id = $request->input('customer_id');
        $hotel_admin_id = Auth::user()->id;

        $customer = Customers::find($customer_id);
        $rooms = Room::all();
        $id_proof_type = IdProofTypes::all();
        $countries = Country::all();
        //for custoomer uploaded document
        //Create hotel admin folder if not exists
        $hotel_admin_path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id);
        if(!File::isDirectory($hotel_admin_path)){
            File::makeDirectory($hotel_admin_path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents', 0777, true, true);//create  customer_documents folder
        }
        
        // create or update file in directory if exists in hotel admin folder
        $path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$customer_id);
        if(!File::isDirectory($path)){
            File::makeDirectory($path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$customer_id.'/display_picture', 0777, true, true);
        }

        //for customer dp
        if ($request->hasFile('profile_pic')) {

            $filenameWithExt = $request->file('profile_pic')->getClientOriginalName ();
            // Get Filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $extension = $request->file('profile_pic')->getClientOriginalExtension();
            // Filename To store
            $fileNameToStore = $filename. '_'. time().'.'.$extension;
            // Upload Image$path = 
            $img = $request->file('profile_pic')->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents'.'/'.$customer_id.'/display_picture', $fileNameToStore);
            $dp_array = array('profile_image'=>$fileNameToStore,);
            DB::table('customers')->where('id', $customer_id)->update($dp_array);
    
        } else {
            $fileNameToStore = '';
            $img = '';
        }

        $cnt = count($request->input('document_type'));
        $cust_docs_arr = array();
        for ($i=0; $i < $cnt; $i++){
            //store uploaded docs
            if ($request->hasFile('uploaded_document')) {

                    // Get filename with the extension
                $custDocsfilenameWithExt = $request->file('uploaded_document')[$i]->getClientOriginalName();
                // Get Filename
                $custDocfilename = pathinfo($custDocsfilenameWithExt, PATHINFO_FILENAME);
                // Get just Extension
                $custDocsextension = $request->file('uploaded_document')[$i]->getClientOriginalExtension();
                // 
                $custDocsfileNameToStore = $custDocfilename. '_'. time().'.'.$custDocsextension;
            
                $cust_doc = $request->file('uploaded_document')[$i]->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents'.'/'.$customer_id,$custDocsfileNameToStore);
            }else if($request->input('docs_image') !=''){//webcam image
                $web_cam_image = $request->input('docs_image');
                $image_parts = explode(";base64,", $web_cam_image);
                $image_type_aux = explode("image/", $image_parts[0]);
                $image_type = $image_type_aux[1];
              
                $image_base64 = base64_decode($image_parts[1]);
                $custDocsfileNameToStore = uniqid() . '.png';
         
                $baseUrl = url('/');
                $file_path = 'storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents'.'/'.$customer_id.'/';
               
                $file = $file_path . $custDocsfileNameToStore; //echo $file;exit;
                file_put_contents($file, $image_base64);
            
            } else {
                $custDocsfileNameToStore = '';
                $cust_doc = '';
            }
        
            $cust_docs_arr = array(
                'customer_id'=>$customer_id,
                'document_type'=>$request->input('document_type')[$i],
                'number'=>$request->input('number')[$i],
                'uploaded_document'=>$custDocsfileNameToStore,
            );
            $insert_cust_docs = DB::table('customer_documents')->insertGetId($cust_docs_arr);
        }

        $docs = DB::table('customer_documents')->where('customer_id',$customer_id)->where('deleted_at',null)->get();
        $docs_array_updated = array();
        
          if($docs){
            $docs_array = $docs;
            foreach($docs_array as $doc){
                $path = 'public/storage/uploads/hotel_admins/'.$customer->created_by.'/'.'customer_documents/'.$customer->id.'/'.$doc->uploaded_document;
                $doc->uploaded_document= $path;

                 //get doc type
                 $types = IdProofTypes::find($doc->document_type);
                 $doc->document_type = $types->title;

                $docs_array_updated[] = $doc;
            }
        } else {
            $docs_array_updated = array();
        }

        $baseUrl = url('/');
        $tbl = "<table class='table table-striped table-bordered datatable docs'>
                                <thead>
                                    <tr>
                                        <th>Document Type</th>
                                        <th>Number</th>
                                        <th>Uploaded File</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>'";
                if(count($docs_array_updated) > 0){
                    foreach($docs_array_updated as $docs){
                        $tbl .=   "'<tr>
                                        <td>".$docs->document_type."</td>
                                        <td>".$docs->number."</td>
                                        <td><img src='{$baseUrl}/{$docs->uploaded_document}' style='width: 50px;'></td>
                                        <td>
                                            <a data-toggle='tooltip' data-placement='top' title='View Document' href='{$baseUrl}/{$docs->uploaded_document}' target='_blank' style='color: black;'><i class='fa fa-eye' aria-hidden='true' id='doc_{$docs->id}'></i></a>
                                            <button style='padding: 0;border: none;background: none;' class='remove-doc' id='{$docs->id}' data-toggle='tooltip' data-placement='top' title='Remove Document' ><i class='fa fa-trash' style='font-size: 20px;margin-left: 9px;'></i></button>
            
                                        </td>
                                    </tr>";
                    }
                } else {
                    $tbl .= "<tr><td>No documents found</td>
                    <td></td>
                    <td></td>
                    <td></td></tr>";
                }
    
                $tbl .= '</tbody></table>';
        return response()->json(array('success'=>true, 'html'=>$tbl));
        // return view('dashboard.customers.edit', ['rooms'=>$rooms, 'customer' => $customer,'docs'=>$docs_array ,'types'=>$id_proof_type,'countries'=>$countries]);
    }
    public function getNotes(Request $request)
    { 
        $data = $request->all();
    }
    
     /* load the customers document info */
     public function show(Request $request)
     { 
        $data = $request->all();

        //for filters
        if(array_key_exists('filters',$data) == true){
            return  $this->getPropertyFilterVal($data);
        }

        //for customer details view
        if(array_key_exists('type',$data) == false && !empty($data)){
            // if($data['type'] != 'get_complaints'){
                return  $this->viewCustomerDetails($data);
            // }
        }
       
        //for complaints list in customr 
        if(!empty($data)  && $data['type'] == 'get_complaints'    ){
            return  $this->getComplaints($data);
        }
        
        //for criminal list in customr 
        if(!empty($data)  &&  $data['type'] == 'get_criminal_record' ){
            return  $this->getCriminalRecord($data);
        }

         //for criminal list in customr 
         if(!empty($data)  && $data['type'] == 'criminal_view'){
            return  $this->getCriminalRecordDetails($data);
        }
        
        
        if(!empty($data)  &&  $data['type'] == 'get_document'){//for getting customers docs
            
            $customer_id = $data['id'];
            $customer = Customers::find($customer_id);
            $docs = DB::table('customer_documents')->where('customer_id',$customer_id)->where('deleted_at',null)->get();
            $docs_array = array();
            $baseUrl = url('/');
                foreach($docs as $doc){
                    $path = $baseUrl.'/public/storage/uploads/hotel_admins/'.Auth::user()->id.'/'.'customer_documents/'.$customer_id.'/'.$doc->uploaded_document;
                    $doc->action ='';
                    $doc->action ='<a data-toggle="tooltip" data-placement="top" title="View Document" href="'.$path.'" target="_blank" style="color: black;" class="anchordoc"><i class="fa fa-eye" aria-hidden="true" id="doc_'.$doc->id.'"></i></a><button style="padding: 0;border: none;background: none;" class="remove-doc" id="'.$doc->id.'" data-toggle="tooltip" data-placement="top" title="Remove Document" ><i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>'; 
                    
                    //get doc type
                    $types = IdProofTypes::find($doc->document_type);
                    $doc->document_type = $types->title;
                }
            
                $docs = DB::table('customer_documents')->where('customer_id',$customer_id)->where('deleted_at',null)->get();
                $docs_array_updated = array();
                if($docs){
                    $docs_array = $docs;
                    foreach($docs_array as $doc){
                        $path = 'public/storage/uploads/hotel_admins/'.$customer->created_by.'/'.'customer_documents/'.$customer->id.'/'.$doc->uploaded_document;
                        $doc->uploaded_document= $path;
        
                        //get doc type
                        $types = IdProofTypes::find($doc->document_type);
                        $doc->document_type = $types->title;
                        $docs_array_updated[] = $doc;
                    }
                } else {
                    $docs_array_updated = array();

                }
                $baseUrl = url('/');
                $tbl = "<table class='table table-striped table-bordered datatable docs'>
                                <thead>
                                    <tr>
                                        <th>Document Type</th>
                                        <th>Number</th>
                                        <th>Uploaded File</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>'";
                if(count($docs_array_updated) > 0){
                    foreach($docs_array_updated as $docs){
                        $tbl .=   "'<tr>
                                        <td>".$docs->document_type."</td>
                                        <td>".$docs->number."</td>
                                        <td><img src='{$baseUrl}/{$docs->uploaded_document}' style='width: 50px;'></td>
                                        <td>
                                            <a data-toggle='tooltip' data-placement='top' title='View Document' href='{$baseUrl}/{$docs->uploaded_document}' target='_blank' style='color: black;' class='anchordoc' ><i class='fa fa-eye' aria-hidden='true' id='doc_{$doc->id}'></i></a>
                                            <button style='padding: 0;border: none;background: none;' class='remove-doc' id='{$docs->id}'  data-toggle='tooltip' data-placement='top' title='Remove Document' ><i class='fa fa-trash' style='font-size: 20px;margin-left: 9px;'></i></button>
            
                                        </td>
                                    </tr>";
                    }
                } else {
                    $tbl .=   "<tr><td>No documents found</td>
                    <td></td>
                    <td></td>
                    <td></td></tr>";
                }
    
                $tbl .= '</tbody></table>';
                return response()->json(array('success'=>true, 'html'=>$tbl));

        }else if(!empty($data)  &&  $data['type'] == 'get_notes'){//for getting customers docs
            
            $customer_id = $data['id'];
            $customer = Customers::find($customer_id);
            $notes = DB::table('customer_notes')->where('customer_id',$customer_id)->where('deleted_at',null)->get();
            $notes_array = array();
                foreach($notes as $note){
                    $notes_array[] = $note;
                }
                
                $tbl = "<table class='table table-striped table-bordered datatable docs'>
                                <thead>
                                    <tr>
                                        <th>Date & Time</th>
                                        <th>Note</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>'";
                if(count($notes_array) > 0){
                    foreach($notes_array as $not){
                        $tbl .=   "'<tr>
                                        <td>".$not->date_time."</td>
                                        <td>".$not->note."</td>
                                        <td>
                                            <button style='padding: 0;border: none;background: none;' class='remove-note' id='{$not->id}'  data-toggle='tooltip' data-placement='top' title='Remove Note' ><i class='fa fa-trash' style='font-size: 20px;margin-left: 9px;'></i></button>
                                        </td>
                                    </tr>";
                    }
                } else {
                    $tbl .=   "<tr><td>No Notes found</td>
                    <td></td>
                    <td></td></tr>";
                }
    
                $tbl .= '</tbody></table>';
                return response()->json(array('success'=>true, 'html'=>$tbl));

        } else if(!empty($data)  &&  $data['type'] == 'export'){ //for customers export
            $export_file =  $this->export($data);
            return $export_file;
        }
    }

    // export customer
    public function export($datas)
     { 
        $headers = [                 
            'Cache-Control'       => 'must-revalidate, post-check=0, pre-check=0',
            'Content-type'        => 'text/x-csv',
            'Content-Disposition' => 'attachment; filename=galleries.csv',
            'Expires'             => '0',
            'Pragma'              => 'public',
        ];

        if(array_key_exists('stay_vals',$datas)){
            if($datas['stay_vals'] == 1){  //get customers only checked in currently
                $data = Customers::where('checkout_date_time','')->orderBy('id','desc')->get();
            } else {//get customer datewise
                $data = Customers::orderBy('id','desc')->get();
            }
        } 
        if(array_key_exists('property_id',$datas) && $datas['property_id'] > 0){
            $data = Customers::where('checkout_date_time','')->where('property_id',$datas['property_id'])->orderBy('id','desc')->get();
        } else {
            $data = Customers::where('checkout_date_time','')->orderBy('id','desc')->get();
        }

        foreach($data as $customer){
            //create full name 
            $customer->first_name =  $customer->first_name.' '.$customer->last_name;
            //get room title
            $room_details = Room::find($customer->room_id);
            $customer->room_id =  $room_details->title;

            //get country title
            $country_title = Country::find($customer->nationality);
            $customer->nationality = $country_title->name;
            
            //get customer id
            $id = $customer->id;

            //check if date range is requested and get customer accordingly
            if(array_key_exists('stay_vals',$datas)){
                if($datas['stay_vals'] == 2){  
                    $from = $datas['from_date'].' 00:00:00';
                    $to = $datas['to_date'].' 00:00:00'; 
                    if($customer->checkin_date_time < $from && $customer->checkout_date_time > $to ){
                    $customer = $customer;
                    } else {
                    $customer = array();
                    }
                }
            }
        }

        $columns = array('Name', 'Room', 'Nationality', 'CheckIn DateTime', 'CheckoutDateTime');
    
        $callback = function() use ($data, $columns)
        {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);
    
            foreach($data as $cust) {
                $name = $cust->first_name.' '.$cust->last_name;
                fputcsv($file, array($name, $cust->room_id, $cust->nationality, $cust->checkin_date_time, $cust->checkout_date_time));
            }
            fclose($file);
        };
        return response()->streamDownload($callback, 'Customers-' . date('d-m-Y-H:i:s').'.csv', $headers);
    }
    
    //for view of customer details in govt admin
    public function viewCustomerDetails($data)
    { 
        // base64_encode
        // echo "<pre>";print_r($data);exit;
       $customer_id = base64_decode($data['id']);
       $customer = Customers::find($customer_id);
       $docs = DB::table('customer_documents')->where('customer_id',$customer_id)->where('deleted_at',null)->get();
       $docs_array = array();
       $baseUrl = url('/');
           foreach($docs as $doc){
               $path = $baseUrl.'/public/storage/uploads/hotel_admins/'.Auth::user()->id.'/'.'customer_documents/'.$customer_id.'/'.$doc->uploaded_document;
               $doc->action ='';
               $doc->action ='<a data-toggle="tooltip" data-placement="top" title="View Document" href="'.$path.'" target="_blank" style="color: black;"><i class="fa fa-eye" aria-hidden="true" id="doc_'.$doc->id.'"></i></a><button style="padding: 0;border: none;background: none;" class="remove-doc" id="'.$doc->id.'" data-toggle="tooltip" data-placement="top" title="Remove Document" ><i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>'; 
               
               //get doc type
               $types = IdProofTypes::find($doc->document_type);
               $doc->document_type = $types->title;
           }
       
           //customer profile image path
           $customer->profile_image = 'public/storage/uploads/hotel_admins/'.$customer->created_by.'/customer_documents'.'/'.$customer->id.'/display_picture'.'/'.$customer->profile_image;

           //get gender 
           $customer->gender = ($customer->gender == 1) ? 'Male':'Female';

           //get country
           $countries = Country::find($customer->nationality);
           $customer->nationality = $countries->name;

           $country_of_issue = Country::find($customer->country_of_issue);
           $customer->country_of_issue = $countries->country_of_issue;

           //get property detial
           $property = Properties::find($customer->property_id);
           $customer->property_id = $property->name;

           //get property owner
           $property_owner = HotelAdmin::find($property->owner);
           $property->owner = $property_owner->first_name.' '.$property_owner->last_name;

           //get property country
           $prop_country = Country::find($property->country);
           $property->country = $prop_country->name;

           //get ciust docs
           $docs = DB::table('customer_documents')->where('customer_id',$customer_id)->where('deleted_at',null)->get();
           $docs_array_updated = array();
           if($docs){
               $docs_array = $docs;
               foreach($docs_array as $doc){
                   $path = $baseUrl.'/public/storage/uploads/hotel_admins/'.$customer->created_by.'/'.'customer_documents/'.$customer->id.'/'.$doc->uploaded_document;
                   $doc->uploaded_document= $path;
   
                   //get doc type
                   $types = IdProofTypes::find($doc->document_type);
                   $doc->document_type = $types->title;
                   $docs_array_updated[] = $doc;
               }
           } else {
               $docs_array_updated = array();
           }
      return view('dashboard.customers.viewdetails',['customer'=>$customer,'docs'=>$docs_array_updated,'property'=>$property]);
    }

    //for complaints
    public function getComplaints($data){
        //get complaints
        $ids_array = explode(',',$data['cust_ids']);
        $baseUrl = url('/');
        $complaint_array_updated = array();
        foreach($ids_array as $id){
            $complaints_list = Complaints::where('complaint_against',$id)->get();
            foreach($complaints_list as $complaint){
                $id = $complaint->id;
                //get complaint against
                $complaint_against = Customers::find($complaint->complaint_against);
                $complaint->complaint_against = $complaint_against->first_name.' '.$complaint_against->last_name;
                
                //get passport number 
                $complaint->passport_number = '';
                $complaint->passport_number = $complaint_against->passport_number;

                //get complaint from
                $hotel_admin_id = $complaint->complaint_from;
                $complaint_from = HotelAdmin::where('main_user_id',$complaint->complaint_from)->first();
                $complaint->complaint_from = $complaint_from->first_name.' '.$complaint_from->last_name;
                
                $complaint->document  = $baseUrl.'/public/storage/uploads/hotel_admins/'.$hotel_admin_id.'/complaints_doccument'.'/'.$complaint_against->id.'/'.$complaint->document;
                $complaint_array_updated[] = $complaint;
            }
        }
        
        $tbl = "<table class='table table-striped table-bordered datatable docs'>
                    <thead>
                        <tr>
                            <th width='25%'>Complaint Against</th>
                            <th width='25%'>Complaint From</th>
                            <th width='25%''>Title</th>
                            <th>Passport Numbe </th>
                            <th>Description</th>
                            <th width='25%''>Action</th>
                        </tr>
                    </thead>
                    <tbody>'";
        if(count($complaint_array_updated) > 0){
            foreach($complaint_array_updated as $comp){
            $tbl .= "'<tr>
                        <td>".$comp->complaint_against."</td>
                        <td>".$comp->complaint_from."</td>
                        <td>".$comp->title."</td>
                        <td>".$comp->passport_number."</td>
                        <td>".$comp->description."</td>
                        <td>
                            <a data-toggle='tooltip' data-placement='top' title='View Document' href='{$comp->document}' target='_blank' style='color: black;'><i class='fa fa-eye' aria-hidden='true' id='doc_{$comp->id}'></i></a>
                        </td>
                    </tr>";
            }
        } else {
            $tbl .= "<tr><td>No documents found</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>";
        }
        
            $tbl .= '</tbody></table>';
            return response()->json(array('success'=>true, 'html'=>$tbl));
    }


        //for criminal
        public function getCriminalRecord($data){
            //get complaints
            $ids_array = explode(',',$data['cust_ids']);
            $baseUrl = url('/');
            $criminal_array_updated = array();
            foreach($ids_array as $id){
                if($id){
                    //get customer fname and lname
                    $customer_details = Customers::select('first_name','last_name')->where('id',$id)->first();
                    // echo "<pre>";print_R($customer_details);exit;
                    $criminal_details = CriminalRecords::where('first_name',$customer_details->first_name)->orWhere('last_name',$customer_details->last_name)->get();
                
                    foreach($criminal_details as $criminal){
                        $criminal->name = $criminal->first_name.' '.$criminal->last_name;

                        $criminal->image  = $baseUrl.'/public/storage/uploads/criminal_records/'.$criminal->image;
                        $criminal_array_updated[] = $criminal;
                    }
                }
            }
            
            $tbl = "<table class='table table-striped table-bordered datatable docs'>
                        <thead>
                            <tr>
                                <th width='25%'>Name</th>
                                <th width='25%'>File Number</th>
                                <th width='25%''>Record ID</th>
                                <th>Description</th>
                                <th>Institution</th>
                                <th width='25%''>Action</th>
                            </tr>
                        </thead>
                        <tbody>'";
            if(count($criminal_array_updated) > 0){
                foreach($criminal_array_updated as $crime){
                    $record_id = "{$crime->id}";
                $tbl .= "'<tr>
                            <td>".$crime->first_name.' '.$crime->last_name."</td>
                            <td>".$crime->file_number."</td>
                            <td>".$crime->record_id."</td>
                            <td>".$crime->description."</td>
                            <td>".$crime->institution."</td>
                            <td>
                                <button type='button' class='view_record'  data-record-id={$crime->id} style=padding: 0;border: none;background: none;' data-toggle='tooltip' data-placement='top' title=View Record details ><i class='fa fa-eye' style='font-size: 20px;'></i></button>
                            </td>
                        </tr>";
                }
            } else {
                $tbl .= "<tr><td>No documents found</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>";
            }
            
                $tbl .= '</tbody></table>';
                return response()->json(array('success'=>true, 'html'=>$tbl));
        }

    
    public function getPropertyFilterVal($data)
    { 
        //get property detial
        $property = Properties::find($data['property_id']);
        return $property->name;
    }

    public function getCriminalRecordDetails($data)
    { 
        $datas = CriminalRecords::find($data['id']);
        $baseUrl = url('/');
        
        $id = $datas->id;
        //get country
        $datas->country = '';
        $nationality = Country::find($datas->nationality);
        $datas->country = $nationality->name;

        //full name
        $datas->name = '';
        $datas->name = $datas->first_name.' '.$datas->last_name;

        //get gender 
        $datas->criminal_gender = '';
        $datas->criminal_gender = ($datas->gender == 1) ? 'Male':'Female';

        //get created date  $user->created_at->format('m/d/Y')
        $datas->created_on = '';
        $datas->created_on = $datas->created_at->format('d F Y');

        //get image
        $datas->image  = $baseUrl.'/public/storage/uploads/criminal_records/'.$datas->image;

        return response()->json( $datas);
    }

    
    
    //for dropzone in docs
    public function saave_docs_by_dropzone(Request $request){
        $datas = $request->all();
        // echo "<pre>AA";print_r($request->all());exit;
        $customer_id = $request->input('customer_id');
        $hotel_admin_id = Auth::user()->id;
        $customer = Customers::find($customer_id);
        //Create hotel admin folder if not exists
        $hotel_admin_path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id);
        if(!File::isDirectory($hotel_admin_path)){
            File::makeDirectory($hotel_admin_path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents', 0777, true, true);//create  customer_documents folder
        }
        
        // create or update file in directory if exists in hotel admin folder
        $path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$customer_id);
        if(!File::isDirectory($path)){
            File::makeDirectory($path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$customer_id.'/display_picture', 0777, true, true);
        }

        if(array_key_exists('dropzone',$datas) == true){
            $docs = $request->file('file'); 
            if (!empty($docs)) {
                $filenameWithExt = $request->file('file')->getClientOriginalName ();
                // Get Filename
                $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
                // Get just Extension
                $extension = $request->file('file')->getClientOriginalExtension();
                // Filename To store
                $fileNameToStore = $filename. '_'. time().'.'.$extension;
                $img = $request->file('file')->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/customer_documents'.'/'.$customer_id.'/', $fileNameToStore);
            } else {
                $fileNameToStore = '';
            }
        } else {
            $fileNameToStore = '';
        }

        $cust_docs_arr = array(
            'customer_id'=>$customer_id,
            'document_type'=>$request->input('document_type'),
            'number'=>$request->input('number'),
            'uploaded_document'=>$fileNameToStore,
        );
        $insert_cust_docs = DB::table('customer_documents')->insertGetId($cust_docs_arr);

        $docs = DB::table('customer_documents')->where('customer_id',$customer_id)->where('deleted_at',null)->get();
        $docs_array_updated = array();
        
          if($docs){
            $docs_array = $docs;
            foreach($docs_array as $doc){
                $path = 'storage/uploads/hotel_admins/'.$customer->created_by.'/'.'customer_documents/'.$customer->id.'/'.$doc->uploaded_document;
                $doc->uploaded_document= $path;

                 //get doc type
                 $types = IdProofTypes::find($doc->document_type);
                 $doc->document_type = $types->title;

                $docs_array_updated[] = $doc;
            }
        } else {
            $docs_array_updated = array();
        }

        $baseUrl = url('/');
        $tbl = "<table class='table table-striped table-bordered datatable docs'>
                                <thead>
                                    <tr>
                                        <th>Document Type</th>
                                        <th>Number</th>
                                        <th>Uploaded File</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>'";
                if(count($docs_array_updated) > 0){
                    foreach($docs_array_updated as $docs){
                        $tbl .=   "'<tr>
                                        <td>".$docs->document_type."</td>
                                        <td>".$docs->number."</td>
                                        <td><img src='{$baseUrl}/{$docs->uploaded_document}' style='width: 50px;'></td>
                                        <td>
                                            <a data-toggle='tooltip' data-placement='top' title='View Document' href='{$baseUrl}/{$docs->uploaded_document}' target='_blank' style='color: black;'><i class='fa fa-eye' aria-hidden='true' id='doc_{$docs->id}'></i></a>
                                            <button style='padding: 0;border: none;background: none;' class='remove-doc' id='{$docs->id}' data-toggle='tooltip' data-placement='top' title='Remove Document' ><i class='fa fa-trash' style='font-size: 20px;margin-left: 9px;'></i></button>
            
                                        </td>
                                    </tr>";
                    }
                } else {
                    $tbl .= "<tr><td>No documents found</td>
                    <td></td>
                    <td></td>
                    <td></td></tr>";
                }
    
                $tbl .= '</tbody></table>';
        return response()->json(array('success'=>true, 'html'=>$tbl));
    }
    
    
        public function update_basic_info(Request $request)
    {
        // echo "<pre>";print_r($request->all());exit;
        $new_cust_id = Customers::orderBy('id','desc')->first();
        $cust_id = $new_cust_id->id + 1;
        $datas = $request->all();
        $datas['custID'] = $cust_id;
        if(array_key_exists('edit_page',$datas) == false){
                    $insert = $this->insertBasicInfo($datas);
                    return $insert;
        }
        if(array_key_exists('dropzone',$datas) == true){
            $image = $request->file('file'); 
            if (!empty($image)) {
                $filenameWithExt = $request->file('file')->getClientOriginalName ();
                // Get Filename
                $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
                // Get just Extension
                $extension = $request->file('file')->getClientOriginalExtension();
                // Filename To store
                $fileNameToStore = $filename. '_'. time().'.'.$extension;
                $img = $request->file('file')->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/customer_documents'.'/'.$cust_id.'/display_picture', $fileNameToStore);
                
                $dp_array = array('profile_image'=>$fileNameToStore,);
                DB::table('customers')->where('id', $cust_id)->update($dp_array);
            }
            return true;
        }
    }
    
        public function updatte_profile_image(Request $request)
    { 
        $data = $request->all(); 
        if($request->input('webcam_image') !=''){
            $web_cam_image = $request->input('webcam_image');
            $image_parts = explode(";base64,", $web_cam_image);
            $image_type_aux = explode("image/", $image_parts[0]);
            $image_type = $image_type_aux[1];
          
            $image_base64 = base64_decode($image_parts[1]);
            $fileNameToStore = uniqid() . '.png';
     
            $baseUrl = url('/');
            $file_path = 'storage/uploads/hotel_admins/'.Auth::user()->id.'/customer_documents'.'/'.$request->input('customer_id') .'/'.'display_picture/';
           
            $file = $file_path . $fileNameToStore; //echo $file;exit;
            file_put_contents($file, $image_base64);
        
            // move_uploaded_file($fileNameToStore, $file_path.$fileNameToStore);
            $dp_array = array('profile_image'=>$fileNameToStore,);
            DB::table('customers')->where('id', $request->input('customer_id') )->update($dp_array);
     
        }
    }
    
    
    
    public function insertBasicInfo($data)
    { 
        //echo "<pre>";print_r($data);exit;
        $rooms = Room::all();
        $id_proof_type = IdProofTypes::all();

        //insert new hotel admin in users table
        $customer = new Customers();
        //for basic info tab details
        $customer->first_name    = $data['first_name'];
        $customer->middle_name    = $data['middle_name'];
        $customer->last_name    = $data['last_name'];
        $customer->email   =  $data['email'];
        $customer->mobile   =  $data['mobile'];
        $customer->date_of_birth   =  $data['date_of_birth'];
        $customer->gender   =  $data['gender'];
        $customer->nationality   =  $data['nationality'];
        $customer->passport_expiry_date   =  $data['passport_expiry_date'];
        $customer->country_of_issue   =  $data['country_of_issue'];
        $customer->passport_number   =  $data['passport_number'];

        //for address tab details
        $customer->address_line_1    = $data['address_line_1'];
        $customer->address_line_2    = $data['address_line_2'];
        $customer->city    =$data['city'];
        $customer->state   = $data['state'];
        $customer->pin   =  $data['pin'];
        $customer->country   =  $data['country'];

        $customer->created_by = Auth::user()->id;
        $customer->save();
        //get recently adde cust
        $recent = Customers::where('email',$data['email'])->first();
        $recent_cust_id = $recent->id;

        $docs = DB::table('customer_documents')->where('customer_id',$recent_cust_id)->where('deleted_at',null)->get();
        $docs_array = array();
        $hotel_admin_id = Auth::user()->id;
        //Create hotel admin folder if not exists
        $hotel_admin_path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id);
        if(!File::isDirectory($hotel_admin_path)){
            File::makeDirectory($hotel_admin_path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents', 0777, true, true);//create  customer_documents folder
        }
        
        // create or update file in directory if exists in hotel admin folder
        $path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$recent_cust_id);
        if(!File::isDirectory($path)){
            File::makeDirectory($path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$recent_cust_id.'/display_picture', 0777, true, true);
        }



        //for customer dp
        if (!empty($data['file'])) {

            $filenameWithExt = $data['file']->getClientOriginalName ();
            // Get Filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $extension = $data['file']->getClientOriginalExtension();
            // Filename To store
            $fileNameToStore = $filename. '_'. time().'.'.$extension;
            // Upload Image$path = 
            $img = $data['file']->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/customer_documents'.'/'.$recent_cust_id.'/display_picture', $fileNameToStore);
            $dp_array = array('profile_image'=>$fileNameToStore,);
            DB::table('customers')->where('id', $recent_cust_id)->update($dp_array);
            
        } else if(!empty($data['webcam_image'])){
            $web_cam_image = $data['webcam_image'];
            $image_parts = explode(";base64,", $web_cam_image);
            $image_type_aux = explode("image/", $image_parts[0]);
            $image_type = $image_type_aux[1];
          
            $image_base64 = base64_decode($image_parts[1]);
            $fileNameToStore = uniqid() . '.png';
     
            $baseUrl = url('/');
            $file_path = 'storage/uploads/hotel_admins/'.Auth::user()->id.'/customer_documents'.'/'.$customer->id.'/'.'display_picture/';
           
            $file = $file_path . $fileNameToStore; //echo $file;exit;
            file_put_contents($file, $image_base64);
        
            // move_uploaded_file($fileNameToStore, $file_path.$fileNameToStore);
            $dp_array = array('profile_image'=>$fileNameToStore,);
            DB::table('customers')->where('id', $customer->id)->update($dp_array);
     
        } else {
            $fileNameToStore = '';
            $img = '';
        }

        //customer profile image path
        $customer->profile_image = 'storage/uploads/hotel_admins/'.$customer->created_by.'/customer_documents'.'/'.$customer->id.'/display_picture'.'/'.$customer->profile_image;
        if($docs){
            $docs_array = $docs;
            foreach($docs_array as $doc){
                $path = 'storage/uploads/hotel_admins/'.$customer->created_by.'/'.'customer_documents/'.$customer->id.'/'.$doc->uploaded_document;
                $doc->uploaded_document= $path;
            }
        } else {
            $docs_array = array();
        }

        return $recent_cust_id;

        // return view('dashboard.customers.create',['customer'=>$recent,'rooms'=>$rooms,'types'=>$id_proof_type,'docs'=>$docs_array]);
    }

    public function getRoomsByProperty(Request $request)
    { 
        $data = $request->all();
        $all_prop_rooms = Room::where('property_id',$data['property_id'])->get();
        $html = "<option value='0'>Select Room</option>";
        if(!empty($all_prop_rooms)){
            foreach($all_prop_rooms  as $room){
                $html .= "<option value='".$room->id."'>".$room->title."</option>";
            }
        } else {
            $html = "<option value='0'>Room not available.</option>";

        }
        return response()->json(array('success'=>true, 'html'=>$html));
        
    }
    
}



