<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Customers;
use App\Models\Complaints;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use DataTables;
use File;


class ComplaintsController extends Controller
{

    /**
     * Show all complaints from hotel admin logged in
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {   
    
        if ($request->ajax()) {
            $data = Complaints::orderBy('id','desc')->where('created_by',Auth::user()->id)->get();
                foreach($data as $complaint){
                    $id = $complaint->id;
                    $complaint_against = Customers::find($complaint->complaint_against);
                    $complaint->complaint_against = $complaint_against->first_name.' '.$complaint_against->last_name;
                }
                $action =  '<button type="button" class="view_compliant"  data-record-id={{$id}} style="padding: 0;border: none;background: none;" data-toggle="tooltip" data-placement="top" title="View complaint details" ><i class="fa fa-eye" style="font-size: 20px;"></i></button>';
                return Datatables::of($data)
                        ->addColumn('action', $action)
                        ->rawColumns(['action'])
                        ->make(true);
        }
        return view('dashboard.complaints.complaintsList');
    }


        
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {   
        $data = $request->all(); 
        $customer = Customers::find($data['id']);
        $cust = array();
        return view('dashboard.customers.addcomplaint', [ 'customer' => $customer]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'title'      => 'required|min:1',
            'description'=> 'required|min:1|max:64',
            'document' => 'mimes:jpeg,png,jpg,pdf|min:1|max:1000',
        ]);
        $complaint_against = $request->input('complaint_against');
        $hotel_admin_id = Auth::user()->id;
        
        // create or update file in directory if exists in hotel admin folder
        $path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id.'/complaints_doccument/'.$complaint_against);
        if(!File::isDirectory($path)){
            File::makeDirectory($path, 0777, true, true);
        }

        //for complaint document
        if ($request->hasFile('document')) {

            $filenameWithExt = $request->file('document')->getClientOriginalName ();
            // Get Filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $extension = $request->file('document')->getClientOriginalExtension();
            // Filename To store
            $fileNameToStore = $filename. '_'. time().'.'.$extension;
            // Upload Image$path = 
            $img = $request->file('document')->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/complaints_doccument'.'/'.$complaint_against, $fileNameToStore);    
        } else {
            $fileNameToStore = '';
            $img = '';
        }

        //insert new complaint
        $complaint = new Complaints();
        $complaint->title    = $request->input('title');
        $complaint->description   =  $request->input('description');
        $complaint->complaint_against   =  $complaint_against;
        $complaint->complaint_from   =  $hotel_admin_id;
        $complaint->document   = $fileNameToStore;
        $complaint->created_by   = $hotel_admin_id;
        $complaint->save();

        $request->session()->flash('message', 'Complaint Created Successfully.');

        return redirect()->route('customers.index');
    }

    public function show(Request $request)
    {
        $data = $request->all();
        if(array_key_exists('type',$data) != false){
            return  $this->getComplaintDetails($data);
        }
    }
    public function getComplaintDetails($data)
    { 
        $datas = Complaints::find($data['id']);
            $baseUrl = url('/');
            $id = $datas->id;
            $complaint_against = Customers::find($datas->complaint_against);
            $datas->complaint_against = $complaint_against->first_name.' '.$complaint_against->last_name;
            $datas->document  = $baseUrl.'/public/storage/uploads/hotel_admins/'.$datas->complaint_from.'/complaints_doccument'.'/'.$complaint_against->id.'/'.$datas->document;
            
            // $datas->document = '<a href="{{$document}}"  target="_blank">View Document</a>';
        return response()->json( $datas);
    }
    

}
