@extends('dashboard.base')

@section('content')

<div class="container-fluid">
    <div class="fade-in">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header"><h4>Manage My Profile</h4></div>
                        <div class="card-body">
                            @if(Session::has('message'))
                                <div class="row">
                                    <!-- <div class="col-12">
                                        <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                                    </div> -->
                                    <div class="alert alert-success alert-dismissible fade show" role="alert">{{ Session::get('message') }}
                                        <button class="close" type="button" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
                                    </div>
                                </div>
                            @endif     

                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                            <form method="POST" action="/myprofile/{{ $user->id }}"  enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>First Name</label>
                                            <input type="text" placeholder="Enter Your First Name" name="first_name" class="form-control" required value="{{ $user->first_name }}">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Last Name</label>
                                            <input type="text" placeholder="Enter Your Last Name" name="last_name" class="form-control" required value="{{ $user->last_name }}">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Email</label>
                                            <input type="text" placeholder="Enter Your Email" name="email" class="form-control" value="{{ $user->email }}" required >
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Mobile</label>
                                            <input type="text" placeholder="Mobile" name="mobile" class="form-control" required value="{{ $user->mobile }}" >
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Expiry Date</label>
                                            <input type="date" class="form-control" name="expiry_date" value="{{ $user->expiry_date }}" required/>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Status</label>
                                            <select class="form-control" name="status_id" id="status_id">
                                                <option value="1" {{ $user->status_id == 1 ? 'selected' : '' }} >Active</option>
                                                <option value="2" {{ $user->status_id == 2 ? 'selected' : '' }}>In-Active</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Profile Image</label><br/>
                                            <img src="<?php echo asset($user->profile_image);?>" style="width: 50px;">
                                            <br/><br/>
                                            <input id="file-input" type="file" name="profile_image">
                                        </div>
                                    </div>
                                </div><br/>
                                <button type="submit" class="btn btn-primary">Save</button>
                                <!-- <a href="{{ route('hoteladmins.index') }}" class="btn btn-primary"> -->
                                <!-- Cancel
                                </a> -->
                            </form>
                            <hr/>
                            <h4>Change Password</h4><hr/>
                            <form method="POST" action="/myprofilesettings/{{ $user->id }}"  enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Old Password</label>
                                            <input type="text" placeholder="Enter Your Old Password" name="old_password" class="form-control" >
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>New Password</label>
                                            <input type="text" placeholder="Enter Your New Password" name="new_password" class="form-control" >
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Confirm Password</label>
                                            <input type="text" placeholder="Enter Confirm Password" name="confirm_password" class="form-control" >
                                        </div>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary">Save</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('javascript')

@endsection



