
@extends('dashboard.base')

@section('css')

@endsection

@section('content')


<link href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.47/css/bootstrap-datetimepicker.css" integrity="sha256-b5ZKCi55IX+24Jqn638cP/q3Nb2nlx+MH/vMMqrId6k=" crossorigin="anonymous" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.5.1/jquery.min.js" integrity="sha256-9/aliU8dGd2tb6OSsuzixeV4y/faTqgFtohetphbbj0=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.26.0/moment.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.47/js/bootstrap-datetimepicker.min.js" integrity="sha256-5YmaxAwMjIpMrVlK84Y/+NjCpKnFYa8bWWBbUHSBGfU=" crossorigin="anonymous"></script>

<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Update Customer</h4></div>
            <div class="card-body">
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                        </div>
                    </div>
                 @endif            
           
               
                        <div class="nav-tabs-boxed">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item"><a class="nav-link active" data-toggle="tab" href="#basic_info" id="tab_basic_info" role="tab" aria-controls="home">Basic Info</a></li>
                                <li class="nav-item"><a class="nav-link" data-toggle="tab" id="tab_address" href="#address" role="tab" aria-controls="profile">Address Details</a></li>
                                <li class="nav-item"><a class="nav-link" data-toggle="tab" id="tab_document" href="#documents" role="tab" aria-controls="messages">ID proof Documents</a></li>
                            </ul>
                            <div class="tab-content">
                               <!-- Basic Info tab Starts-->
                                <div class="tab-pane active" id="basic_info" role="tabpanel">
                                  <form method="POST" id="basic_info" action="/customers/{{ $customer->id }}" enctype="multipart/form-data">
                                    @csrf
                                    @method('PUT')
                                    <input name="marker" value="selectModel" type="hidden">
                                        <div class="row">
                                          <div class="col-md-6">
                                            <div class="form-group">
                                              <label>First Name</label>
                                                <input type="text" placeholder="Enter First Name" name="first_name" class="form-control" value="{{ $customer->first_name }}" required >
                                            </div>
                                          </div>
                                          <div class="col-md-6">
                                            <div class="form-group">
                                              <label>Middle Name</label>
                                                <input type="text" placeholder="Enter Middle Name" name="middle_name" class="form-control" value="{{ $customer->middle_name }}"  >
                                            </div>
                                          </div>
                                        </div>

                                      <div class="row">
                                          <div class="col-md-6">
                                            <div class="form-group">
                                              <label>Last Name</label>
                                                <input type="text" placeholder="Enter Last Name" name="last_name" class="form-control" value="{{ $customer->last_name }}" required >
                                            </div>
                                          </div>
                                          <div class="col-md-6">
                                            <div class="form-group">
                                              <label>Email</label>
                                                <input type="text" placeholder="Enter Your Email" name="email" class="form-control" value="{{ $customer->email }}" required >
                                            </div>
                                          </div>
                                      </div>

                                      <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Mobile</label>
                                                  <input type="text" placeholder="Enter your Mobile" name="mobile" class="form-control" value="{{ $customer->mobile }}" >
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Nationality</label>
                                                  <input type="text" placeholder="Enter your Nationality" name="nationality" class="form-control" value="{{ $customer->nationality }}" > >
                                            </div>
                                        </div>
                                      </div>

                                      <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Date Of Birth</label>
                                                  <input type="date" placeholder="Enter Dob" name="date_of_birth" class="form-control"  value="{{ $customer->date_of_birth }}"  required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                              <label>Gender</label>
                                                <select class="form-control" name="gender" id="gender">
                                                  <option value="1"  {{ $customer->gender == 1 ? 'selected' : '' }}>Male</option>
                                                  <option value="2"  {{ $customer->gender == 2 ? 'selected' : '' }}>Female</option>
                                                </select>
                                            </div>
                                        </div>
                                      </div>

                                      <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Passport Number/ ID Number</label>
                                                  <input type="text" placeholder="Enter your Passport Number" name="passport_number" class="form-control" value="{{ $customer->passport_number }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Passport Expiry Date</label>
                                                  <input type="date" placeholder="Enter Passport expiry date" name="passport_expiry_date" class="form-control" value="{{ $customer->passport_expiry_date }}">
                                            </div>
                                        </div>
                                      </div>

                                      <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Country of Issue</label>
                                                  <input type="text" placeholder="Enter Country of Issue" name="country_of_issue" class="form-control" value="{{ $customer->country_of_issue }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Room</label>
                                                    <select class="form-control " name="room_id" id="room">
                                                          <option value="0">Select Room</option>
                                                          @foreach($rooms as $room)
                                                            <option value="{{ $room->id }}" {{ $customer->room_id == $room->id ? 'selected' : '' }}>{{ $room->title }}</option>
                                                        @endforeach
                                                      </select>
                                                  </div>
                                            </div>
                                      </div>

                                      <div class="row">
                                          <div class="col-md-6">
                                              <div class="form-group">
                                                  <label>CheckIn Date</label>
                                                    <input type="text" placeholder="Enter CheckIn date" name="checkin_date_time" class="form-control datetimepicker" value="{{ $customer->checkin_date_time }}">
                                              </div>
                                            </div>
                                            <div class="col-md-6">
                                              <div class="form-group">
                                                  <label>CheckOut Date</label>
                                                    <input type="text" placeholder="Enter CheckOut date" name="checkout_date_time" class="form-control datetimepicker" value="{{ $customer->checkout_date_time }}">
                                              </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                           <div class="col-md-6">
                                              <div class="form-group">
                                                  <label>Display Image</label><br/><br/>
                                                  <img src="<?php echo asset("storage/customer_display_images/$customer->profile_image")?>" style="width: 50px;">
                                                  <br/><br/>
                                                  <input id="file-input" type="file" name="profile_pic">
                                              </div>
                                            </div>
                                        </div>
                                        <br/>
                                        <button type="button" id="proceed_to_address" class="btn btn-primary">Proceed</button>
                                   </div>
                                   
                                    <!-- Basic Info tab Ends-->

                                    <!-- Address tab Starts-->
                                    <div class="tab-pane" id="address" role="tabpanel">
                                            <div class="row">
                                                  <div class="col-md-6">
                                                      <div class="form-group">
                                                          <label>Address Line 1</label>
                                                            <input type="text" placeholder="Enter Address Line 1" name="address_line_1" class="form-control" value="{{ $customer->address_line_1 }}">
                                                      </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                      <div class="form-group">
                                                          <label>Address Line 2</label>
                                                            <input type="text" placeholder="Enter Address Line 2" name="address_line_2" class="form-control" value="{{ $customer->address_line_2 }}">
                                                      </div>
                                                  </div>
                                            </div>

                                              <div class="row">
                                                  <div class="col-md-6">
                                                      <div class="form-group">
                                                          <label>City</label>
                                                            <input type="text" placeholder="Enter City" name="city" class="form-control"  value="{{ $customer->city }}">
                                                      </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                      <div class="form-group">
                                                          <label>State</label>
                                                            <input type="text" placeholder="Enter State" name="state" class="form-control"  value="{{ $customer->state }}">
                                                      </div>
                                                  </div>
                                              </div>

                                              <div class="row">
                                                  <div class="col-md-6">
                                                      <div class="form-group">
                                                          <label>Pin</label>
                                                            <input type="text" placeholder="Enter Pin" name="pin" class="form-control" value="{{ $customer->pin }}">
                                                      </div>
                                                    </div>
                                              </div><br>
                                              <button type="button" id="proceed_to_document_tab" class="btn btn-primary">Proceed</button>
                                              <button type="button" id="back_to_basic_info_tab" class="btn btn-primary">Back</button>
                                      </div>
                            
                                     <!-- Address tab Ends-->

                                     <!-- Id proof doc tab Starts-->
                                    <div class="tab-pane" id="documents" role="tabpanel">
                                       
                                    <div class="row">
                                      <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Select Document Type</label>
                                            <?php if( $docs){ ?>
                                            <select class="form-control" name="document_type" id="document_type"> 
                                                @foreach($types as $type)
                                                  <option value="{{ $type->id }}" {{ $docs->document_type == $type->id ? 'selected' : '' }}>{{ $type->title }}</option>
                                                @endforeach
                                               </select>
                                               <?php } else { ?>
                                                <select class="form-control" name="document_type" id="document_type">
                                                   <option value="0" >Please Select Document</option>
                                                   @foreach($types as $type)
                                                     <option value="{{ $type->id }}">{{ $type->title }}</option>
                                                   @endforeach
                                                </select>
                                               <?php } ?>
                                          </div>
                                        </div>
                                        <div class="col-md-6">
                                          <div class="form-group">
                                              <label>Number</label>
                                              <?php if( $docs){ ?>
                                                <input type="text" placeholder="Enter Number" name="number" class="form-control" value="{{ $docs->number }}">
                                              <?php } else { ?>
                                                <input type="text" placeholder="Enter Number" name="number" class="form-control" value="">
                                              <?php } ?>
                                          </div>
                                        </div>
                                      </div>

                                      <div class="row">
                                           <div class="col-md-6">
                                              <div class="form-group">
                                                  <label>Upload Document</label><br/><br/>
                                                  <?php if($docs) { ?>
                                                  <img src="<?php echo asset("storage/customer_documents/$docs->uploaded_document")?>" style="width: 50px;">
                                                  <br/><br/>
                                                  <?php } ?>
                                                  <input id="file-input" type="file" name="uploaded_document">
                                              </div>
                                            </div>
                                        </div>
                                        
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                        <button type="button" id="back_to_address_tab" class="btn btn-primary">Back</button>
                                        <a href="{{ route('customers.index') }}" class="btn btn-primary">
                                        Cancel
                                      </a>
                                    </div>
                                  <!-- Id proof doc tab Ends--> 
                                </form>
                            </div>




                              
                       <!-- </form> -->

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">
        $(function () {
            $('.datetimepicker').datetimepicker();
 
            //go to address tab
            $('#proceed_to_address').on('click', function(){
              $('#tab_address')[0].click();  
            });

            //go to docs tab
            $('#proceed_to_document_tab').on('click', function(){
              $('#tab_document')[0].click();  
            });
            
            //go back to basic info tab
            $('#back_to_basic_info_tab').on('click', function(){
              $('#tab_basic_info')[0].click();  
            });

            //go back to address tab
            $('#back_to_address_tab').on('click', function(){
              $('#tab_address')[0].click();  
            });
        });
    </script>

@endsection

@section('javascript')

<script type="text/javascript">
    $(function () {
        $('.datetimepicker').datetimepicker();

            // proceed to address tab from basic info tab
            $('#proceed_to_address').on('click', function(){
                $('#tab_address')[0].click();  
            });

            //proceed to document tab from address tab
            $('#proceed_to_document_tab').on('click', function(){
                $('#tab_document')[0].click();  
            });

            // go back to basic info tab from address tab
            $('#back_to_basic').on('click', function(){
                $('#tab_basic_info1')[0].click();  
            });
        
            // go back to address tab from document tab
            $('#back_to_address').on('click', function(){
                $('#tab_address')[0].click();  
            });

            var i = 1;
            $("#add-btn").click(function(){
                i++; 
                var full_div = '<hr/><div id="new_row'+i+'"><div class="row"><div class="col-md-6"><div class="form-group"><label>Select Document Type</label><select class="form-control"  name="document_type[]" id="document_type"><option value="0" >Please Select Document</option>@foreach($types as $type)<option value="{{ $type->id }}">{{ $type->title }}</option>@endforeach</select></div></div><div class="col-md-6"><div class="form-group"><label>Number</label><input type="text" placeholder="Enter Number" name="number[]"  class="form-control"></div></div></div> <div class="row"> <div class="col-md-6"> <div class="form-group"><label>Upload Document</label><br/><br/><input id="file-input" type="file"  name="uploaded_document[]"></div> </div><button type="button" style="height: 34px;margin-top: 36px;" id="'+i+'" class="btn btn-danger remove-tr">Remove</button></div></div>';
                $("#dynamicAddRemove").append(full_div);
            });

            $(document).on('click', '.remove-tr', function(){  
                var button_id = $(this).attr("id");   
                $('#new_row'+button_id+'').remove();  
            });  

            $(document).on('click', '.btn_remove_kpi', function(){  
                var button_id = $(this).attr("id");   
                $('#new_row'+button_id+'').remove();  
            });  
    });
</script>


@endsection




