@extends('dashboard.base')

@section('content')

<?php use DB as DBS; ?>
<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Edit Privileges for <b>{{ $group->group_name }}</b></h4></div>
            <div class="card-body">
                        @if(Session::has('message'))
                            <div class="row">
                                <div class="col-12">
                                    <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                                </div>
                            </div>
                        @endif   

                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                       
                        <form method="POST" action="/privileges/{{ $group->id }}">
                            @csrf
                            @method('PUT')
                            <div class="row">
                                 <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Group Name : </label>  <label><b>{{ $group->group_name }}</b> </label><br/>
                                        <label>Description : </label><label><b>{{ $group->description }}</b></label><br/>
                                        <label>Memebers</label>  <label><b>{{ $group->members }}</b></label><br/>
                                    </div>
                                </div>
                            </div>
                          <hr/>
                              <h4>Assign Privileges :</h4> <hr/>

                                <div class="row">
                                    <div class="col-md-4">
                                          <p><b>Module Name</b></p>
                                    </div>
                                    <div class="col-md-2"></div>
                                    <div class="col-md-4">
                                          <p><b>Privileges</b></p>
                                    </div>
                                </div><hr/>

                                <!-- <div class="row">
                                    <div class="col-md-4"></div>
                                    <div class="col-md-4">
                                      <div class="form-check form-check-inline mr-1">
                                        <input class="form-check-input" id="inline_checkbox_all" name="check_all" type="checkbox"  value="1">
                                        <label class="form-check-label" style="margin-right: 21px;" for="inline-checkbox_all">Select All Privileges</label>
                                    </div></div>
                                    <div class="col-md-4"></div>
                                </div>
                                <br/><br/> -->
                               <div class="row">
                                 
                                   @foreach($modules as $module)
                                     <div class="col-md-3">
                                          <p><b>{{ $module->module_name }}</b></p>
                                          <?php  
                                          //get privileges for this group
                                            $all_privilegesby_module = DB::table('groups_privileges')
                                            ->select('*')
                                            ->where('group_id','=',$group->id)
                                            ->where('module_id','=',$module->id)
                                            ->first();
                                          ?>
                                     </div>

                                        <div class="col-md-1">: </div>
                                        
                                        <div class="col-md-8">
                                          <div class="form-check form-check-inline mr-1">
                                              <input class="form-check-input check_mod_all" <?php if(!empty($all_privilegesby_module)):?><?php if($all_privilegesby_module->allow_all):?> checked="checked" <?php endif;?><?php endif;?>  id="inline-all-checkbox{{ $module->id }}" name="all" type="checkbox"  value="all">
                                              <label class="form-check-label" style="margin-right: 21px;" for="inline-checkbox1">All</label>
                                          </div>
                                            
                                          <div class="form-check form-check-inline mr-1">
                                              <input class="form-check-input check_mod" <?php if(!empty($all_privilegesby_module)):?><?php if($all_privilegesby_module->view):?> checked="checked" <?php endif;?><?php endif;?>  id="inline-checkbox-view{{ $module->id }}" name="{{ $module->module_name }}[]" type="checkbox"  value="1">
                                              <label class="form-check-label" style="margin-right: 21px;" for="inline-checkbox1">View</label>
                                          </div>
                                          <div class="form-check form-check-inline mr-1">
                                              <input class="form-check-input check_mod" <?php if(!empty($all_privilegesby_module)):?><?php if($all_privilegesby_module->add):?> checked="checked" <?php endif;?><?php endif;?> id="inline-checkbox-add{{ $module->id }}"  name="{{ $module->module_name }}[]" type="checkbox" value="2">
                                              <label class="form-check-label" style="margin-right: 21px;" for="inline-checkbox1">Add</label>
                                          </div>
                                          <div class="form-check form-check-inline mr-1">
                                              <input class="form-check-input check_mod" <?php if(!empty($all_privilegesby_module)):?><?php if($all_privilegesby_module->edit):?> checked="checked" <?php endif;?><?php endif;?> id="inline-checkbox-edit{{ $module->id }}" name="{{ $module->module_name }}[]" type="checkbox" value="3">
                                              <label class="form-check-label" style="margin-right: 21px;" for="inline-checkbox1">Edit</label>
                                          </div>
                                          <div class="form-check form-check-inline mr-1">
                                              <input class="form-check-input check_mod" <?php if(!empty($all_privilegesby_module)):?><?php if($all_privilegesby_module->delete):?> checked="checked" <?php endif;?><?php endif;?> id="inline-checkbox-delete{{ $module->id }}" name="{{ $module->module_name }}[]" type="checkbox" value="4">
                                              <label class="form-check-label"  style="margin-right: 21px;" for="inline-checkbox1">Delete</label>
                                          </div>
                                       </div>
                                    @endforeach
                                </div><hr/>

                            <button type="submit" class="btn btn-primary">Save</button>
                            <a href="{{ route('groups.index') }}" class="btn btn-primary">
                            Cancel</a>

                        </form>
                        </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')

<script type="text/javascript">
$(function () {

      $('.check_mod_all').on( "click", function() {
        let n;
        n = $('input:checkbox[id^="inline-all-checkbox"]:checked').length;
        let val;
        val = $(this).attr("id");
        var res = val.charAt(val.length-1);

        // count of checked checkboxes
        // if($('input:checkbox[id^="inline-all-checkbox"]').is(":checked")){alert(2);
        if($('#'+val).is(":checked")){
            $('#inline-checkbox-view'+res).prop('checked', true);
            $('#inline-checkbox-add'+res).prop('checked', true);
            $('#inline-checkbox-edit'+res).prop('checked', true);
            $('#inline-checkbox-delete'+res).prop('checked', true);
          } else {
            $('#inline-checkbox-view'+res).prop('checked', false);
            $('#inline-checkbox-add'+res).prop('checked', false);
            $('#inline-checkbox-edit'+res).prop('checked', false);
            $('#inline-checkbox-delete'+res).prop('checked', false);
          }
      });

      //for  selecting all checkboxes on clicking select all checkbox
      $('#inline_checkbox_all').on( "click", function() {
        if($('#inline_checkbox_all').is(":checked")){
          $('.check_mod').prop('checked', true);
        } else {
          $('.check_mod').prop('checked', false);
        }
      });
  });

</script>

@endsection