					  
@extends('dashboard.base')

@section('content')

      @if(Session::has('message'))
        <div class="row">
          <div class="col-12">
            <div class="alert alert-success alert-dismissible fade show" role="alert">{{ Session::get('message') }}
              <button class="close" type="button" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
            </div>
          </div>
        </div>
      @endif                 
      <div class="container-fluid">
        <div class="animated fadeIn">
          <div class="row">
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12">
              <div class="card">
                <div class="card-header">
                  <i class="fa fa-align-justify"></i>{{ __(' Most Wanted Records') }}
                  <!-- <a id="add_button" href="{{ route('criminalrecords.create') }}" class="btn">{{ __('Add ') }}<i class="fa fa-plus-circle"></i></a> -->
                </div>
                <div class="card-body">
                  <table  style="width: 102%; margin-left: -15px;" class="table table-bordered data-table" id="scan_datatable">
                    <thead>
                      <tr>
                          <!-- <th>Name</th>
                          <th>File Number</th>
                          <th>Record ID</th>
                          <th>Institution</th>
                          <th>Description</th>
                          <th width="100px">Action</th> -->
                          <th>Name</th>
                          <th>Date Of Birth</th>
                          <th>Passport No</th>
                          <th>Nationality</th>
                          <th width="100px">Action</th>
                      </tr>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- /.modal-->
      <div class="modal fade" id="dangerModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <input type="hidden" name='delete_record_id' id="delete_record_id" value="">
        <div class="modal-dialog modal-danger" role="document">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title">Delete</h4>
              <button class="close" type="button" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
            </div>
            <div class="modal-body">
              <p>Are you sure, You want to delete this record ? </p>
            </div>
            <div class="modal-footer">
              <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
              <button class="btn btn-danger" id="confirm" data-dismiss="modal" type="button">Confirm</button>
            </div>
          </div>
          <!-- /.modal-content-->
        </div>
        <!-- /.modal-dialog-->
      </div>
      <!-- /.modal-->


      
        <!-- /.modal-->
        <div class="modal fade" id="criminalModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
            <input type="hidden" name='criminal_record_id' id="criminal_record_id" value="">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Criminal Record Details</h4>
                        <button class="close" type="button" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                    </div>
                    <div class="modal-body">
                        <table class="footable-details table table-bordered tabel_info">
                            <tbody>  
                                <tr>
                                    <td class="text-left" colspan="2" class="view_th">File No.</td>
                                    <td class="text-left" colspan="2" class="view_th"><label id="file_no"></label></td>
                                    <td class="text-left" colspan="2" class="view_th">Record ID</td>
                                    <td class="text-left" colspan="2" class="view_th"><label id="record_id"></label></td>
                                    <td class="text-center" rowspan="3" style="width: 130px;padding: 5px;"><label id="image"></label></td>
                                </tr>
                                <tr>
                                    <td class="text-left" colspan="2" class="view_th">Name</td>
                                    <td class="text-left" colspan="3" class="view_th"><label id="name"></label></td>
                                    <td class="text-left" colspan="2" class="view_th">Gender</td>
                                    <td class="text-left" colspan="3" class="view_th"><label id="gender"></label></td>
                                </tr>
                                <tr>
                                    <td class="text-left" colspan="2" class="view_th">Description(Charge)</td>
                                    <td class="text-left" colspan="8" class="view_th"><label id="description"></label></td>
                                </tr>
                                <tr>
                                    <td class="text-left" colspan="2" class="view_th">Institution</td>
                                    <td class="text-left" colspan="2" class="view_th"><label id="institution"></label></td>
                                    
                                    <td class="text-left" colspan="2" class="view_th">Nationality</td>
                                    <td class="text-left" colspan="4" class="view_th"  ><label id="nationality"></label></td>
                                </tr>
                                <tr> 
                                    <td class="text-left" colspan="2" class="view_th">Age </td>
                                    <td class="text-left" colspan="1" class="view_th"><label id="age"></label></td>
                                    
                                    <td class="text-left" colspan="2" class="view_th">Height</td>
                                    <td class="text-left" colspan="1" class="view_th"><label id="height"></label></td>

                                    <td class="text-left" colspan="2" class="view_th">Date of Birth</td>
                                    <td class="text-left" colspan="2" class="view_th"><label id="date_of_birth"></label></td>

                                </tr>
                                <tr>
                                    <td class="text-left" colspan="2" class="view_th">Eye Color</td>
                                    <td class="text-left" colspan="1" class="view_th"><label id="eye_color"></label></td>
                                   
                                    <td class="text-left" colspan="2" class="view_th">Hair Color</td>
                                    <td class="text-left" colspan="1" class="view_th"><label id="hair_color"></label> </td>
                                
                                    <td class="text-left" colspan="2" class="view_th">Created On</td>
                                    <td class="text-left" colspan="2" class="view_th"><label id="created_at"></label> </td>
                                
                                </tr>
                                <tr>
                                    <td class="text-left" colspan="2" class="view_th">Law Instructions</td>
                                    <td class="text-left" colspan="10" class="view_th"><label id="law_instructions" style="color:red;"></label></td>
                                </tr>
                                   
                                
                            </tbody>
                        </table>
                    </div>
                    <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    </div>
                </div>
                <!-- /.modal-content-->
            </div>
            <!-- /.modal-dialog-->
        </div>
        <!-- /.modal-->


        
@endsection

@section('javascript')

<script type="text/javascript">
  $(function () {
    var table = $('.data-table').DataTable({
      processing: true,
      serverSide: true,
      ajax: "{{ route('mostwanted.index') }}",
      order: [],
      columns: [
          {data: 'name', name: 'name'},
          // {data: 'file_number', name: 'file_number'},
          // {data: 'record_id', name: 'record_id'},
          // {data: 'institution', name: 'institution'},
          // {data: 'description', name: 'description'},
          {data: 'date_of_birth', name: 'date_of_birth'},
          {data: 'passport_no', name: 'passport_no'},
          {data: 'nationality', name: 'nationality'
            render: function(data, type, row) {
              if(data == 'Yes') {
                  return '<span style="color:red;">Yes</span>';
              } else {
                return '<span>No</span>';
              }
            }
          },
          {data: 'action', name: 'action', orderable: false, searchable: false},
      ]
    });

    $(document).on( "click", ".delete", function() {
      $('#delete_record_id').val($(this).data('record-id'));
      $('#dangerModal').on( "click", "#confirm", function() {       
        $.ajax({
            type: 'post',
            url: '/mostwanted/delete',
            data: {
                '_method':'DELETE',
                '_token': $('input[name=_token]').val(),
                'id': $('#delete_record_id').val(),
            },
            success: function(resdata) {
              if(resdata){
                table.ajax.reload();
              }
            }
        });
      });
    });


    
    $(document).on("click", ".view_record", function() {
                $.ajax({
                    type: 'get',
                    url: '/customers/getCriminalRecordDetails',
                    data: {
                        '_method':'GET',
                        '_token': $('input[name=_token]').val(),
                        'type':'criminal_view',
                        'id': $(this).data('record-id'),
                    },
                    success: function(resdata) {
                        if(resdata){
                            $('#criminalModal').modal('show');
                            $('#file_no').text(resdata.file_number);
                            $('#record_id').text(resdata.record_id);
                            $('#image').html('<img src="' + resdata.image + '" height="150">');
                            $('#name').text(resdata.name);
                            $('#description').text(resdata.description);
                            $('#institution').text(resdata.institution);
                            $('#nationality').text(resdata.country);
                            $('#gender').text(resdata.criminal_gender);
                            $('#date_of_birth').text(resdata.date_of_birth);
                            $('#age').text(resdata.age);
                            $('#height').text(resdata.height);
                            $('#eye_color').text(resdata.eye_color);
                            $('#hair_color').text(resdata.hair_color);
                            $('#created_at').text(resdata.created_on);
                            $('#law_instructions').text(resdata.law_instructions);
                            $('#law_instructions').cdd("colot:","red");
                                    
                                    
                            // $('#title').text(resdata.title);
                            // $('#description').text(resdata.description);
                            // $('#document').html('<a href="' + resdata.document + '" target="_bkank">viwe Document</a>');
                        }
                    }
                });
            });



  });
</script>

@endsection
