					  
@extends('dashboard.base')

@section('content')

    @if(Session::has('message'))
        <div class="row">
            <!-- <div class="col-12">
                <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
            </div> -->
            <div class="alert alert-success alert-dismissible fade show" role="alert">{{ Session::get('message') }}
                <button class="close" type="button" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
            </div>
        </div>
    @endif                 
    <div class="container-fluid">
        <div class="animated fadeIn">
            <div class="row">
                <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <i class="fa fa-align-justify"></i>{{ __(' Complaints') }} 
                            <a id="add_button" href="{{ route('generaluserscomp.create') }}" class="btn">{{ __('Add ') }}<i class="fa fa-plus-circle"></i></a>
                        </div>
                            <div class="card-body">
                                <table  style="width: 102%; margin-left: -15px;" class="table table-bordered data-table" id="scan_datatable">
                                    <thead>
                                        <tr>
                                            <!-- <th width="50">No</th> -->
                                            <th width="25%">Complaint Against</th>
                                            <th width="25%">Title</th>
                                            <th>Description</th>
                                            <th width="25%">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- /.modal-->
        <div class="modal fade" id="viewModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
            <input type="hidden" name='complaint_record_id' id="complaint_record_id" value="">
            <div class="modal-dialog modal-info" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Complaint Details</h4>
                        <button class="close" type="button" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                    </div>
                    <div class="modal-body">
                        <table class="footable-details table table-striped table-hover toggle-circle">
                            <tbody>
                                <tr>
                                    <th>Complaint Type :</th>
                                    <td style="display: table-cell;"><label id="complaint_type"></label></td>
                                </tr>
                                <tr>
                                    <th>Complaint Against :</th>
                                    <td style="display: table-cell;"><label id="against"></label></td>
                                </tr>
                                <tr>
                                    <th>Title :</th>
                                    <td style="display: table-cell;"><label id="title"></label></td>
                                </tr>
                                <tr>
                                    <th>Description:</th>
                                    <td style="display: table-cell;"><label id="description"></label></td>
                                </tr>
                                <tr>
                                    <th>Complaint Rating :</th>
                                    <td style="display: table-cell;"><label id="complaint_rating"></label></td>
                                </tr>
                                <tr>
                                    <th>Complaint Status :</th>
                                    <td style="display: table-cell;"><label id="complaint_status"></label></td>
                                </tr>
                                <tr>
                                    <th>Action Taken :</th>
                                    <td style="display: table-cell;"><label id="action_taken"></label></td>
                                </tr>
                                <tr>
                                    <th>Document:</th>
                                    <td style="display: table-cell;"><label id="document"></label></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    </div>
                </div>
                <!-- /.modal-content-->
            </div>
            <!-- /.modal-dialog-->
        </div>
        <!-- /.modal-->

@endsection

@section('javascript')

<script type="text/javascript">
    $(function () {
        var table = $('.data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('complaints.index') }}",
            order: [],
            columns: [
                // {data: 'id', name: 'id'},
                {data: 'complaint_against', name: 'complaint_against'},
                {data: 'title', name: 'title'},
                {data: 'description', name: 'description'},
                {data: 'action', name: 'action', orderable: false, searchable: false},
            ]
        });

        $(document).on("click", ".view_compliant", function() {
            $.ajax({
                  type: 'get',
                  url: '/complaints/getComplaintDetails',
                  data: {
                      '_method':'GET',
                      '_token': $('input[name=_token]').val(),
                      'type':'complaint_view',
                      'id': $(this).data('record-id'),
                  },
                  success: function(resdata) {
                    if(resdata){
                        $('#viewModal').modal('show');
                        $('#against').text(resdata.complaint_against);
                        $('#title').text(resdata.title);
                        $('#description').text(resdata.description);
                        $('#complaint_type').text(resdata.complaint_type);
                        $('#complaint_rating').text(resdata.complaint_rating);
                        $('#complaint_status').text(resdata.complaint_status);
                        $('#action_taken').text(resdata.action_taken);


                        if( resdata.document == '--'){
                            $('#document').html( resdata.document);
                        } else {
                            $('#document').html('<a href="' + resdata.document + '" target="_bkank">View Document</a>');
                        }
                    }
                }
            });
        });
    });

</script>


@endsection
