<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use App\Models\Properties;
use App\Models\Room;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use App\Models\Staffs;
use DataTables;

class RoomController extends Controller
{
    public function index(Request $request){
        $datas = $request->all();
        $main_id = '';
        if(Auth::user()->user_type == 3){
            $main_id = Auth::user()->id;
        } else if(Auth::user()->user_type == 4){
            $staff_info = Staffs::where('email',Auth::user()->email)->first();
            $staff_property_info = DB::table('staff_assigned_properties')->where('staff_id',$staff_info->id)->get();
            // echo "<pre>";print_r($staff_property_info);exit;
        }
        
        if(Auth::user()->user_type == 4 || Auth::user()->user_type == 6){//4 = hotel admin staff , 6=govt admin staff ){//4 = hotel admin staff

            //get staff info for group 
            $getGroup = DB::table('staffs')->select('group_id')->where('main_user_id', Auth::user()->id)->first();
            
            //get groups and privileges
            $getPrivileges = DB::table('groups_privileges')->where('group_id', $getGroup->group_id)->where('module_id','4')->first();//module_id = 5(Only customer module)

        } else {
            $getPrivileges = array();
        }

        if ($request->ajax()) {
            if($main_id){
                 $data = Room::where('created_by',$main_id)->orderBy('id','desc')->get();
     
            } else {
                 $data = Room::where('property_id',$staff_property_info[0]->property_id)->where('deleted_at',null)->orderBy('id','desc')->get();
     
            }
           
                foreach($data as $room){
                    $id = $room->id;
                }

                if(!empty($getPrivileges)){
                    if($getPrivileges->edit ==1 && $getPrivileges->delete ==1){ //allow delete and edit access
                        $action =  '<a href="/rooms/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
                    } else if($getPrivileges->edit ==1 && $getPrivileges->delete !=1){//allow edit access
                        $action = '<a href="/rooms/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>';
                    } else if($getPrivileges->delete == 1 && $getPrivileges->edit != 1){
                        $action = '<button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
                    } else {
                        $action =  '';
                    }
                } else {
                    $action =  '<a href="/rooms/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
                }

                return Datatables::of($data)
                        ->addColumn('action', $action)
                        // ->addColumn('action', '<a href="/rooms/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>')
                        ->rawColumns(['action'])
                        ->make(true);
        }
        return view('dashboard.rooms.roomsList',['privileges'=>$getPrivileges]);
    }

     /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        // $statuses = Status::all();
        $main_id = Auth::user()->id ;
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();

        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();    

        return view('dashboard.rooms.create',['properties'=>$properties]);
    }

   /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'title'      => 'required|min:1|max:64',
            'property_id'      => 'required',
            'description'       => 'required|min:1|max:64',
        ]);

        //insert new room
        $room = new Room();
        $room->title    = $request->input('title');
        $room->property_id    = $request->input('property_id');
        $room->description   =  $request->input('description');
        $room->created_by   = Auth::user()->id;
        $room->save();

        $request->session()->flash('message', 'Room Created Successfully.');
        return redirect()->route('rooms.index');
    }

    //for editing hotel admin
    public function edit($id)
    {
        $room = Room::find($id);
        $main_id = Auth::user()->id ;
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();

        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();    

        return view('dashboard.rooms.edit', ['properties'=>$properties, 'room' => $room ]);
    }

   /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'title'      => 'required|min:1|max:64',
            'property_id'      => 'required',
            'description'       => 'required|min:1|max:64',
        ]);

          //insert new room
          $room = Room::find($id);
          $room->title    = $request->input('title');
          $room->property_id    = $request->input('property_id');
          $room->description   =  $request->input('description');
          $room->save();

        $request->session()->flash('message', 'Room Updated Successfully');
        return redirect()->route('rooms.index');
    }

        /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $room = Room::find($id);
        if($room){
            $room->delete();
        }
        return redirect()->route('rooms.index');
    }
    
}

