
@extends('dashboard.base')

@section('css')

@endsection

@section('content')


<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
        <div class="card-header"><h4>Edit BlackList</h4></div>
            <div class="card-body">
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                        </div>
                    </div>
                 @endif     

                 @if ($errors->any())
                      <div class="alert alert-danger">
                          <ul>
                              @foreach ($errors->all() as $error)
                                  <li>{{ $error }}</li>
                              @endforeach
                          </ul>
                      </div>
                  @endif

                  <form method="POST" action="/blacklists/{{ $blacklist->id }}">
                    @csrf
                    @method('PUT')

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Name*</label>
                                <input type="text" required placeholder="Enter Name" value="<?php echo $blacklist->name; ?>" name="name" class="form-control" >
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Passport No.*</label>
                                <input type="text" required placeholder="Enter Passport No." value="<?php echo $blacklist->passport_no; ?>"  name="passport_no" class="form-control" >
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Date Of Birth*</label>
                                <input type="date" required placeholder="Enter Dob" name="date_of_birth" value="<?php echo $blacklist->date_of_birth; ?>" class="form-control" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Nationality*</label>
                                <select class="form-control " name="nationality" id="nationality_main"  required>
                                    <option value="0">Please select Nationality*</option>
                                    @foreach($countries as $country)
                                        <option value="{{ $country->id }}" {{ $blacklist->nationality == $country->id  ? 'selected' : '' }} >{{ $country->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Select Property*</label>
                                <select class="form-control" name="property_id" id="property">
                                    <option value="0">Please select Property</option>
                                    @foreach($properties as $property)
                                    <option value="{{ $property->id }}" {{ $blacklist->property_id == $property->id  ? 'selected' : '' }}>{{ $property->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Reason</label>
                                <textarea placeholder="Enter Reason" cols='5'  rows='3' name="reason" id="reason"  class="form-control"><?php echo $blacklist->reason; ?></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Block Status</label>
                                <select class="form-control " name="block_status" id="block_status">
                                    <option value="0" {{ $blacklist->block_status == 0  ? 'selected' : '' }}>No</option>
                                    <option value="1" {{ $blacklist->block_status == 1  ? 'selected' : '' }}>Yes</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Complaint Type</label>
                                <select class="form-control " name="complaint_type" id="complaint_type">
                                    <option value="0">Please select Type</option>
                                    @foreach($complaint_types as $type)
                                        <option value="{{ $type->id }}" <?php if($blacklist->complaint_type ==  $type->id){echo "selected";}?>>{{ $type->title }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Severity</label>
                                <select class="form-control " name="severity" id="severity">
                                    <option value="0">Please select severity</option>
                                    <option value="5" <?php if($blacklist->severity ==  '5'){echo "selected";}?>>5 (Very Serious)</option>
                                    <option value="4" <?php if($blacklist->severity ==  '4'){echo "selected";}?>>4 (Serious)</option>
                                    <option value="3" <?php if($blacklist->severity ==  '3'){echo "selected";}?>>3 (Major)</option>
                                    <option value="2" <?php if($blacklist->severity ==  '2'){echo "selected";}?>>2 (Minor)</option>
                                    <option value="1" <?php if($blacklist->severity ==  '1'){echo "selected";}?>>1 (Very Minor)</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Action Taken</label>
                                <textarea placeholder="Enter Action Taken" cols='5' rows='3' name="action_taken" id="action_taken"  class="form-control"><?php echo $blacklist->action_taken; ?></textarea>
                            </div>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary">Submit</button>
                    <a href="{{ route('blacklists.index') }}" class="btn btn-primary">
                      Cancel
                    </a>
                  </form>

            </div><br/><br/><br/><br/>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')

@endsection