@extends('dashboard.base')

@section('content')

<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Edit Staff</h4></div>
            <div class="card-body">
            {{ Session::get('message') }}
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                        </div>
                    </div>
                 @endif     

                 @if ($errors->any())
                      <div class="alert alert-danger">
                          <ul>
                              @foreach ($errors->all() as $error)
                                  <li>{{ $error }}</li>
                              @endforeach
                          </ul>
                      </div>
                  @endif

                        <form method="POST" action="/staffs/{{ $staff->id }}" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                            <div class="row">
                                 <div class="col-md-6">
                                    <div class="form-group">
                                       <label>First Name</label>
                                        <input type="text" placeholder="Enter Your First Name" name="first_name" class="form-control" value="{{ $staff->first_name }}">
                                     </div>
                                </div>
                                <div class="col-md-6">
                                   <div class="form-group">
                                   <label>Last Name</label>
                                        <input type="text" placeholder="Enter Your Last Name" name="last_name" class="form-control" value="{{ $staff->last_name }}">
                                    </div>
                                </div>
                            </div>

                             <div class="row">
                                  <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Email</label>
                                        <input type="text" placeholder="Enter Your Email" name="email" class="form-control" value="{{ $staff->email }}" >
                                    </div>
                                  </div>
                                  <div class="col-md-6">
                                      <div class="form-group">
                                          <label>Password</label>
                                          <input type="text" placeholder="Enter your Password" name="password" class="form-control" value="{{ $staff->org_password }}" >
                                      </div>
                                  </div>
                              </div>

                              <div class="row">
                                  <div class="col-md-6">
                                     <div class="form-group">
                                        <label>Mobile</label>
                                        <input type="number" placeholder="Mobile" name="mobile" class="form-control" value="{{ $staff->mobile }}" >
                                     </div>
                                  </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                          <label>Designation</label>
                                          <input type="text" placeholder="Enter your Designation" name="designation" class="form-control" value="{{ $staff->designation }}" >
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                  <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Select Group</label>
                                            <select class="form-control " name="group_id" id="group_id">
                                                  <option value="0">Select Group</option>
                                                  @foreach($groups as $group)
                                                    <option value="{{ $group->id }}" {{ $staff->group_id == $group->id ? 'selected' : '' }}>{{ $group->group_name }}</option>
                                                @endforeach
                                              </select>
                                          </div>
                                    </div>
                                    <div class="col-md-6">
                                     <div class="form-group">
                                        <label>Status</label>
                                        <select class="form-control" name="status_id" id="status_id">
                                            <option value="1" {{ $staff->status_id == 1 ? 'selected' : '' }} >Active</option>
                                            <option value="2" {{ $staff->status_id == 2 ? 'selected' : '' }}>In-Active</option>
                                          </select>
                                       </div>
                                    </div>
                                 </div>

                                 <?php if(empty($pincodes)){?>
                                  <div class="row">
                                    <div class="col-md-6">
                                      <div class="form-group">
                                        <label>Select Property</label>
                                        <select class="form-control" name="property_id[]" id="property" multiple="">
                                          <option value="0">Please select</option>
                                          @foreach($properties as $property)
                                          <option value="{{ $property->id }}" @foreach($assigned_properties as $ap) @if($ap->property_id == $property->id)selected="selected"@endif @endforeach>{{ $property->name }}</option>
                                          @endforeach
                                        </select>
                                      </div>
                                    </div>
                                  </div>
                                <?php } ?>
                                
                                  <?php if(!empty($pincodes)){?>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Assign Pin Code</label>
                                                <select class="form-control" name="assigned_pin[]" id="assigned_pin"  multiple="">
                                                    <option value="0">Please select</option>
                                                    @foreach($pincodes as $pin)
                                                        <option value="{{$pin->pin}}" @foreach($assigned_pincodes as $p) @if($p->assigned_pin == $pin->pin)selected="selected"@endif @endforeach>{{$pin->pin}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                  <?php } ?>

                                  <div class="row">
                                    <div class="col-md-6">
                                      <div class="form-group">
                                        <label>Profile Image</label><br/>
                                        <img src="<?php echo asset($staff->profile_image);?>" style="width: 50px;">
                                        <br/><br/>
                                        <input id="file-input" type="file" name="profile_image">
                                      </div>
                                    </div>
                                  </div><br/>


                                <button type="submit" class="btn btn-primary">Save</button>
                                <a href="{{ route('staffs.index') }}" class="btn btn-primary">
                                Cancel
                              </a>
                        </form>
                        </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')

@endsection