
@extends('dashboard.base')

@section('css')

@endsection

@section('content')


<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Create Staff</h4></div>
            <div class="card-body">
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                        </div>
                    </div>
                 @endif            

                 @if ($errors->any())
                      <div class="alert alert-danger">
                          <ul>
                              @foreach ($errors->all() as $error)
                                  <li>{{ $error }}</li>
                              @endforeach
                          </ul>
                      </div>
                  @endif

           
                        <form method="POST" action="{{ route('staffs.store') }}" enctype="multipart/form-data">
                            @csrf
                            <input name="marker" value="selectModel" type="hidden">
                               <div class="row">
                                  <div class="col-md-6">
                                     <div class="form-group">
                                       <label>First Name</label>
                                        <input type="text" placeholder="Enter First Name" name="first_name" class="form-control" >
                                     </div>
                                   </div>
                                   <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Last Name</label>
                                        <input type="text" placeholder="Enter Last Name" name="last_name" class="form-control" >
                                     </div>
                                   </div>
                                </div>

                               <div class="row">
                                  <div class="col-md-6">
                                    <div class="form-group">
                                       <label>Email</label>
                                        <input type="text" placeholder="Enter Your Email" name="email" class="form-control" >
                                    </div>
                                  </div>
                                  <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Password</label>
                                          <input type="text" placeholder="Enter your Password" name="password" class="form-control" >
                                    </div>
                                 </div>
                               </div>

                               <div class="row">
                               <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Mobile</label>
                                          <input type="number" placeholder="Enter your Mobile" name="mobile" class="form-control" >
                                    </div>
                                 </div>
                                 <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Designation</label>
                                          <input type="text" placeholder="Enter your Designation" name="designation" class="form-control" >
                                    </div>
                                 </div>
                              </div>

                              <div class="row">
                                <div class="col-md-6">
                                      <div class="form-group">
                                        <label>Select Group</label>
                                            <select class="form-control " name="group_id" id="group_id">
                                                  <option value="0">Select Group</option>
                                                  @foreach($groups as $group)
                                                    <option value="{{ $group->id }}">{{ $group->group_name }}</option>
                                                @endforeach
                                              </select>
                                      </div>
                                  </div>
                                 <div class="col-md-6">
                                    <div class="form-group">
                                     <label>Status</label>
                                        <select class="form-control" name="status_id" id="status_id">
                                            <option value="1">Active</option>
                                            <option value="2">In-Active</option>
                                          </select>
                                      </div>
                                   </div>
                                </div>
                                
                                <?php if(empty($pincodes)){?>
                                  <div class="row">
                                    <div class="col-md-6">
                                      <div class="form-group">
                                        <label>Select Property</label>
                                        <select class="form-control" name="property_id[]" id="property" multiple="">
                                          <option value="0">Please select</option>
                                          @foreach($properties as $property)
                                          <option value="{{ $property->id }}">{{ $property->name }}</option>
                                          @endforeach
                                        </select>
                                      </div>
                                    </div>
                                  </div>
                                <?php } ?>
                                
                                <?php if(!empty($pincodes)){?>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Assign Pin Code</label>
                                                <select class="form-control" name="assigned_pin[]" id="assigned_pin"  multiple="">
                                                    <option value="0">Please select</option>
                                                    @foreach($pincodes as $pin)
                                                        <option value="{{ $pin->pin }}">{{ $pin->pin }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                   <?php } ?>

                                  <div class="row">
                                    <div class="col-md-6">
                                      <div class="form-group">
                                        <label>Profile Image</label><br/>
                                        <input id="file-input" type="file" name="profile_image">
                                      </div>
                                    </div>
                                  </div><br/>


                                <button type="submit" class="btn btn-primary">Submit</button>
                                <a href="{{ route('staffs.index') }}" class="btn btn-primary">
                                Cancel
                              </a>
                       </form>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')


@endsection