
@extends('dashboard.base')

@section('css')

@endsection

@section('content')


<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Create Property</h4></div>
            <div class="card-body">
                        @if(Session::has('message'))
                            <div class="row">
                                <div class="col-12">
                                    <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                                </div>
                            </div>
                        @endif     

                        @if ($errors->any())
                              <div class="alert alert-danger">
                                 <ul>
                                       @foreach ($errors->all() as $error)
                                          <li>{{ $error }}</li>
                                       @endforeach
                                 </ul>
                              </div>
                           @endif       
           
                        <form method="POST" action="{{ route('properties.store') }}">
                            @csrf
                            <input name="marker" value="selectModel" type="hidden">
                               <div class="row">
                                  <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Name</label>
                                        <input type="text" placeholder="Enter Name" name="name" class="form-control" >
                                     </div>
                                   </div>
                                   <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Code</label>
                                        <input type="text" placeholder="Enter Code" name="code" class="form-control" >
                                     </div>
                                   </div>
                                   
                                </div>

                               <div class="row">
                               <div class="col-md-6">
                                    <div class="form-group">
                                       <label>Email</label>
                                        <input type="text" placeholder="Enter Your Email" name="email" class="form-control" >
                                    </div>
                                  </div>
                                 <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Mobile</label>
                                          <input type="number" placeholder="Enter your Mobile" name="mobile" class="form-control" >
                                    </div>
                                 </div>
                                
                               </div>

                             <div class="row">
                                 <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Organization Name</label>
                                        <input type="text" placeholder="Enter Your Org Name" name="org_name" class="form-control" >
                                     </div>
                                  </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Address</label>
                                          <input type="text" placeholder="Enter Address" name="address" class="form-control" >
                                    </div>
                                 </div>
                                 
                              </div>

                              <div class="row">
                                 <div class="col-md-6">
                                     <div class="form-group">
                                        <label>City</label>
                                        <input type="text"  placeholder="Enter City" class="form-control" name="city"/>
                                     </div>
                                  </div>
                                 <div class="col-md-6">
                                    <div class="form-group">
                                     <label>Country</label>
                                        <select class="form-control " name="country" id="country">
                                        <option value="0">Please select country</option>
                                              @foreach($countries as $country)
                                                 <option value="{{ $country->id }}">{{ $country->name }}</option>
                                             @endforeach
                                          </select>
                                      </div>
                                 </div>
                                 
                              </div>

                                <div class="row">
                                 <div class="col-md-6">
                                     <div class="form-group">
                                        <label>Provenance</label>
                                        <input type="text"  placeholder="Enter Provenance" class="form-control" name="provenance"/>
                                     </div>
                                  </div>
                                   <div class="col-md-6">
                                     <div class="form-group">
                                        <label>PIN</label>
                                        <input type="number"  placeholder="Enter Pin" class="form-control" name="pin" />
                                     </div>
                                    </div>
                                   
                                </div>

                                <div class="row">
                                <div class="col-md-6">
                                     <div class="form-group">
                                        <label>Phone 1</label>
                                        <input type="number"  placeholder="Enter Phone 1" class="form-control" name="phone_1" />
                                     </div>
                                    </div>
                                   <div class="col-md-6">
                                     <div class="form-group">
                                        <label>Phone 2</label>
                                        <input type="number"  placeholder="Enter Phone 2" class="form-control" name="phone_2" />
                                     </div>
                                  </div>
                                 
                               </div>

                                <div class="row">
                                 <div class="col-md-6">
                                    <div class="form-group">
                                     <label>Owner</label>
                                        <select class="form-control " name="owner" id="owner">
                                              @foreach($owners as $owner)
                                                 <option value="{{ $owner->id }}">{{ $owner->first_name }} {{ $owner->last_name }}</option>
                                             @endforeach
                                          </select>
                                      </div>
                                   </div>
                                 <div class="col-md-6">
                                    <div class="form-group">
                                     <label>Status</label>
                                        <select class="form-control" name="status_id" id="status_id">
                                            <option value="1">Active</option>
                                            <option value="2">In-Active</option>
                                          </select>
                                      </div>
                                   </div>
                                </div>

                                <button type="submit" class="btn btn-primary">Submit</button>
                                <a href="{{ route('properties.index') }}" class="btn btn-primary">
                                Cancel
                              </a>
                       </form>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')



@endsection