@extends('dashboard.base')

@section('content')

<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Edit General Search User</h4></div>
            <div class="card-body">
            {{ Session::get('message') }}
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                        </div>
                    </div>
                 @endif     

                 @if ($errors->any())
                      <div class="alert alert-danger">
                          <ul>
                              @foreach ($errors->all() as $error)
                                  <li>{{ $error }}</li>
                              @endforeach
                          </ul>
                      </div>
                  @endif

                        <form method="POST" action="/generalusers/{{ $generaluser->id }}"  enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                            <div class="row">
                                 <div class="col-md-6">
                                    <div class="form-group">
                                       <label>First Name</label>
                                        <input type="text" placeholder="Enter Your First Name" name="first_name" class="form-control" value="{{ $generaluser->first_name }}">
                                     </div>
                                </div>
                                <div class="col-md-6">
                                   <div class="form-group">
                                   <label>Last Name</label>
                                        <input type="text" placeholder="Enter Your Last Name" name="last_name" class="form-control" value="{{ $generaluser->last_name }}">
                                    </div>
                                </div>
                            </div>

                             <div class="row">
                                  <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Email</label>
                                        <input type="text" placeholder="Enter Your Email" name="email" class="form-control" value="{{ $generaluser->email }}" >
                                    </div>
                                  </div>
                                  <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Password</label>
                                          <input type="text" placeholder="Enter your Password" name="password" class="form-control"value="{{ $generaluser->org_password }}"  >
                                    </div>
                                  </div>
                              </div>

                              <div class="row">
                                   <div class="col-md-6">
                                     <div class="form-group">
                                        <label>Mobile</label>
                                        <input type="number" placeholder="Mobile" name="mobile" class="form-control" value="{{ $generaluser->mobile }}" >
                                     </div>
                                   </div>
                                   <div class="col-md-6">
                                        <div class="form-group">
                                          <label>Designation</label>
                                          <input type="text" placeholder="Enter your Designation" name="designation" class="form-control" value="{{ $generaluser->designation }}" >
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                 
                                  <div class="col-md-6">
                                     <div class="form-group">
                                        <label>Status</label>
                                        <select class="form-control" name="status_id" id="status_id">
                                            <option value="1" {{ $generaluser->status_id == 1 ? 'selected' : '' }} >Active</option>
                                            <option value="2" {{ $generaluser->status_id == 2 ? 'selected' : '' }}>In-Active</option>
                                          </select>
                                       </div>
                                     </div>
                                     <div class="col-md-6">
                                      <div class="form-group">
                                        <label>Profile Image</label><br/>
                                        <img src="<?php echo asset($generaluser->profile_image);?>" style="width: 50px;">
                                        <br/><br/>
                                        <input id="file-input" type="file" name="profile_image">
                                      </div>
                                    </div>
                                  </div><br/>


                                  <div class="row">
                                    <?php if(Auth::user()->id == 1){ //super admin ?>
                                    <div class="col-md-6">
                                      <div class="form-group">
                                        <label>Status</label>
                                        <select class="form-control " name="status" id="status">
                                            <option value="1"  {{ $generaluser->status == 1 ? 'selected' : '' }}>Public</option>
                                            <option value="2"  {{ $generaluser->status == 2 ? 'selected' : '' }}> Private</option>
                                        </select>
                                      </div>
                                    </div>
                                    <?php }?>
                                  </div>

                                <button type="submit" class="btn btn-primary">Save</button>
                                <a href="{{ route('generalusers.index') }}" class="btn btn-primary">
                                Cancel
                              </a>
                        </form>
                        </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')

@endsection