@extends('dashboard.base')

@section('content')

<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Edit Complaint Type</h4></div>
            <div class="card-body">
                        @if(Session::has('message'))
                            <div class="row">
                                <div class="col-12">
                                    <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                                </div>
                            </div>
                        @endif     

                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <form method="POST" action="/complainttypes/{{ $type->id }}">
                            @csrf
                            @method('PUT')
                            <div class="row">
                                 <div class="col-md-6">
                                    <div class="form-group">
                                       <label>Title</label>
                                        <input type="text" placeholder="Enter Room Title" name="title" class="form-control"  value="{{ $type->title }}">
                                     </div>
                                </div>
                                <div class="col-md-6">
                                   <div class="form-group">
                                   <label>Description</label>
                                        <input type="text" placeholder="Enter Description" name="description" class="form-control"  value="{{ $type->description }}">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                              <div class="col-md-6">
                                <div class="form-group">
                                  <label> Action taken for hotel.</label>
                                  <textarea class="form-control" id="textarea-input" name="action_taken_for_hotel" rows="4" placeholder=" Action taken for hotel..."><?php echo $type->action_taken_for_hotel; ?></textarea>
                                </div>
                              </div>
                              <div class="col-md-6">
                                <div class="form-group">
                                  <label>Action for police recommendation.</label>
                                  <textarea class="form-control" id="textarea-input" name="action_taken_for_police_recommanedation" rows="4" placeholder="Action for police recommendation..."><?php echo $type->action_taken_for_police_recommanedation; ?></textarea>
                                </div>
                              </div>
                            </div>

                            <div class="row">
                              <div class="col-md-6">
                                <div class="form-group">
                                  <label> Action by people suggestion.</label>
                                  <textarea class="form-control" id="textarea-input" name="action_by_people_suggesstion" rows="4" placeholder=" Action by people suggestion..."><?php echo $type->action_by_people_suggesstion; ?></textarea>
                                </div>
                              </div>
                              <div class="col-md-6">
                                <div class="form-group">
                                  <label>Ratings</label>
                                  <select class="form-control select2" name="complaint_rating" id="complaint_rating">
                                    <option value="0">Please select Rating</option>
                                      <option value="5" <?php if($type->complaint_rating ==  '5'){echo "selected";}?>>5 (Very Serious)</option>
                                      <option value="4" <?php if($type->complaint_rating ==  '4'){echo "selected";}?>>4 (Serious)</option>
                                      <option value="3" <?php if($type->complaint_rating ==  '3'){echo "selected";}?>>3 (Major)</option>
                                      <option value="2" <?php if($type->complaint_rating ==  '2'){echo "selected";}?>>2 (Minor)</option>
                                      <option value="1" <?php if($type->complaint_rating ==  '1'){echo "selected";}?>>1 (Very Minor)</option>
                                  </select>
                                </div>
                              </div>
                            </div>

                            

                            <button type="submit" class="btn btn-primary">Save</button>
                            <a href="{{ route('complainttypes.index') }}" class="btn btn-primary">
                            Cancel</a>

                        </form>
                        </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')

@endsection