<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use App\Models\IdProofTypes;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use DataTables;

class IdProofTypesController extends Controller
{
    public function index(Request $request){
        $main_id = Auth::user()->id;
            //manage privilege if its staff user
            if(Auth::user()->user_type == 4 || Auth::user()->user_type == 6){//4 = hotel admin staff , 6=govt admin staff

            //get staff info for group 
            $getGroup = DB::table('staffs')->select('group_id')->where('main_user_id', Auth::user()->id)->first();
            
            //get groups and privileges
            $getPrivileges = DB::table('groups_privileges')->where('group_id', $getGroup->group_id)->where('module_id','8')->first();//module_id = 5(Only customer module)

        } else {
            $getPrivileges = array();
        }

        if ($request->ajax()) {
            $data = IdProofTypes::where('created_by',$main_id)->orderBy('id','desc')->get();
     
                foreach($data as $type){
                    $id = $type->id;
                }

                if(!empty($getPrivileges)){
                    if($getPrivileges->edit ==1 && $getPrivileges->delete ==1){ //allow delete and edit access
                        $action =  '<a href="/idprooftypes/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
                    } else if($getPrivileges->edit ==1 && $getPrivileges->delete !=1){//allow edit access
                        $action = '<a href="/idprooftypes/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>';
                    } else if($getPrivileges->delete == 1 && $getPrivileges->edit != 1){
                        $action = '<button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
                    } else {
                        $action =  '';
                    }
                } else {
                    $action =  '<a href="/idprooftypes/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
                }

                return Datatables::of($data)
                        // ->addColumn('action', '<a href="/idprooftypes/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>')
                        ->addColumn('action',$action) 
                        ->rawColumns(['action'])
                        ->make(true);
        }
        return view('dashboard.idprooftypes.idProofTypessList',['privileges'=>$getPrivileges]);
    }

     /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        // $statuses = Status::all();
        return view('dashboard.idprooftypes.create');
    }

   /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'title'      => 'required|min:1|max:64',
            'description'       => 'required|min:1|max:64',
        ]);

        //insert new type
        $type = new IdProofTypes();
        $type->title    = $request->input('title');
        $type->description   =  $request->input('description');
        $type->created_by   = Auth::user()->id;
        $type->save();

        $request->session()->flash('message', 'ID Proof Type Created Successfully.');
        return redirect()->route('idprooftypes.index');
    }

    //for editing hotel admin
    public function edit($id)
    {
        $id_proof_type = IdProofTypes::find($id);
        return view('dashboard.idprooftypes.edit', [ 'type' => $id_proof_type ]);
    }

   /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'title'      => 'required|min:1|max:64',
            'description'       => 'required|min:1|max:64',
        ]);

          //insert new type
          $type = IdProofTypes::find($id);
          $type->title    = $request->input('title');
          $type->description   =  $request->input('description');
          $type->save();

        $request->session()->flash('message', 'ID Proof Type Updated Successfully');
        return redirect()->route('idprooftypes.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $type = IdProofTypes::find($id);
        if($type){
            $type->delete();
        }
        return redirect()->route('idprooftypes.index');
    }
}
