
@extends('dashboard.base')

@section('css')

@endsection

@section('content')


<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Create Room</h4></div>
            <div class="card-body">
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                        </div>
                    </div>
                 @endif      

                 @if ($errors->any())
                      <div class="alert alert-danger">
                          <ul>
                              @foreach ($errors->all() as $error)
                                  <li>{{ $error }}</li>
                              @endforeach
                          </ul>
                      </div>
                  @endif      
           
                        <form method="POST" action="{{ route('rooms.store') }}">
                            @csrf
                            <input name="marker" value="selectModel" type="hidden">
                               <div class="row">
                                  <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Title</label>
                                        <input type="text" placeholder="Enter room title" name="title" class="form-control" >
                                     </div>
                                   </div>
                                   <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Description</label>
                                        <input type="text" placeholder="Enter Description" name="description" class="form-control" >
                                     </div>
                                   </div>
                                </div>
                                <div class="row">
                                <div class="col-md-6">
                                  <div class="form-group">
                                    <label>Select Property</label>
                                    <select class="form-control" name="property_id" id="property_id">
                                      <option value="0">Please select</option>
                                        @foreach($properties as $property)
                                            <option value="{{ $property->id }}">{{ $property->name }}</option>
                                        @endforeach
                                    </select>
                                  </div>
                                </div>
                                <div class="col-md-6">
                                  <div class="form-group">
                                    <label>Select Room Type</label>
                                    <select class="form-control" name="room_type" id="room_type">
                                      <option value="0">Please select Type</option>
                                        @foreach($room_type as $type)
                                            <option value="{{ $type->id }}">{{ $type->title }}</option>
                                        @endforeach
                                    </select>
                                  </div>
                                </div>
                                
                                </div>

                                <button type="submit" class="btn btn-primary">Submit</button>
                                <a href="{{ route('rooms.index') }}" class="btn btn-primary">
                                Cancel
                              </a>
                       </form>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')


@endsection