<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['middleware' => ['get.menu']], function () {
    Route::get('/', function () {           return view('auth.login'); });
    // Route::get('/', function () {           return view('dashboard.homepage'); });
    Route::group(['middleware' => ['role:user']], function () {
        Route::group(['middleware' => ['auth']], function() {
            Route::get('/dashboard', function () {           return view('dashboard.homepage'); })->middleware('auth');;
            Route::get('/colors', function () {     return view('dashboard.colors'); });
            Route::get('/typography', function () { return view('dashboard.typography'); });
            Route::get('/charts', function () {     return view('dashboard.charts'); });
            Route::get('/widgets', function () {    return view('dashboard.widgets'); });
            Route::get('/404', function () {        return view('dashboard.404'); });
            Route::get('/500', function () {        return view('dashboard.500'); });
            Route::prefix('base')->group(function () {  
                Route::get('/breadcrumb', function(){   return view('dashboard.base.breadcrumb'); });
                Route::get('/cards', function(){        return view('dashboard.base.cards'); });
                Route::get('/carousel', function(){     return view('dashboard.base.carousel'); });
                Route::get('/collapse', function(){     return view('dashboard.base.collapse'); });

                Route::get('/forms', function(){        return view('dashboard.base.forms'); });
                Route::get('/jumbotron', function(){    return view('dashboard.base.jumbotron'); });
                Route::get('/list-group', function(){   return view('dashboard.base.list-group'); });
                Route::get('/navs', function(){         return view('dashboard.base.navs'); });

                Route::get('/pagination', function(){   return view('dashboard.base.pagination'); });
                Route::get('/popovers', function(){     return view('dashboard.base.popovers'); });
                Route::get('/progress', function(){     return view('dashboard.base.progress'); });
                Route::get('/scrollspy', function(){    return view('dashboard.base.scrollspy'); });

                Route::get('/switches', function(){     return view('dashboard.base.switches'); });
                Route::get('/tables', function () {     return view('dashboard.base.tables'); });
                Route::get('/tabs', function () {       return view('dashboard.base.tabs'); });
                Route::get('/tooltips', function () {   return view('dashboard.base.tooltips'); });
            });
            Route::prefix('buttons')->group(function () {  
                Route::get('/buttons', function(){          return view('dashboard.buttons.buttons'); });
                Route::get('/button-group', function(){     return view('dashboard.buttons.button-group'); });
                Route::get('/dropdowns', function(){        return view('dashboard.buttons.dropdowns'); });
                Route::get('/brand-buttons', function(){    return view('dashboard.buttons.brand-buttons'); });
            });
            Route::prefix('icon')->group(function () {  // word: "icons" - not working as part of adress
                Route::get('/coreui-icons', function(){         return view('dashboard.icons.coreui-icons'); });
                Route::get('/flags', function(){                return view('dashboard.icons.flags'); });
                Route::get('/brands', function(){               return view('dashboard.icons.brands'); });
            });
            Route::prefix('notifications')->group(function () {  
                Route::get('/alerts', function(){   return view('dashboard.notifications.alerts'); });
                Route::get('/badge', function(){    return view('dashboard.notifications.badge'); });
                Route::get('/modals', function(){   return view('dashboard.notifications.modals'); });
            });

            Route::resource('notes', 'NotesController');
            Route::resource('hoteladmins', 'HotelAdminController');
            Route::resource('properties', 'PropertiesController');
            Route::resource('govadmins', 'GovAdminController');
            Route::resource('myprofile', 'MyprofileController');
            Route::resource('rooms', 'RoomController');
            Route::resource('customers', 'CustomersController');
            Route::resource('groups', 'GroupsController');
            Route::resource('privileges', 'PrivilegesController'); 
            Route::resource('staffs', 'StaffsController');
            Route::resource('idprooftypes', 'IdProofTypesController');
            Route::resource('complaints', 'ComplaintsController');
            Route::resource('criminalrecords', 'CriminalRecordsController');
        });
    });
    Auth::routes();

    Route::resource('resource/{table}/resource', 'ResourceController')->names([
        'index'     => 'resource.index',
        'create'    => 'resource.create',
        'store'     => 'resource.store',
        'show'      => 'resource.show',
        'edit'      => 'resource.edit',
        'update'    => 'resource.update',
        'destroy'   => 'resource.destroy',
        'manageprivilage'=>'resource.manageprivilage'
    ]);
   Route::get('/', function () {           return view('auth.login'); });

   //for super admin
    Route::group(['middleware' => ['role:admin']], function () {
        Route::group(['middleware' => ['auth']], function() {
            Route::resource('bread',  'BreadController');   //create BREAD (resource)
            Route::resource('users',        'UsersController')->except( ['create', 'store'] );
            Route::resource('roles',        'RolesController');
            Route::resource('mail',        'MailController');

            //routes for manage hotel admin
            Route::resource('hoteladmins',        'HotelAdminController')->except( ['create', 'store'] );

            //routes for manage properties
            Route::resource('properties',        'PropertiesController')->except( ['create', 'store'] );

            //routes for manage gov admin
            Route::resource('govadmins',        'GovAdminController')->except( ['create', 'store'] );

            //routes for manage profile
            Route::resource('myprofile',        'MyProfileController')->except( ['create', 'store'] );

            //routes for manage rooms
            Route::resource('rooms', 'RoomController')->except( ['create', 'store'] );

            //routes for manage customers
            Route::resource('customers', 'CustomersController')->except( ['create', 'store'] );

            //routes for manage groups
            Route::resource('groups', 'GroupsController')->except( ['create', 'store'] );

            //routes for manage privilages
            Route::resource('privileges', 'PrivilegesController')->except( ['create', 'store'] );

            //routes for manage staffs
            Route::resource('staffs', 'StaffsController')->except( ['create', 'store'] );

            //routes for manage id proof types
            Route::resource('idprooftypes', 'IdProofTypesController')->except( ['create', 'store'] );

            //routes for manage complaint
            Route::resource('complaints', 'ComplaintsController')->except( ['create', 'store'] );

            //routes for manage criminal records
            Route::resource('criminalrecords', 'CriminalRecordsController')->except( ['create', 'store'] );

            Route::get('prepareSend/{id}',        'MailController@prepareSend')->name('prepareSend');
            Route::post('mailSend/{id}',        'MailController@send')->name('mailSend');
            Route::get('/roles/move/move-up',      'RolesController@moveUp')->name('roles.up');
            Route::get('/roles/move/move-down',    'RolesController@moveDown')->name('roles.down');
            Route::prefix('menu/element')->group(function () { 
                Route::get('/',             'MenuElementController@index')->name('menu.index');
                Route::get('/move-up',      'MenuElementController@moveUp')->name('menu.up');
                Route::get('/move-down',    'MenuElementController@moveDown')->name('menu.down');
                Route::get('/create',       'MenuElementController@create')->name('menu.create');
                Route::post('/store',       'MenuElementController@store')->name('menu.store');
                Route::get('/get-parents',  'MenuElementController@getParents');
                Route::get('/edit',         'MenuElementController@edit')->name('menu.edit');
                Route::post('/update',      'MenuElementController@update')->name('menu.update');
                Route::get('/show',         'MenuElementController@show')->name('menu.show');
                Route::get('/delete',       'MenuElementController@delete')->name('menu.delete');
            });
            Route::prefix('menu/menu')->group(function () { 
                Route::get('/',         'MenuController@index')->name('menu.menu.index');
                Route::get('/create',   'MenuController@create')->name('menu.menu.create');
                Route::post('/store',   'MenuController@store')->name('menu.menu.store');
                Route::get('/edit',     'MenuController@edit')->name('menu.menu.edit');
                Route::post('/update',  'MenuController@update')->name('menu.menu.update');
                Route::get('/delete',   'MenuController@delete')->name('menu.menu.delete');
            });
            Route::prefix('media')->group(function () {
                Route::get('/',                 'MediaController@index')->name('media.folder.index');
                Route::get('/folder/store',     'MediaController@folderAdd')->name('media.folder.add');
                Route::post('/folder/update',   'MediaController@folderUpdate')->name('media.folder.update');
                Route::get('/folder',           'MediaController@folder')->name('media.folder');
                Route::post('/folder/move',     'MediaController@folderMove')->name('media.folder.move');
                Route::post('/folder/delete',   'MediaController@folderDelete')->name('media.folder.delete');;

                Route::post('/file/store',      'MediaController@fileAdd')->name('media.file.add');
                Route::get('/file',             'MediaController@file');
                Route::post('/file/delete',     'MediaController@fileDelete')->name('media.file.delete');
                Route::post('/file/update',     'MediaController@fileUpdate')->name('media.file.update');
                Route::post('/file/move',       'MediaController@fileMove')->name('media.file.move');
                Route::post('/file/cropp',      'MediaController@cropp');
                Route::get('/file/copy',        'MediaController@fileCopy')->name('media.file.copy');
            });

            //for  hotel admins
            Route::prefix('/hoteladmins')->group(function () { 
                Route::post('/store',   'HotelAdminController@store')->name('hoteladmins.store');
                Route::get('/edit',     'HotelAdminController@edit')->name('hoteladmins.edit');
                Route::post('/update',  'HotelAdminController@update')->name('hoteladmins.update');
                Route::get('/delete',   'HotelAdminController@delete');
            });

            //for properties
            Route::prefix('/properties')->group(function () { 
                Route::post('/store',   'PropertiesController@store')->name('properties.store');
                Route::get('/edit',     'PropertiesController@edit')->name('properties.edit');
                Route::post('/update',  'PropertiesController@update')->name('properties.update');
                Route::get('/delete',   'PropertiesController@delete');
                Route::post('/exportCustomersByProperty',     'PropertiesController@exportCustomersByProperty')->name('properties.exportCustomersByProperty'); 
            });

            //for gov admin
            Route::prefix('/govadmins')->group(function () { 
                Route::post('/store',   'GovAdminController@store')->name('govadmins.store');
                Route::get('/edit',     'GovAdminController@edit')->name('govadmins.edit');
                Route::post('/update',  'GovAdminController@update')->name('govadmins.update');
                Route::get('/delete',   'GovAdminController@delete');
            });

            //for rooms
            Route::prefix('/rooms')->group(function () { 
                Route::post('/store',   'RoomController@store')->name('rooms.store');
                Route::get('/edit',     'RoomController@edit')->name('rooms.edit');
                Route::post('/update',  'RoomController@update')->name('rooms.update');
                Route::get('/delete',   'RoomController@delete');
            });

            //for Customers
            Route::prefix('/customers')->group(function () { 
                Route::post('/store',   'CustomersController@store')->name('customers.store');
                Route::get('/edit',     'CustomersController@edit')->name('customers.edit');
                Route::post('/update',  'CustomersController@update')->name('customers.update');
                Route::get('/delete',   'CustomersController@delete');
                Route::get('/loadCustomerDocs',     'CustomersController@loadCustomerDocs')->name('customers.loadCustomerDocs');
                Route::get('/addcomplaints','ComplaintsController@addcomplaints')->name('complaints.addcomplaint');
                Route::post('/export',     'CustomersController@export')->name('customers.export');
            
            });

            //for groups
            Route::prefix('/groups')->group(function () { 
                Route::post('/store',   'GroupsController@store')->name('groups.store');
                Route::get('/edit',     'GroupsController@edit')->name('groups.edit');
                Route::post('/update',  'GroupsController@update')->name('groups.update');
                Route::get('/delete',   'GroupsController@delete');
                Route::get('/manageprivilage',     'GroupsController@manageprivilage')->name('groups.manageprivilage');
            });

            //for privilages
            Route::prefix('/privileges')->group(function () { 
                Route::get('/edit','PrivilegesController@edit')->name('privileges.edit');
            }); 

            //for staff management in hotel admin
            Route::prefix('/staffs')->group(function () { 
                Route::post('/store',   'StaffsController@store')->name('staffs.store');
                Route::get('/edit',     'StaffsController@edit')->name('staffs.edit');
                Route::post('/update',  'StaffsController@update')->name('staffs.update');
                Route::get('/delete',   'StaffsController@delete');
            });

            //for staff management in hotel admin
            Route::prefix('/idprooftypes')->group(function () { 
                Route::post('/store',   'IdProofTypesController@store')->name('idprooftypes.store');
                Route::get('/edit',     'IdProofTypesController@edit')->name('idprooftypes.edit');
                Route::post('/update',  'IdProofTypesController@update')->name('idprooftypes.update');
                Route::get('/delete',   'IdProofTypesController@delete');
            }); 

            //routes for manage staffs
            Route::resource('myprofilesettings', 'SettingsController')->except( ['create', 'store'] );
        
            //for manage profile
            Route::prefix('/myprofilesettings')->group(function () { 
                Route::post('/',   'SettingsController@@index');
                Route::post('/changePassword',   'SettingsController@changePassword');
            });

            //for complaints
            Route::prefix('/complaints')->group(function () { 
                Route::get('/','ComplaintsController@index');

                Route::get('/addcomplaints','ComplaintsController@addcomplaints')->name('complaints.addcomplaints');
                // Route::get('/view','ComplaintsController@addcomplaints')->name('complaints.addcomplaints');
            });

            //for  criminal records
            Route::prefix('/criminalrecords')->group(function () { 
                Route::post('/store',   'CriminalRecordsController@store')->name('criminalrecords.store');
                Route::get('/edit',     'CriminalRecordsController@edit')->name('criminalrecords.edit');
                Route::post('/update',  'CriminalRecordsController@update')->name('criminalrecords.update');
                Route::get('/delete',   'CriminalRecordsController@delete');
            });
        });
    });

    //for only hotel admin
    Route::group(['middleware' => ['role:user']], function () {
        Route::group(['middleware' => ['auth']], function() {
            //routes for manage profile
            Route::resource('myprofile', 'MyProfileController');

            //routes for manage properties
            Route::resource('properties', 'PropertiesController')->except( ['create', 'store'] );

            //routes for manage rooms
            Route::resource('rooms', 'RoomController')->except( ['create', 'store'] );

            //routes for manage customers
            Route::resource('customers', 'CustomersController')->except( ['create', 'store'] );

            //routes for manage groups
            Route::resource('groups', 'GroupsController')->except( ['create', 'store'] );

            //routes for manage privilages
            Route::resource('privileges', 'PrivilegesController')->except( ['create', 'store'] );

            //routes for manage staffs
            Route::resource('staffs', 'StaffsController')->except( ['create', 'store'] );

            //routes for manage id proof types
            Route::resource('idprooftypes', 'IdProofTypesController')->except( ['create', 'store'] );

            //routes for manage staffs
            Route::resource('myprofilesettings', 'SettingsController')->except( ['create', 'store'] );
            
            //routes for manage staffs
            Route::resource('changePassword', 'SettingsController')->except( ['create', 'store'] );
            
            //routes for manage complaint
            Route::resource('complaints', 'ComplaintsController')->except( ['create', 'store'] );

            //routes for manage criminal records
            Route::resource('crminalrecords', 'CriminalRecordsController')->except( ['create', 'store'] );


            //for manage profile
            Route::prefix('/myprofilesettings')->group(function () { 
                Route::post('/',   'SettingsController@@index');
                Route::get('/update', 'SettingsController@update')->name('myprofilesettings.update');
            });

            //for manage profile
            Route::prefix('/changePassword')->group(function () { 
                Route::post('/changePassword',   'SettingsController@changePassword');
            });

            Route::prefix('/myprofile')->group(function () { 
                Route::post('/',   'GovAdminController@index');
                Route::post('/store',   'MyProfileController@store')->name('myprofile.store');
                Route::get('/edit',   'MyProfileController@edit')->name('myprofile.edit');
                Route::post('/update',  'MyProfileController@update')->name('myprofile.update');
                // Route::post('/changePassword',  'MyProfileController@changePassword')->name('myprofile.update');
            });

            //for properties
            Route::prefix('/properties')->group(function () { 
                Route::post('/store',   'PropertiesController@store')->name('properties.store');
                Route::get('/edit',     'PropertiesController@edit')->name('properties.edit');
                Route::post('/update',  'PropertiesController@update')->name('properties.update');
                Route::get('/delete',   'PropertiesController@delete');
                Route::post('/exportCustomersByProperty',     'PropertiesController@exportCustomersByProperty')->name('properties.exportCustomersByProperty');
            });

            //for rooms
            Route::prefix('/rooms')->group(function () { 
                Route::post('/store',   'RoomController@store')->name('rooms.store');
                Route::get('/edit',     'RoomController@edit')->name('rooms.edit');
                Route::post('/update',  'RoomController@update')->name('rooms.update');
                Route::get('/delete',   'RoomController@delete');
            });
            
            //for Customers
            Route::prefix('/customers')->group(function () { 
                Route::post('/store',   'CustomersController@store')->name('customers.store');
                Route::get('/edit',     'CustomersController@edit')->name('customers.edit');
                Route::post('/update',  'CustomersController@update')->name('customers.update');
                Route::get('/delete',   'CustomersController@delete');
                Route::get('/remove_doc',   'CustomersController@remove_doc')->name('customers.remove_doc');
                Route::post('/saveBasicInfo',     'CustomersController@saveBasicInfo')->name('customers.saveBasicInfo');
                Route::post('/saveDocumentInfo',     'CustomersController@saveDocumentInfo')->name('customers.saveDocumentInfo');
                Route::post('/getCustomerDocs',     'CustomersController@getCustomerDocs')->name('customers.getCustomerDocs');
                Route::get('/loadCustomerDocs',     'CustomersController@loadCustomerDocs')->name('customers.loadCustomerDocs');
                Route::get('/export',     'CustomersController@export')->name('customers.export');
                Route::get('/getDocs',     'CustomersController@getDocs')->name('customers.getDocs');
                Route::get('/viewdetails',     'CustomersController@viewdetails')->name('customers.viewdetails');
                Route::get('/getComplaints',     'CustomersController@getComplaints')->name('customers.getComplaints');
                Route::get('/getCriminalRecord',     'CustomersController@getCriminalRecord')->name('customers.getCriminalRecord');
                 Route::post('/update_basic_info',     'CustomersController@update_basic_info')->name('customers.update_basic_info');
                Route::post('/updatte_profile_image',     'CustomersController@updatte_profile_image')->name('customers.updatte_profile_image');
                Route::post('/saave_docs_by_dropzone',     'CustomersController@saave_docs_by_dropzone')->name('customers.saave_docs_by_dropzone');
            
                Route::post('/saveAdditionalInfo',     'CustomersController@saveAdditionalInfo')->name('customers.saveAdditionalInfo');
                Route::post('/saveNotesInfo',     'CustomersController@saveNotesInfo')->name('customers.saveNotesInfo');
                Route::get('/getNotes',     'CustomersController@getNotes')->name('customers.getNotes');
                
                Route::post('/getRoomsByProperty',     'CustomersController@getRoomsByProperty')->name('customers.getRoomsByProperty');
                
            });

            //for groups
            Route::prefix('/groups')->group(function () { 
                Route::post('/store',   'GroupsController@store')->name('groups.store');
                Route::get('/edit',     'GroupsController@edit')->name('groups.edit');
                Route::post('/update',  'GroupsController@update')->name('groups.update');
                Route::get('/delete',   'GroupsController@delete');
                // Route::get('/editprivilages','GroupsController@manageprivilage')->name('groups.manageprivilage');
            });

            //for privilages
            Route::prefix('/privileges')->group(function () { 
                Route::get('/edit','PrivilegesController@edit')->name('privileges.edit');
                Route::post('/update',  'PrivilegesController@update')->name('privileges.update');
            }); 

            //for staff management in hotel admin
            Route::prefix('/staffs')->group(function () { 
                Route::post('/store',   'StaffsController@store')->name('staffs.store');
                Route::get('/edit',     'StaffsController@edit')->name('staffs.edit');
                Route::post('/update',  'StaffsController@update')->name('staffs.update');
                Route::get('/delete',   'StaffsController@delete');
            }); 

            //for staff management in hotel admin
            Route::prefix('/idprooftypes')->group(function () { 
                Route::post('/store',   'IdProofTypesController@store')->name('idprooftypes.store');
                Route::get('/edit',     'IdProofTypesController@edit')->name('idprooftypes.edit');
                Route::post('/update',  'IdProofTypesController@update')->name('idprooftypes.update');
                Route::get('/delete',   'IdProofTypesController@delete');
            }); 

            //for complaints
            Route::prefix('/complaints')->group(function () { 
                Route::post('/store','ComplaintsController@store')->name('complaints.store');
            });

            //for  criminal records
            Route::prefix('/criminalrecords')->group(function () { 
                Route::post('/store',   'CriminalRecordsController@store')->name('criminalrecords.store');
                Route::get('/edit',     'CriminalRecordsController@edit')->name('criminalrecords.edit');
                Route::post('/update',  'CriminalRecordsController@update')->name('criminalrecords.update');
                Route::get('/delete',   'CriminalRecordsController@delete');
            });
        });
    });
});




