
@extends('dashboard.base')

@section('css')

@endsection

@section('content')


<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Update Visitor</h4></div>
            <div class="card-body">
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                        </div>
                    </div>
                 @endif      

                 @if ($errors->any())
                      <div class="alert alert-danger">
                          <ul>
                              @foreach ($errors->all() as $error)
                                  <li>{{ $error }}</li>
                              @endforeach
                          </ul>
                      </div>
                  @endif      
           
                        <form method="POST" id="basic_info" action="/visitorslist/{{ $visitor->id }}"  enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                            <input name="marker" value="selectModel" type="hidden">
                                <div class="row">
                                  <div class="col-md-6">
                                    <div class="form-group">
                                      <label>Name</label>
                                      <input type="text" placeholder="Enter Name" name="name" value="<?php echo $visitor->name; ?>" class="form-control" >
                                    </div>
                                  </div>
                                  <div class="col-md-6">
                                    <div class="form-group">
                                      <label>Title</label>
                                      <input type="text" placeholder="Enter Title" name="title" value="<?php echo $visitor->title; ?>"  class="form-control" >
                                    </div>
                                  </div>
                                </div>

                                <div class="row">
                                  <div class="col-md-6">
                                    <div class="form-group">
                                      <label>Select Property</label>
                                      <select class="form-control" name="property_id" id="property_id">
                                        <option value="0">Please select</option>
                                        @foreach($properties as $property)
                                          <option value="{{ $property->id }}" <?php if($visitor->property_id == $property->id ){ echo "selected";}?>>{{ $property->name }}</option>
                                        @endforeach
                                      </select>
                                    </div>
                                  </div>
                                  <div class="col-md-6">
                                    <div class="form-group">
                                      <label>Company</label>
                                      <input type="text" value="<?php echo $visitor->company; ?>"  placeholder="Enter Company" name="company" class="form-control" >
                                    </div>
                                  </div>
                                </div>

                                <div class="row">
                                  <div class="col-md-6">
                                    <div class="form-group">
                                    <label>Telephone</label>
                                    <input type="number" value="<?php echo $visitor->telephone; ?>" placeholder="Enter Telephone" name="telephone" class="form-control" >
                                    </div>
                                  </div>
                                  <div class="col-md-6">
                                    <div class="form-group">
                                    <label>Visiting Whoom</label>
                                    <input type="text" placeholder="Enter Visiting Whoom" value="<?php echo $visitor->visiting_whoom; ?>" name="visiting_whoom" class="form-control" >
                                    </div>
                                  </div>
                                </div>

                                <div class="row">
                                  <div class="col-md-3">
                                    <div class="form-group">
                                      <label>Visit In Date</label>
                                      <input type="date" placeholder="Enter Visit In Date" value="<?php echo $visitor->visit_in_date; ?>" id="visit_in_date"  name="visit_in_date" class="form-control datetimepicker">
                                    </div>
                                  </div>
                                  <div class="col-md-3">
                                    <div class="form-group">
                                      <label>Visit In Time</label>
                                      <input type="time" placeholder="Enter Visit In Time" value="<?php echo $visitor->visit_in_time; ?>" id="visit_in_time"  name="visit_in_time" class="form-control datetimepicker">
                                    </div>
                                  </div>
                                  <div class="col-md-3">
                                    <div class="form-group">
                                      <label>Visit Out Date</label>
                                      <input type="date" placeholder="Enter Visit Out Date" value="<?php echo $visitor->visit_out_date; ?>" id="visit_out_date"  name="visit_out_date" class="form-control datetimepicker">
                                    </div>
                                  </div>
                                  <div class="col-md-3">
                                    <div class="form-group">
                                      <label>Visit Out Time</label>
                                      <input type="time" placeholder="Enter Visit Out Time"  value="<?php echo $visitor->visit_out_time; ?>" id="visit_out_time"  name="visit_out_time" class="form-control datetimepicker">
                                    </div>
                                  </div>
                                </div>

                                <div class="row">
                                  <div class="col-md-6">
                                    <div class="form-group">
                                      <label>Reason</label>
                                      <textarea placeholder="Enter Reason" cols="5" rows="5" name="reason" class="form-control" ><?php echo $visitor->reason; ?></textarea>
                                    </div>
                                  </div>
                                  <div class="col-md-6">
                                    <div class="form-group">
                                      <label>Remark</label>
                                    <textarea placeholder="Enter Remark" cols="5" rows="5" name="remark" class="form-control" ><?php echo $visitor->remark; ?></textarea>
                                    </div>
                                  </div>
                                </div>

                                <div class="row">
                                  <div class="col-md-6">
                                    <div class="form-group">
                                      <label>Vehicle No</label>
                                      <input type="text" placeholder="Enter Vehicle No" name="vehicle_no" value="<?php echo $visitor->vehicle_no; ?>" class="form-control" >
                                    </div>
                                  </div>
                                  <div class="col-md-6">
                                    <div class="form-group">
                                      <label>Photo</label>
                                      <input type="file" name="visitor_image" class="form-control" >
                                    </div>
                                  </div>
                                </div>
                                
                                <div class="row">
                                  <div class="col-md-6">
                                    <div class="form-group">
                                      <label>Qr Code</label>
                                      <input type="text" placeholder="Enter qr code" name="qr_code" value="<?php echo $visitor->qr_code; ?>" class="form-control" >
                                    </div>
                                  </div>
                                  <div class="col-md-3">
                                    <div class="form-group"><span><?php echo QrCode::generate($visitor->qr_code);?></span>
                                    </div>
                                  </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-3">
                                  <hr/>
                                  </div>
                                </div>
                                <div class="row">
                                  <div class="col-md-1"></div>
                                  <div class="col-md-8">
                                      <center><span><b>View Added Images</b></span></center><br/>
                                    <table class="table table-bordered data-table" >
                                      <thead>
                                        <tr>
                                          <th width="50">Sr No</th> 
                                          <th>Created At</th>
                                          <th>View Image</th>
                                        </tr>
                                      </thead>
                                      <tbody>
                                        <?php 
                                          $baseUrl = url('/');
                                          $seq = 1;
                                          $path ='';
                                          foreach($images as $img){
                                            $path = 'storage/app/public/uploads/hotel_admins/'.$visitor->created_by.'/'.'visitors/'.$img->image;
                                          ?>
                                            <tr>
                                              <td><?php echo $seq; ?> </td>
                                              <td><?php echo $img->created_at; ?> </td>
                                              <td>
                                                <a href ="<?php echo asset                 ($path);?>" target="_blank"             ?>View</a>
                                              </td>
                                            </tr>
                                        <?php $seq++; } ?>
                                      </tbody>
                                    </table>
                                  </div>
                                  <div class="col-md-2"></div>
                                </div>
                      
                                <button type="submit" class="btn btn-primary">Submit</button>
                                <a href="{{ route('visitorslist.index') }}" class="btn btn-primary">
                                Cancel
                              </a>
                       </form>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')


@endsection