					  
@extends('dashboard.base')

@section('content')

    @if(Session::has('message'))
        <div class="row">
            <div class="col-12">
                <!-- <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
              </div> -->
              <div class="alert alert-success alert-dismissible fade show" role="alert">{{ Session::get('message') }}
                <button class="close" type="button" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
              </div>
            </div>
        </div>
        @endif                 
       <div class="container-fluid">
          <div class="animated fadeIn">
            <div class="row">
              <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12">
                <div class="card">
                    <div class="card-header">
                      <i class="fa fa-align-justify"></i>Undo Checkout </div>
                    <div class="card-body">
                      <div class="row">
                        <div class="col-md-3">
                          <div class="form-group">
                            <label>Select Property</label>
                            <select class="form-control" name="property_id" id="property_filter">
                                <?php if(count($properties) == 1){ ?>
                                <?php } else { ?>
                                    <option value="0">Please select</option>
                                <?php } ?>
                   
                              @foreach($properties as $property)
                                  <option value="{{ $property->id }}">{{ $property->name }}</option>
                              @endforeach
                            </select>
                          </div>
                        </div>
                        <div class="col-md-3">
                          <div class="form-group">
                            <label>Select Room</label>
                            <select class="form-control" name="room_id" id="room_filter">
                              <option value="0">Please select</option>
                            </select>
                          </div>
                        </div>
                      </div>

                      <div class="row">
                      <div class="col-md-12">
                        <div id="cust_data_tbl">
                        </div>
                        </div>
                      </div>
                    </div>
                </div>
              </div>
            </div>
          </div>
        </div>


          <!-- /.modal-->
          <div class="modal fade" id="dangerModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
             <input type="hidden" name='delete_record_id' id="delete_record_id" value="">
              <div class="modal-dialog modal-danger" role="document">
                <div class="modal-content">
                  <div class="modal-header">
                    <h4 class="modal-title">Delete</h4>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                  </div>
                  <div class="modal-body">
                    <p>Are you sure, You want to delete this record ? </p>
                  </div>
                  <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button class="btn btn-danger" id="confirm" data-dismiss="modal" type="button">Confirm</button>
                  </div>
                </div>
                <!-- /.modal-content-->
              </div>
              <!-- /.modal-dialog-->
            </div>
            <!-- /.modal-->


@endsection


@section('javascript')


<script type="text/javascript">
  $(function () {
  
  
  if($('#property_filter').val() != 0){
      $('#property_filter').trigger('change');
  } 
  
    //for property and date range wise filter
    $(document).on("change", "#property_filter", function() {
      var propVal = $('#property_filter').val(); 
      var room = $('#room_filter').val();  
      $.ajax({
        type: 'post',
        url: '/customers/getRoomsByProperty',
        data: {
            '_method':'POST',
            '_token': $('input[name=_token]').val(),
            'property_id': propVal,//id of customer
        },
        success: function(resdata) {
            if(resdata){
            $('#room_filter').html(resdata.html);  
            }
        }
      }); 
    }); 

    $(document).on("change", "#room_filter", function() {
      var propVal = $('#property_filter').val(); 
      var room = $('#room_filter').val();  
      $.ajax({
        type: 'post',
        url: '/customers/getCheckedoutFoliosByRoom',
        data: {
            '_method':'POST',
            '_token': $('input[name=_token]').val(),
            'room_id': room,//id of customer
            'is_undo_checkout' :1
        },
        success: function(resdata) {
          if(resdata){
            $('#cust_data_tbl').html(resdata);  
          }
        }
      }); 
    }); 
    
    $(document).on("click", "#undo_checkout_all", function() {
        // $('.theClass:checkbox:checked')
        var date = new Date();
        var year = date.getFullYear();
        var month = date.getMonth() + 1;
        var day = date.getDate();
        var hours = date.getHours();
        var minutes = date.getMinutes();
        var seconds = date.getSeconds();
        var curdate = year + "-" + month + "-" + day + " " + hours + ":" + minutes + ":" + seconds
        console.log(year + "-" + month + "-" + day + " " + hours + ":" + minutes + ":" + seconds);

        var arr = [];
        $('input.checkout_cust:checkbox:checked').each(function () {
            arr.push($(this).val());
        });

        var cnf = confirm('Are you sure , You want to proceed with undo checkouts ?');
        if(cnf){
          $.ajax({
          type: 'post',
          url: '/customers/roomAllUndoCheckout',
          data: {
              '_method':'POST',
              '_token': $('input[name=_token]').val(),
              'checkout_cust_ar': arr,//id of customer
              'is_all_undo_checkout' :1,
              'checkout_datetime':curdate
          },
          success: function(resdata) {
            if(resdata){
              alert("Undo Done successfully..!");
              setInterval(function () {location.reload();}, 2000);
            }
          }
        }); 
      }
    }); 
  });

</script>


@endsection
