@extends('dashboard.base')

@section('css')

@endsection

@section('content')
 
<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Create Reservatiin</h4></div>
            <div class="card-body">
              @if(Session::has('message'))
                <div class="row">
                  <div class="col-12">
                    <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                  </div>
                </div>
              @endif      

              @if ($errors->any())
                <div class="alert alert-danger">
                  <ul>
                    @foreach ($errors->all() as $error)
                      <li>{{ $error }}</li>
                    @endforeach
                  </ul>
                </div>
              @endif      
           
              <form method="POST" action="{{ route('reservations.store') }}" id="res_form">
                @csrf
                <input name="marker" value="selectModel" type="hidden">
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Reservation No.*</label>
                      <input type="text" style="border: 2px solid blue;" placeholder="Enter Reservation No" name="reservation_no" class="form-control" >
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Source Booking No.*</label>
                      <input type="text" style="border: 2px solid blue;" placeholder="Enter Source Booking No" name="source_booking_no" class="form-control" >
                    </div>
                  </div>
                </div>

                <div class="row">
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Select Source*</label>
                      <select class="form-control" style="border: 2px solid blue;" name="source" id="source">
                        <option value="0">Please select</option>
                          @foreach($sources as $source)
                              <option value="{{ $source->id }}">{{ $source->title }}</option>
                          @endforeach
                      </select>
                      <span id="source_error" style="color:red;display:none;">Please select Source</span>
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Select Property*</label>
                      <select class="form-control" style="border: 2px solid blue;" name="property_id" id="property_id">
                        <option value="0">Please select</option>
                          @foreach($properties as $property)
                              <option value="{{ $property->id }}">{{ $property->name }}</option>
                          @endforeach
                      </select>
                      <span id="property_error" style="color:red;display:none;">Please select Property</span>
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Room*</label>
                      <select class="form-control " style="border: 2px solid blue;" name="room_id" id="room">
                        <option value="0">Select Room</option>
                      </select>
                      <span id="room_error" style="color:red;display:none;">Please select Room</span>
                    </div>
                  </div>
                </div>

                <div class="row">
                  <div class="col-md-3">
                    <div class="form-group">
                      <label>From Date</label>
                      <input type="date" placeholder="Enter From Date" id="from_date" value="<?php echo date('Y-m-d'); ?>" name="from_date" class="form-control datetimepicker">
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label>From Time</label>
                      <input type="time" value="02:00" placeholder="Enter From Time" id="from_time"  name="from_time" class="form-control datetimepicker">
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label>TO Date</label>
                      <input type="date" placeholder="Enter To Date" id="to_date" value="<?php echo date('Y-m-d'); ?>" name="to_date" class="form-control datetimepicker">
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label>To Time</label>
                      <input type="time" value="02:00" placeholder="Enter TO Time" id="to_time"  name="to_time" class="form-control datetimepicker">
                    </div>
                  </div>
                </div>

                <div class="row">
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Reserved By</label>
                      <input type="text" placeholder="Reserved By" name="reserved_by" class="form-control" >
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Details</label>
                      <textarea placeholder="Details" name="reservation_details" class="form-control" ></textarea>
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Notes</label>
                      <textarea placeholder="Notes" name="reservation_notes" class="form-control" ></textarea>
                    </div>
                  </div>
                </div>

                <div class="row">
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Remarks</label>
                      <textarea placeholder="Remarks" name="reservation_remarks" class="form-control" ></textarea>
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Status</label>
                      <select class="form-control " name="status" id="status">
                        <option value="1">Pending</option>
                        <option value="2">Checked In</option>
                        <option value="3">Don't Show</option>
                        <option value="4">Cancel</option>
                      </select>
                    </div>
                  </div>
                </div>

                <button type="submit" class="btn btn-primary">Submit</button>
                <a href="{{ route('sources.index') }}" class="btn btn-primary">
                  Cancel
                </a>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')

<script type="text/javascript">

  $(document).on("change", "#property_id", function() {
    var propVal = $('#property_id').val(); 
    $.ajax({
      type: 'post',
      url: '/customers/getRoomsByProperty',
      data: {
        '_method':'POST',
        '_token': $('input[name=_token]').val(),
        'property_id': propVal,//id of customer
      },
      success: function(resdata) {
        if(resdata){
          $('#room').html(resdata.html);  
        }
      }
    }); 
  });
</script>

@endsection