@extends('dashboard.base')

@section('content')

<style>
.text-right{
    text-align:right;
}
</style>

    @if(Session::has('message'))
        <div class="row">
            <div class="col-12">
                <!-- <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
              </div> -->
              <div class="alert alert-success alert-dismissible fade show" role="alert">{{ Session::get('message') }}
                <button class="close" type="button" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
              </div>
            </div>
        </div>
    @endif    

    <div class="container-fluid">
        <div class="animated fadeIn">
            <div class="row">
                <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12">
                    <div class="card">
                        <div class="card-header"><h4>Commercial Collection Report</h4></div>
                        <div class="card-body">
                            <form method="POST" action="{{ route('commercialtaxinvoicelist.downloadCommercialCollectionReport') }}"  enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Select Property</label>
                                            <select class="form-control" name="property_id" id="property_id">
                                                <option value="0">Please select</option>
                                                @foreach($properties as $property)
                                                    <option value="{{ $property->id }}">{{ $property->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Select Month</label>
                                            <select class="form-control" name="month" id="month">
                                                <option value="01">January 2024</option>
                                                <option value="02">February 2024</option>
                                                <option value="03">March 2024</option>
                                                <option value="04">April 2024</option>
                                                <option value="05" selected>May 2024</option>
                                                <option value="06">June 2024</option>
                                                <option value="07">July 2024</option>
                                                <option value="08">August 2024</option>
                                                <option value="09">September 2024</option>
                                                <option value="10">October 2024</option>
                                                <option value="11">November 2024</option>
                                                <option value="12">December 2024</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Select Payment Type</label>
                                            <select class="form-control" name="payment_method_id" id="payment_method_id">
                                                 <option value="all">All Types</option></option>
                                                @foreach($paymentmethods as $type)
                                                    <option value="{{ $type->id }}">{{ $type->title }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <button type="submit"  style="margin-top: 32px;" class="btn btn-primary" name="download_collection_report" id="download_collection_report">Download Report</button>
                                        </div>
                                    </div>
                                </div>
                            </form>

                            <center><span id="list_info_text"></span></center><br/>
                            <table  style="width: 102%; margin-left: -15px;" class="table table-bordered data-table" id="scan_datatable">
                                <thead>
                                    <tr>
                                        <th>Invoice No</th>
                                        <th>Receipt Date</th>
                                        <th>Payment Type</th>
                                        <th>Total($)</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                                <tfoot> 
                                    <tr>
                                        <th><b>Totals</b></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                    </tr>
                                </tfoot>
                            </table>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('javascript')
<script type="text/javascript">
    $(function () {

        $(document).on('change','#property_id', (function (e) {
            getCollectionReport();
        }));

        $(document).on('change','#month', (function (e) {
            getCollectionReport();
        }));

        $(document).on('change','#payment_method_id', (function (e) {
            getCollectionReport();
        }));

        
    function getCollectionReport(){
        var property = $('#property_id').val();
        var month = $('#month').val();
        var payment_method_id = $('#payment_method_id').val();
        var resp = 'Commercial Collection Report for Property: <b>'+$("#property_id option:selected"). text()+'</b> for  <b>'+$("#month option:selected"). text()+'</b> in  <b>'+$("#payment_method_id option:selected"). text()+'</b>';
        $('#list_info_text').html(resp);
        $('#scan_datatable').DataTable({
            bDestroy: true,
            processing: true,
            serverSide: true,
            ajax:{
                    url: "{{ route('commercialreceiptsettings.getCommercialCollectionReports')}}",
                    data: {
                        'is_commercial_collection_report':1,
                        property_id: property,
                        month: month,
                        payment_method_id:payment_method_id
                    },
                },
            order: [],
            columns: [
                {data: 'invoice_no', name: 'invoice_no'},
                {data: 'receipt_date', name: 'receipt_date'},
                {data: 'payment_type', name: 'payment_type'},
                {data: 'total_amt', name: 'total_amt',className: "text-right"},
            ],
            "footerCallback": function (row, data, start, end, display) {                
                //Get data here 
                //Do whatever you want. Example:
                var totalAmount = 0;
                for (var i = 0; i < data.length; i++) {
                    totalAmount += parseFloat(data[i]['total_amt']);
                }
                var nCells = row.getElementsByTagName('th');
                nCells[3].innerHTML = totalAmount.toFixed(2);
            }
        });
    }
});
</script>

@endsection