
@extends('dashboard.base')

@section('css')

@endsection

@section('content')

<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>PBX Settings</h4></div>
            <div class="card-body">
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                        </div>
                    </div>
                 @endif      

                 @if ($errors->any())
                      <div class="alert alert-danger">
                          <ul>
                              @foreach ($errors->all() as $error)
                                  <li>{{ $error }}</li>
                              @endforeach
                          </ul>
                      </div>
                  @endif      
           
                <form method="POST" action="{{ route('pbxsetting.submitpbxsettings') }}">
                    @csrf
                    <input name="marker" value="selectModel" type="hidden">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>IP/Url</label>
                                    <input type="text" placeholder="Enter IP or Url" name="ip_or_url" value="{{ old('ip_or_url', $pbx->ip_or_url ?? '') }}" class="form-control" >
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Extension</label>
                                    <input type="number" placeholder="Enter Extension" name="extension"  value="{{ old('extension', $pbx->extension ?? '') }}" class="form-control" >
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Password</label>
                                  <input type="text" name="password" class="form-control"
       value="{{ old('password', optional($pbx)->password) }}"> </div>
                            </div>
                        </div>

                    <button type="submit" class="btn btn-primary">Submit</button>
                    <a href="{{ route('pbxsetting.pbxSettinglist') }}" class="btn btn-primary">
                    Cancel
                    </a>
                </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')


@endsection