@extends('dashboard.base')

@section('content')
<style>
    .bg-secondary{
        background-color:#a7cef0 !important;
    }
    .bg-primary{
        background-color:#edc0b0  !important;
        padding: 12px;
        border-radius: 22px;
        font-size: 16px;
    }
    .bg-danger {
        background-color: #dc3545 !important;
        color: white !important;
    }

    #chat-box {
        height: 500px;
        overflow-y: auto;
        padding: 20px;
        background: #f5f5f5;
        border: 1px solid #ddd;
    }
    
    .text-start {
        margin-bottom: 10px;
        text-align: left;
    }

    .text-end {
        margin-bottom: 10px;
        text-align: right;
    }

    #chat-box .fw-bold {
        font-size: 0.85rem;
        color: #6c757d;
    }
    
    #chat-box small {
        font-size: 0.75rem;
        color: #6c757d;
    }
    
  #rooms_list {
    max-height: 300px;
    overflow-y: auto;
  }
    </style>
<div class="d-flex" style="height: 100vh; overflow: hidden;">

    {{-- Sidebar --}}
    <div style="width: 300px; background: #f8f9fa; border-right: 1px solid #ddd; padding: 15px;">
        <h5>Properties</h5>
        <select id="property_id" class="form-control mb-3">
            <option value="">-- Select Property --</option>
            @foreach($properties as $property)
                <option value="{{ $property->id }}">{{ $property->name }}</option>
            @endforeach
        </select>

        <h5>Room</h5>
        <ul id="rooms_list" class="list-group">
            {{-- Populated via JS --}}
        </ul>
    </div>

    {{-- Chat Area --}}
    <div class="flex-grow-1 d-flex flex-column">
        <div style="padding: 15px; border-bottom: 1px solid #ddd; background-color: #e9ecef;">
            <h4>Notifications</h4>
        </div>

        <div id="chat-box" class="flex-grow-1" style="overflow-y:auto; padding: 15px; background-color: #fff;"></div>

        <div style="padding: 10px; background-color: #f1f3f5; border-top: 1px solid #ddd;">
            <form id="chat-form" class="d-flex gap-2">
                <input type="hidden" id="sender_id" value="{{ $admin_id }}">
                <input type="hidden" id="receiver_id">
                <textarea id="notification" class="form-control" rows="1" placeholder="Enter Notification..."></textarea>
                <button type="submit" class="btn btn-primary">Send</button>
            </form>
        </div>
    </div>
</div>
@endsection

@section('javascript')

<script src="https://js.pusher.com/8.2.0/pusher.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>

<script>

    const senderId = document.getElementById('sender_id').value;
    const propertySelect = document.getElementById('property_id');
    const roomsList = document.getElementById('rooms_list');
    const receiverIdInput = document.getElementById('receiver_id');
    const chatBox = document.getElementById('chat-box');
    let currentReceiverId = null;
    let currentPropertyId = null;
    let currentRoomId = null;

    // Load customer list for selected property
    propertySelect.addEventListener('change', () => {
        const propertyId = propertySelect.value;
        if (!propertyId) return;

        currentPropertyId = propertyId;

        axios.get(`/notifications/rooms/${propertyId}`).then(res => {
            roomsList.innerHTML = '';
            res.data.rooms.forEach(room => {
                const li = document.createElement('li');
                li.className = 'list-group-item list-group-item-action d-flex justify-content-between align-items-center';
                li.style.cursor = 'pointer';
                li.dataset.receiverId = room.id;
                li.innerHTML = `
                    <span>${room.title}</span>
                `;

                li.addEventListener('click', () => {
                    currentReceiverId = room.id;
                    receiverIdInput.value = currentReceiverId;

                    // Remove unread badge
                    li.querySelector('.badge')?.remove();
                    currentRoomId = room.id
                    loadNotifications(propertyId,room.id, senderId, currentReceiverId);
                });

                roomsList.appendChild(li);
            });
        });
    });

    $('#rooms-select').on('change', function () {
        const roomId = $(this).val();
        const propertyId = $('#property-select').val();
        
        $.ajax({
            url: '/rooms/notifications',
            method: 'POST',
            data: {
                property_id: propertyId,
                room_id: roomId,
                _token: $('meta[name="csrf-token"]').attr('content')
            },
            success: function (res) {
                let html = '';
                res.messages.forEach(msg => {
                    if (msg.sender_type === 'admin') {
                        html += `<div class="text-end"><span class="badge bg-warning text-dark">${msg.message}</span></div>`;
                    } else {
                        html += `<div class="text-start"><span class="badge bg-primary">${msg.message}</span></div>`;
                    }
                });
                
               

                $('#chat-box').html(html);
            }
        });
    });

     // Display a chat bubble
    // function appendMessage(msg, type) {
    //     const div = document.createElement('div');
    //     div.className = 'mb-2';
    //     div.style.textAlign = type === 'admin' ? 'right' : 'left';
    //     div.innerHTML = `<span class="badge bg-${type === 'admin' ? 'primary' : 'secondary'}">${msg}</span>`;
    //     chatBox.appendChild(div);
    //     chatBox.scrollTop = chatBox.scrollHeight;
    // }

    // // Load chat history
    // function loadNotifications(propertyId,roomId, senderId, receiverId) {
    //     var room_Id = currentRoomId;

    //     axios.get(`/api/notifications/history?property_id=${propertyId}&room_Id=${room_Id}&user1=${senderId}&user2=${receiverId}`)
    //     .then(res => {
    //         chatBox.innerHTML = '';
    //         res.data.notifications.forEach(notify => {
    //             appendMessage(notify.notification, 'admin');
    //         });
    //     });
    // }
    
     // Display a chat bubble
    function appendMessage(msg, type, timestamp) {
        const div = document.createElement('div');
        div.className = 'mb-2';
        div.style.textAlign = type === 'admin' ? 'right' : 'left';

        const time = formatTime(timestamp);

        div.innerHTML = `
            <div class="d-inline-block text-start">
                <span class="badge bg-${type === 'admin' ? 'primary' : 'secondary'}">${msg}</span><br>
                <small class="text-muted">${time}</small>
            </div>
        `;

        chatBox.appendChild(div);
        chatBox.scrollTop = chatBox.scrollHeight;
    }

    // Load chat history
    function loadNotifications(propertyId, roomId, senderId, receiverId) {
        var room_Id = currentRoomId;
        
        $('.list-group-item').css('border', 'none');
        $('[data-receiver-id="' + room_Id + '"]').css('border', '2px solid blue');

        axios.get(`/api/notifications/history?property_id=${propertyId}&room_Id=${room_Id}&user1=${senderId}&user2=${receiverId}`)
        .then(res => {
            chatBox.innerHTML = '';

            let currentDate = '';

            res.data.notifications.forEach(notify => {
                const messageDate = new Date(notify.created_at);
                const sectionTitle = formatDateHeader(notify.created_at);

                if (sectionTitle !== currentDate) {
                    currentDate = sectionTitle;
                    const dateHeader = document.createElement('div');
                    dateHeader.className = 'text-center fw-bold my-3 text-muted';
                    dateHeader.innerText = `— ${sectionTitle} —`;
                    chatBox.appendChild(dateHeader);
                }

                appendMessage(notify.notification, 'admin', notify.created_at);
            });
        });
    }

    function formatDateHeader(dateStr) {
        const date = new Date(dateStr);
        const today = new Date();

        const isToday = date.toDateString() === today.toDateString();
        if (isToday) return 'Today';

        const day = date.getDate();
        const suffix = (d => {
            if (d > 3 && d < 21) return 'th';
            switch (d % 10) {
                case 1: return 'st';
                case 2: return 'nd';
                case 3: return 'rd';
                default: return 'th';
            }
        })(day);

        const month = date.toLocaleString('default', { month: 'long' });
        const year = date.getFullYear();

        return `${day}${suffix} ${month} ${year}`;
    }

    function formatTime(dateStr) {
        const date = new Date(dateStr);
        return date.toLocaleTimeString('en-US', {
            hour: 'numeric',
            minute: '2-digit',
            hour12: true
        });
    }

     // Send message
    document.getElementById('chat-form').addEventListener('submit', function (e) {
        e.preventDefault();
        const notification = document.getElementById('notification').value;
        const propertyId = currentPropertyId;
        const receiverId = currentReceiverId;
        var room_Id = currentRoomId;
        if (!room_Id ||  !notification || !receiverId || !propertyId) return alert('Please select room and enter notification.');
        // alert(notification);
        axios.post('/api/notification/send', {
            property_id: propertyId,
            room_id: room_Id,
            sender_id: senderId,
            receiver_id: receiverId,
            sender_type: 'admin',
            notification: notification
        }).then(res => {
            appendMessage(notification, 'admin');
            document.getElementById('notification').value = '';
        });
    });
</script>
@endsection



