					  
@extends('dashboard.base')

@section('content')

    @if(Session::has('message'))
        <div class="row">
            <div class="col-12">
                <!-- <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
              </div> -->
              <div class="alert alert-success alert-dismissible fade show" role="alert">{{ Session::get('message') }}
                <button class="close" type="button" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
              </div>
            </div>
        </div>
        @endif                 
       <div class="container-fluid">
          <div class="animated fadeIn">
            <div class="row">
              <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12">
                <div class="card">
                    <div class="card-header">
                      <i class="fa fa-align-justify"></i>In-House Guests
                         

                      <!--<a id="add_button" href="{{ route('rooms.create') }}" class="btn">{{ __('Add ') }}<i class="fa fa-plus-circle"></i></a>-->
                    </div>
                    <div class="card-body">
                      <div class="row">
                        <div class="col-md-3">
                          <div class="form-group">
                            <label>Select Property</label>
                            <select class="form-control" name="property_id" id="property_filter">
                            <option value="0">Please select</option>
                              @foreach($properties as $property)
                                  <option value="{{ $property->id }}">{{ $property->name }}</option>
                              @endforeach
                            </select>
                          </div>
                        </div>
                        <div class="col-md-3">
                          <div class="form-group">
                            <label>Select Room</label>
                            <select class="form-control" name="room_id" id="room_filter">
                              <option value="0">Please select</option>
                            </select>
                          </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                        <table class="table table-bordered data-table" id="scan_datatable">
                            <thead>
                            <tr>
                                <!-- <th width="50">No</th> -->
                                <th>Name</th>
                                <th>Code</th>
                                <th>Room</th>
                                <th>Nationality</th>
                                <th>CheckIn Date-Time</th>
                                <th>Guest Folio ID</th>
                                <th width="100px">Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                    </div>

<!--                       
                      <table  style="width: 102%; margin-left: -15px;" class="table table-bordered data-table" id="scan_datatable">
                          <thead>
                              <tr>
                                  <th>Title</th>
                                  <th>Description</th>
                                  <th>Room Type</th>
                                  <th width="100px">Action</th>
                              </tr>
                          </thead>
                          <tbody>
                          </tbody>
                      </table> -->

                    </div>
                </div>
              </div>
            </div>
          </div>
        </div>


          <!-- /.modal-->
          <div class="modal fade" id="dangerModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
             <input type="hidden" name='delete_record_id' id="delete_record_id" value="">
              <div class="modal-dialog modal-danger" role="document">
                <div class="modal-content">
                  <div class="modal-header">
                    <h4 class="modal-title">Delete</h4>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                  </div>
                  <div class="modal-body">
                    <p>Are you sure, You want to delete this record ? </p>
                  </div>
                  <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button class="btn btn-danger" id="confirm" data-dismiss="modal" type="button">Confirm</button>
                  </div>
                </div>
                <!-- /.modal-content-->
              </div>
              <!-- /.modal-dialog-->
            </div>
            <!-- /.modal-->



<!-- /.Large modal-->
<div class="modal fade" id="largeNotesModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <!-- <form method="POST" id="cust_notes" action="/customers/saveNotesInfo",  enctype="multipart/form-data"> -->
                @csrf

                <input type="hidden" name="note_customer_id" id="note_customer_id" value="">
                <div class="modal-header">
                    <h4 class="modal-title">Add Note</h4>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                       
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Note</label>
                                <textarea placeholder="Enter Note" cols='5' rows='3' name="note" id="note"  class="form-control"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button class="btn btn-primary save-note" id="save_note" type="button">Save Note</button>
                 </div>
            <!-- </form> -->
        </div>
        <!-- /.modal-content-->
    </div>
    <!-- /.modal-dialog-->
</div> 
<!-- /.modal-->
@endsection


@section('javascript')


<script type="text/javascript">
  $(function () {
    $(document).on("click", ".add_note_pop_up", function() {
        var custid = $(this).attr('id');
        $('#note_customer_id').val(custid); 
        $('#largeNotesModal').modal('show'); 
    });

    $( '#save_note' ).on( "click",function(e) {
        e.preventDefault();
        var cust_id = $('#note_customer_id').val();  
        var note = $('#note').val();
        $.ajax({
            type: 'post',
            url: '/customers/saveNotesInfo',
            data:{
                '_token': $('input[name=_token]').val(),
                note_customer_id:cust_id,
                note:note,
            },
            success: function(resdata) {
                if(resdata){
                    alert('Note added successfully...!');
                    $('#notes_table').html(resdata.html); 
                    $("#largeNotesModal .close").click();
                    $('.modal-backdrop').remove();
                }
            }
        });  
    });

    //for property and date range wise filter
    $(document).on("change", "#property_filter", function() {
      var propVal = $('#property_filter').val(); 
      var room = $('#room_filter').val();  
      $.ajax({
        type: 'post',
        url: '/customers/getRoomsByProperty',
        data: {
            '_method':'POST',
            '_token': $('input[name=_token]').val(),
            'property_id': propVal,//id of customer
        },
        success: function(resdata) {
            if(resdata){
            $('#room_filter').html(resdata.html);  
            }
        }
      }); 
    
          
        $('.data-table').DataTable({
            bDestroy: true,
            processing: true,
            serverSide: true,
            ajax:   {
                url: "{{ route('customers.getInHouseGuests')}}",
                data: {
                    '_method':'POST',
                    '_token': $('input[name=_token]').val(),
                    'property_id': propVal,
                    'room_id': room,//id of customer
                    'is_inhouse': 1,//id of customer
                },
            },
            order: [],
            columns: [
                {data: 'first_name', name: 'first_name',width:'10%'},
                {data: 'guest_code', name: 'guest_code',width:'25%'},
                {data: 'room_title', name: 'room_title',width:'10%'},
                {data: 'country_name', name: 'country_name',width:'10%'},
                {data: 'checkin_date_time', name: 'checkin_date_time',width:'25%'},
                {data: 'guest_folio_id', name: 'guest_folio_id',width:'10%'},
                {data: 'action', name: 'action',width:'10%', orderable: false, searchable: false},
            ]
        });
    }); 

    $(document).on("change", "#room_filter", function() {
        var propVal = $('#property_filter').val(); 
        var room = $('#room_filter').val();  

        $('.data-table').DataTable({
            bDestroy: true,
            processing: true,
            serverSide: true,
            ajax:   {
                url: "{{ route('customers.getInHouseGuests')}}",
                data: {
                    '_method':'POST',
                    '_token': $('input[name=_token]').val(),
                    'room_id': room,//id of customer
                    'property_id': propVal,//id of customer,
                    'is_inhouse': 1,//id of customer
                },
            },
            order: [],
            columns: [
                {data: 'first_name', name: 'first_name'},
                {data: 'guest_code', name: 'guest_code'},
                {data: 'room_title', name: 'room_title'},
                {data: 'country_name', name: 'country_name'},
                {data: 'checkin_date_time', name: 'checkin_date_time'},
                {data: 'guest_folio_id', name: 'guest_folio_id'},
                {data: 'action', name: 'action', orderable: false, searchable: false},
            ]
        });
        //   $.ajax({
        //     type: 'post',
        //     url: '/customers/getInHouseGuests',
        //     data: {
        //         '_method':'POST',
        //         '_token': $('input[name=_token]').val(),
        //         'room_id': room,//id of customer
        //     },
        //     success: function(resdata) {
        //       if(resdata){
        //         $('#cust_data_tbl').html(resdata);  
        //       }
        //     }
        //   }); 
    }); 
 
  });

</script>


@endsection
