@extends('dashboard.base')

@section('content')

<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Edit Hotel Admin</h4></div>
            <div class="card-body">
            {{ Session::get('message') }}
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                        </div>
                    </div>
                 @endif   

                 @if ($errors->any())
                      <div class="alert alert-danger">
                          <ul>
                              @foreach ($errors->all() as $error)
                                  <li>{{ $error }}</li>
                              @endforeach
                          </ul>
                      </div>
                  @endif

                        <form method="POST" action="/hoteladmins/{{ $hoteladmin->id }}" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                            <div class="row">
                                 <div class="col-md-6">
                                    <div class="form-group">
                                       <label>First Name*</label>
                                        <input type="text" style="border: 2px solid blue;" placeholder="Enter Your First Name" name="first_name" class="form-control" value="{{ $hoteladmin->first_name }}">
                                     </div>
                                </div>
                                <div class="col-md-6">
                                   <div class="form-group">
                                   <label>Last Name*</label>
                                        <input type="text" style="border: 2px solid blue;" placeholder="Enter Your Last Name" name="last_name" class="form-control" value="{{ $hoteladmin->last_name }}">
                                    </div>
                                </div>
                            </div>

                             <div class="row">
                                  <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Email*</label>
                                        <input type="text" style="border: 2px solid blue;" placeholder="Enter Your Email" name="email" class="form-control" value="{{ $hoteladmin->email }}" >
                                    </div>
                                  </div>
                                  <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Password*</label>
                                        <input type="text" style="border: 2px solid blue;" placeholder="Enter Your Password" name="password" class="form-control" value="{{ $hoteladmin->org_password }}">
                                     </div>
                                  </div>
                              </div>

                              <div class="row">
                                  <div class="col-md-6">
                                     <div class="form-group">
                                        <label>Mobile*</label>
                                        <input type="number" style="border: 2px solid blue;" placeholder="Mobile" name="mobile" class="form-control" value="{{ $hoteladmin->mobile }}" >
                                     </div>
                                  </div>
                                 <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Expiry Date*</label>
                                        <input type="date" style="border: 2px solid blue;" class="form-control" name="expiry_date" value="{{ $hoteladmin->expiry_date }}"/>
                                    </div>
                                  </div>
                                </div>

                                <div class="row">
                                  <div class="col-md-6">
                                     <div class="form-group">
                                        <label>Status</label>
                                        <select class="form-control" name="status_id" id="status_id">
                                            <option value="1" {{ $hoteladmin->status_id == 1 ? 'selected' : '' }} >Active</option>
                                            <option value="2" {{ $hoteladmin->status_id == 2 ? 'selected' : '' }}>In-Active</option>
                                          </select>
                                       </div>
                                     </div>
                                     <div class="col-md-6">
                                      <div class="form-group">
                                        <label>Group Name</label>
                                          <input type="text" placeholder="Enter Group Name" value="{{ $hoteladmin->group_name }}" name="group_name" class="form-control" >
                                      </div>
                                    </div>
                                  </div>

                                  <div class="row">
                                    <div class="col-md-6">
                                      <div class="form-group">
                                        <label>Profile Image</label><br/>
                                        <a href="<?php echo asset($hoteladmin->profile_image);?>" target="_blank">View</a>
                                        <!--<img src="<?php echo asset($hoteladmin->profile_image);?>" style="width: 50px;">-->
                                        <br/><br/>
                                        <input id="file-input" type="file" name="profile_image">
                                      </div>
                                    </div>
                                  </div><br/>

                                <button type="submit" class="btn btn-primary">Save</button>
                                <a href="{{ route('hoteladmins.index') }}" class="btn btn-primary">
                                    Cancel
                                  </a>
                        </form>
                        </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')

@endsection