					  
@extends('dashboard.base')

@section('content')

        @if(Session::has('message'))
          <div class="row">
              <div class="col-12">
                  <!-- <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                  </div> -->
                  <div class="alert alert-success alert-dismissible fade show" role="alert">{{ Session::get('message') }}
                      <button class="close" type="button" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
                  </div>
              </div>
          </div>
        @endif                     
       <div class="container-fluid">
          <div class="animated fadeIn">
            <div class="row">
              <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12">
                <div class="card">
                    <div class="card-header">
                      <i class="fa fa-align-justify"></i>{{ __(' General Search Users') }}
                      <a id="add_button" href="{{ route('generalusers.create') }}" class="btn">{{ __('Add ') }}<i class="fa fa-plus-circle"></i></a>
                    </div>
                    <div class="card-body">
                        <!-- <div class="row"> 
                          <a href="{{ route('govadmins.create') }}" class="btn btn-primary m-2">{{ __('Add Govt. Admin') }}</a>
                        </div>
                        <br> -->
                        
                      <table style="width: 102%; margin-left: -15px;" class="table table-bordered data-table" id="scan_datatable">
                          <thead>
                              <tr>
                                  <!-- <th width="50">No</th> -->
                                  <th>Name</th>
                                  <th>E-mail</th>
                                  <th>Mobile</th>
                                  <th>Designation</th>
                                  <th>Status</th>
                                  <th width="100px">Action</th>
                              </tr>
                          </thead>
                          <tbody>
                          </tbody>
                      </table>

                    </div>
                </div>
              </div>
            </div>
          </div>
        </div>


          <!-- /.modal-->
          <div class="modal fade" id="dangerModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
             <input type="hidden" name='delete_record_id' id="delete_record_id" value="">
              <div class="modal-dialog modal-danger" role="document">
                <div class="modal-content">
                  <div class="modal-header">
                    <h4 class="modal-title">Delete</h4>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                  </div>
                  <div class="modal-body">
                    <p>Are you sure, You want to delete this record ? </p>
                  </div>
                  <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button class="btn btn-danger" id="confirm" data-dismiss="modal" type="button">Confirm</button>
                  </div>
                </div>
                <!-- /.modal-content-->
              </div>
              <!-- /.modal-dialog-->
            </div>
            <!-- /.modal-->


@endsection


@section('javascript')


<script type="text/javascript">
  $(function () {
    var table = $('.data-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ route('generalusers.index') }}",
        order: [],
        columns: [
            // {data: 'id', name: 'id'},
            {data: 'first_name', name: 'first_name'},
            {data: 'email', name: 'email'},
            {data: 'mobile', name: 'mobile'},
            {data: 'designation', name: 'designation'},
            {data: 'status_id', name: 'status_id'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });


    $(document).on( "click", ".delete", function() {
        $('#delete_record_id').val($(this).data('record-id'));
            $('#dangerModal').on( "click", "#confirm", function() {
               
                $.ajax({
                    type: 'post',
                    url: '/generalusers/delete',
                    data: {
                        '_method':'DELETE',
                        '_token': $('input[name=_token]').val(),
                        'id': $('#delete_record_id').val(),
                    },
                    success: function(resdata) {
                      if(resdata){
                        table.ajax.reload();
                      }
                      
                    }
                });

            });
        });

  });

  function myFunction(id){
      $.ajax({
            type: 'post',
            url: '/generalusers/delete',
            data: {
                '_method':'DELETE',
                '_token': $('input[name=_token]').val(),
                'id': id,
            },
            success: function() {

            }
        });
    }
</script>


@endsection
