
@extends('dashboard.base')

@section('css')

@endsection

@section('content')


<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
        <div class="card-header"><h4>Add Complaint</h4></div>
            <div class="card-body">
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                        </div>
                    </div>
                 @endif     

                 @if ($errors->any())
                      <div class="alert alert-danger">
                          <ul>
                              @foreach ($errors->all() as $error)
                                  <li>{{ $error }}</li>
                              @endforeach
                          </ul>
                      </div>
                  @endif

                  <form method="POST" action="{{ route('generaluserscomp.store') }}"  enctype="multipart/form-data">
                    @csrf 
                    <!-- <input name="complaint_against" value="0" type="hidden"> -->
                    <div class="row">
                      <div class="col-md-6">
                        <div class="form-group">
                          <label>Complaint Type*</label>
                          <select class="form-control " style="border: 2px solid blue;" name="complaint_type" id="complaint_type">
                            <option value="0">Please select Type</option>
                            @foreach($complaint_types as $type)
                                <option value="{{ $type->id }}">{{ $type->title }}</option>
                            @endforeach
                          </select>
                          <small style="color:red;display:none;" id="complaint_type_error">Complaint Type is required.</small>
                        </div>
                      </div>
                      <div class="col-md-6">
                        <div class="form-group">
                          <label>Complaint Against*</label>
                          <select class="form-control " style="border: 2px solid blue;" name="complaint_against" id="complaint_against">
                            <option value="0">Please select Type</option>
                            @foreach($customers as $customer)
                                <option value="{{ $customer->id }}">{{ $customer->first_name }} {{ $customer->last_name }}</option>
                            @endforeach
                          </select>
                          <small style="color:red;display:none;" id="complaint_against_error">Complaint Against is required.</small>
                        </div>
                      </div>

                     
                    </div>

                    <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                          <label>Title*</label>
                          <input type="text" style="border: 2px solid blue;" placeholder="Enter Title" name="title" class="form-control" >
                        </div>
                      </div>
                      <div class="col-md-6">
                        <div class="form-group">
                          <label>Description*</label>
                          <textarea class="form-control" style="border: 2px solid blue;" id="textarea-input" name="description" rows="4" placeholder="Description.."></textarea>
                          <!-- <input type="text" placeholder="Enter Description" name="description" class="form-control" > -->
                        </div>
                      </div>
                   
                    </div>

                    <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                          <label>Ratings</label>
                          <select class="form-control " name="complaint_rating" id="complaint_rating">
                            <option value="0">Please select Rating</option>
                              <option value="5">5 (Very Serious)</option>
                              <option value="4">4 (Serious)</option>
                              <option value="3">3 (Major)</option>
                              <option value="2">2 (Minor)</option>
                              <option value="1">1 (Very Minor)</option>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-6">
                        <div class="form-group">
                          <label>Document</label><br/>
                          <input type="file" name="document" id="document" ><br/>
                          <small><?php echo "Max File Size : 1MB"?></small>
                        </div>
                      </div>
                    </div>

                    <div class="row">
                      <?php if(Auth::user()->id == 1){ //super admin ?>
                        <div class="col-md-6">
                          <div class="form-group">
                            <label>Status</label>
                            <select class="form-control " name="status" id="status">
                                <option value="1">Public</option>
                                <option value="2">Private</option>
                            </select>
                          </div>
                        </div>
                      <?php }?>
                    </div>


                    <button type="submit" class="btn btn-primary">Submit</button>
                    <a href="{{ route('complaints.index') }}" class="btn btn-primary">
                      Cancel
                    </a>
                  </form>

            </div><br/><br/><br/><br/>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')

<script type="text/javascript">
    $(document).ready(function(){
        if(!$('#complaint_type').val()){
            $('#complaint_type_error').show();
            return false;
        } else {
            $('#complaint_type_error').hide();
        }     
        
        if(!$('#complaint_against').val()){
            $('#complaint_against_error').show();
            return false;
        } else {
            $('#complaint_against_error').hide();
        }  
        
    });


</script>

@endsection