					  
@extends('dashboard.base')


@section('content')


<style>
.text-right{
    text-align:right;
}
</style>
    @if(Session::has('message'))
        <div class="row">
            <div class="col-12">
                <!-- <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
              </div> -->
              <div class="alert alert-success alert-dismissible fade show" role="alert">{{ Session::get('message') }}
                <button class="close" type="button" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
              </div>
            </div>
        </div>
        @endif                 
       <div class="container-fluid">
          <div class="animated fadeIn">
            <div class="row">
              <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12">
                <div class="card">
                    <div class="card-header">
                        Commercial Invoice List
                   </div>
                    <div class="card-body">
                    <form method="POST" action="{{ route('commercialtaxinvoicelist.downloadCommercialInvoiceReport') }}"  enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Select Property</label>
                                    <select class="form-control" name="property_id" id="property_id">
                                        <option value="0">Please select</option>
                                        @foreach($properties as $property)
                                            <option value="{{ $property->id }}">{{ $property->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Select Month</label>
                                    <select class="form-control" name="month" id="month">
                                        <option value="01">January 2024</option>
                                        <option value="02">February 2024</option>
                                        <option value="03">March 2024</option>
                                        <option value="04">April 2024</option>
                                        <option value="05" selected>May 2024</option>
                                        <option value="06">June 2024</option>
                                        <option value="07">July 2024</option>
                                        <option value="08">August 2024</option>
                                        <option value="09">September 2024</option>
                                        <option value="10">October 2024</option>
                                        <option value="11">November 2024</option>
                                        <option value="12">December 2024</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Select Currency</label>
                                    <select class="form-control" name="currency" id="currency">
                                        <option value="usd" selected>USD</option>
                                        <option value="kh">Khmer Riel</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary" name="download_report" id="download_report" style="margin-top:30px;">Download Report</button>
                                </div>
                            </div>

                        </div>
          </form>
                      <center><span id="list_info_text"></span></center><br/>
                      <table  style="width: 102%; margin-left: -15px;" class="table table-bordered data-table" id="scan_datatable">
                            <thead>
                                <tr>
                                    <th>Property</th>
                                    <th>Invoice No</th>
                                    <th>Guest Name</th>
                                    <th style="width:5%;">Total</th>
                                    <th width="100px">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                            
                            <tfoot> 
                              <tr>
                                <th><b>Totals</b></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th width="100px">Action</th>
                              </tr>
                            </tfoot>
                        </table>

                    </div>
                </div>
              </div>
            </div>
          </div>
        </div>


          <!-- /.modal-->
          <div class="modal fade" id="dangerModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
             <input type="hidden" name='delete_record_id' id="delete_record_id" value="">
              <div class="modal-dialog modal-danger" role="document">
                <div class="modal-content">
                  <div class="modal-header">
                    <h4 class="modal-title">Delete</h4>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                  </div>
                  <div class="modal-body">
                    <p>Are you sure, You want to delete this record ? </p>
                  </div>
                  <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button class="btn btn-danger" id="confirm" data-dismiss="modal" type="button">Confirm</button>
                  </div>
                </div>
                <!-- /.modal-content-->
              </div>
              <!-- /.modal-dialog-->
            </div>
            <!-- /.modal-->


@endsection


@section('javascript')


<script type="text/javascript">
  $(function () {

    $(document).on('change','#property_id', (function (e) {
      getInvoiceListing();
    }));

    $(document).on('change','#month', (function (e) {
      getInvoiceListing();
    }));

    $(document).on('change','#currency', (function (e) {
      getInvoiceListing();
    }));
    
    
    function getInvoiceListing(){
      var property = $('#property_id').val();
      var month = $('#month').val();
      var curr = $('#currency').val();



      var resp = 'Invoice list for Property: <b>'+$("#property_id option:selected"). text()+'</b> for  <b>'+$("#month option:selected"). text()+'</b> in <b>'+$("#currency option:selected").text()+'</b>';
      $('#list_info_text').html(resp);
      $('#scan_datatable').DataTable({
            bDestroy: true,
            processing: true,
            serverSide: true,
            ajax:   {
                    url: "{{ route('commercialtaxinvoicelist.getCommercialInvoiceListByProperty')}}",
                    data: {
                        'is_get_cust':1,
                        property_id: property,
                        month: month,
                        curr:curr,
                    },
                },
            // ajax: "{{ route('customers.index' ,['stay_val'=>"+stay_val+"]) }}",
            order: [],
            columns: [
                {data: 'property_name', name: 'property_name'},
                {data: 'invoice_no', name: 'invoice_no'},
                {data: 'guest_name', name: 'guest_name'},
                {data: 'total_amt', name: 'total_amt', className: "text-right"},
                {data: 'action', name: 'action', orderable: false, searchable: false},
            ],
            "footerCallback": function (row, data, start, end, display) {                
              //Get data here 
              //Do whatever you want. Example:
              var totalAmount = 0;
              for (var i = 0; i < data.length; i++) {
                totalAmount += parseFloat(data[i]['total_amt']);
              }
              var nCells = row.getElementsByTagName('th');
              nCells[3].style.float = "right";
             
              if($('#currency').val() == 'usd'){
                   nCells[3].innerHTML = totalAmount.toFixed(2);
                } else {
                    nCells[3].innerHTML = totalAmount;
                }
            }
        });
    }


    


    
})

</script>


@endsection
