@extends('dashboard.base')
@section('css')

@endsection
@section('content')

<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Issue Commercial Receipt For : <?php echo $customer->first_name.' '.$customer->last_name.' ('.$customer->guest_code.')';?></h4></div>
            <div class="card-body">
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                        </div>
                    </div>
                @endif      

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif           
           
                <form method="POST" action="{{ route('commercialreceiptsettings.commercial_invoice_receipt') }}"  enctype="multipart/form-data">
                    @csrf
                    <input name="marker" value="selectModel" type="hidden">
                    <input name="customer_id" value="<?php echo $customer->id;?>" type="hidden">
                
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                              <label>Date</label>
                              </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                              <input type="text" readonly placeholder="Enter Date" name="date" value="<?php echo date('Y-m-d');;?>" class="form-control" >
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                              <label>Remark</label>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                              <textarea placeholder="Enter remark" name="remark"  class="form-control" > </textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                              <label>Amount ($)</label>
                              </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                              <input readonly placeholder="Enter amount" name="amount" style="text-align:right;" value="<?php echo number_format($taxInvoiceDetails->total_amt_usd,2); ?>"  class="form-control" >
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                              <label>Payment Method</label>
                              </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <select class="form-control" name="payment_method_id" id="payment_method_id">
                                    <!-- <option value="0">Please select</option> -->
                                    @foreach($paymentmethods as $method)
                                        <option value="{{ $method->id }}">{{ $method->title }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                              <label>Close</label>
                              </div>
                        </div>
                    <div class="col-md-3">
                            <div class="form-group">
                                <select class="form-control" name="is_close" id="is_close">
                                      <option value="1">Yes</option>
                                      <option value="2">No</option>
                                </select>
                            </div>
                        </div>
                        </div>

                    <button type="submit" class="btn btn-primary">Submit</button>

                    <a href="{{ route('taxsettings.index') }}" class="btn btn-primary">
                        Cancel
                    </a>
                  </form>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')
@endsection
