<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReservationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        
        Schema::create('reservations', function (Blueprint $table) {
            $table->id();
            $table->string('reservation_no')->nullable();
            $table->string('source_booking_no')->nullable();
            $table->string('source')->nullable();
            $table->string('property_id')->nullable();
            $table->string('room_id')->nullable();
            $table->string('from_date')->nullable();
            $table->string('from_time')->nullable();
            $table->string('to_date')->nullable();
            $table->string('to_time')->nullable();
            $table->string('remarks')->nullable();
            $table->string('reserved_by')->nullable();
            $table->string('reservation_details')->nullable();
            $table->string('reservation_notes')->nullable();
            $table->string('status')->nullable();
            $table->integer('created_by')->unsigned();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('reservations');
    }
}
