<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblCustomerInvoiceReceiptsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('tbl_customer_invoice_receipts', function (Blueprint $table) {
            $table->id();
            $table->string('receipt_setting_id')->nullable();
            $table->string('receipt_no')->nullable();
            $table->string('property_id')->nullable();
            $table->string('customer_id')->nullable();
            $table->string('receipt_date')->nullable();
            $table->string('remark')->nullable();
            $table->string('payment_method_id')->nullable();
            $table->string('amount')->nullable();
            $table->string('is_close')->nullable();
            $table->integer('created_by')->unsigned();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_customer_invoice_receipts');
    }
}
