<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBlacklistsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('blacklists', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->string('passport_no')->nullable();
            $table->string('date_og_birth')->nullable();
            $table->string('nationality')->nullable();
            $table->string('property_id')->nullable();
            $table->string('reason')->nullable();
            $table->string('block_status')->nullable();
            $table->string('complaint_type')->nullable();
            $table->string('severity')->nullable();
            $table->string('share_to_other_hotel_status')->nullable();
            $table->string('action_taken')->nullable();
            $table->integer('created_by')->unsigned();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('blacklists');
    }
}
