<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGroupsPrivilegesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('groups_privileges', function (Blueprint $table) {
            $table->id();
            $table->integer('group_id');
            $table->integer('module_id');
            $table->string('all')->nullable();
            $table->string('view')->nullable();
            $table->string('add')->nullable();
            $table->string('edit')->nullable();
            $table->string('delete')->nullable();
            $table->integer('created_by')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('groups_privileges');
    }
}
