<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCustomerDocumentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        
        Schema::create('customer_documents', function (Blueprint $table) {
            $table->id();
            $table->integer('customer_id')->unsigned();
            // $table->enum('document_type', ['1','2','3','4','5'])->comment('1:Driving License,2:Voters Card,3:UID,4:PassPort,5:VISA');
            $table->string('document_type')->nullable();
            $table->string('number')->nullable();
            $table->string('uploaded_document');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_documents');
    }
}
