<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCustomersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customers', function (Blueprint $table) {
            $table->id();
            $table->string('first_name');
            $table->string('middle_name')->nullable();
            $table->string('last_name');
            $table->string('email');
            $table->string('mobile','100')->nullable();
            $table->string('nationality')->nullable();
            $table->string('date_of_birth');
            $table->integer('gender')->unsigned();
            $table->string('passport_number','255')->nullable();
            $table->string('passport_expiry_date')->nullable();
            $table->string('country_of_issue')->nullable();
            $table->string('checkin_date_time')->nullable();
            $table->string('checkout_date_time')->nullable();
            $table->string('profile_image')->nullable();
            $table->string('address_line_1','255')->nullable();
            $table->string('address_line_2','255')->nullable();
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('pin')->nullable();
            $table->string('country')->nullable();
            $table->string('country')->nullable();
            $table->integer('room_id')->unsigned();
            $table->integer('property_id')->unsigned();
            $table->string('id_proof_document')->nullable();
            $table->integer('created_by')->unsigned();
            $table->string('visa_number')->nullable();
            $table->string('visa_issue_date')->nullable();
            $table->string('visa_expiry_date')->nullable();
            $table->string('other_id_type')->nullable();
            $table->string('other_id_number')->nullable();
            $table->string('other_id_expiry_date')->nullable();
            $table->string('confirm_checkin')->nullable();
            $table->string('emergency_contact_no')->nullable();
            $table->string('emergency_contact_name')->nullable();
            $table->string('emergency_contact_description')->nullable();
            $table->string('booking_type')->nullable();
            $table->string('booking_no')->nullable();
            $table->string('booking_description')->nullable();
            $table->softDeletes();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customers');
    }
}
