<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePropertiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('properties', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email');
            $table->string('org_name');
            $table->string('mobile','100')->nullable();
            $table->string('address')->nullable();
            $table->string('country')->nullable();
            $table->string('provenance')->nullable();
            $table->string('city')->nullable();
            $table->string('pin')->nullable();
            $table->string('phone_1','20')->nullable();
            $table->string('phone_2','20')->nullable();
            $table->string('owner')->nullable();
            $table->integer('created_by')->unsigned();
            $table->integer('status_id')->unsigned();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('properties');
    }
}
