<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Models\IdProofTypes;
use App\Models\Room;
use App\Models\User;
use App\Models\Customers;
use App\Models\Properties;
use App\Models\Visitors;
use App\Models\CustomerDocuments;
use App\Models\Country;
use App\Models\MyProfile;
use App\Models\HotelAdmin;
use App\Models\VisitorImages;
use App\Models\Staffs as HotelAdminStaffs;
use Illuminate\Routing\UrlGenerator as URL;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;

use File;
use Carbon\CarbonPeriod;

class Api extends Model
{
    use HasFactory;
    /*
      get hotel admin user for login
    */
    public static function getUserForLogin($username, $password){
        //get base url 
        $base_url = URL('/');
        
        //check if hotel admin exists with above username/email
        $getHotelAdminUser = DB::table('users as us')
                            ->select('us.id as user_id','ha.*')
                            ->join('tbl_hotel_admins as ha','ha.main_user_id','=','us.id','left')
                            ->where('us.email',$username)
                            ->first();

        //check if hotel admin staff exists with above username/email
        $getHotelAdminUserStaff = DB::table('users as us')
                            ->select('us.id as user_id','st.*')
                            ->join('staffs as st','st.main_user_id','=','us.id','left')
                            ->where('us.email',$username)
                            ->first();
                            
        if($getHotelAdminUser->id){ //hotel admin exists with above email/username
            //now check password matches with saved password using hash check
            if(Hash::check($password, $getHotelAdminUser->password)){
                //password matches and return the other data to controller
                $getHotelAdminUser->is_staff = 0;
                
            $getHotelAdminUser->profile_image = $base_url.'/storage/uploads/hotel_admins/'.$getHotelAdminUser->id.'/profile_picture/'.$getHotelAdminUser->profile_image;

                return $getHotelAdminUser;
            } else {
                //password does not matches so thrwo error
                return false;
            }
        } else if(!empty($getHotelAdminUserStaff)){ 
            if(Hash::check($password, $getHotelAdminUserStaff->password)){
                //password matches and return the other data to controller

                //add staff flag for getting privileges in further apis
                $getHotelAdminUserStaff->is_staff ='';
                $getHotelAdminUserStaff->is_staff = 1;
                
            $getHotelAdminUserStaff->profile_image = $base_url.'/public/storage/uploads/hotel_admins/'.$getHotelAdminUserStaff->created_by.'/hotel_admin_staffs'.'/'.$getHotelAdminUserStaff->id.'/profile_picture'.'/'.$getHotelAdminUserStaff->profile_image;

                $allAssignedPropertiesData = DB::table('staff_assigned_properties as sp')
                ->select('pr.id','pr.name')
                ->join('properties as pr','pr.id', '=' ,'sp.property_id','left')
                ->where('sp.staff_id',$getHotelAdminUserStaff->id)
                ->get();
                $getHotelAdminUserStaff->assigned_properites = array();
                foreach($allAssignedPropertiesData as $prop){
                    $getHotelAdminUserStaff->assigned_properites[] = $prop;
                }
                return $getHotelAdminUserStaff;
            } else {
                //password does not matches so thrwo error
                return false;
            }
        } else {
            return false;
        }
    }

    //for customers list
    public static function getCustomersList($data){
        $uparr = array('checkout_date_time' => NULL);
        $x = DB::table('customers')->where('checkout_date_time','')->update($uparr);

        DB::enableQueryLog();
         //get all customers who have only checked in currently
         $query = DB::table('customers')
                        ->select('id as customer_id','first_name','last_name','property_id','created_by','profile_image','full_name','email','mobile','room_id','gender','checkin_date_time','checkout_date_time')
                        ->where('created_by',$data['user_id']);
                        $query->where('property_id','=',$data['property_id']);
              
                        if(array_key_exists('currently_staying',$data)){
                            // $query->where('checkout_date_time','=','')
                            // ->where('checkin_date_time','!=','')
                            // ->orWhere('checkout_date_time',null)
                            // ->orderBy('checkin_date_time','desc');
                            $query->whereNull('customers.checkout_date_time');
                            
                        } else if(array_key_exists('staying_in',$data)){
                            
                            $post_start_date = date('d-m-Y', strtotime($data['from_date']));
                            $post_start_date =  \Carbon\Carbon::parse($post_start_date);
                            
                            $post_end_date = date('d-m-Y', strtotime($data['to_date']));
                            $post_end_date =  \Carbon\Carbon::parse($post_end_date);
                
                            $query->orderBy('checkin_date_time','desc')
                            ->where('checkin_date_time','!=','')
                            // ->where('checkin_date_time','!=','')
                             ->whereBetween('checkin_date_time', [$post_start_date, $post_end_date]);
                        } else {
                            $query->where('checkout_date_time','=','')
                            ->where('checkin_date_time','!=','')
                            ->orWhere('checkout_date_time',null)
                            ->orderBy('id','desc');
                        }
                        // $query->where('room_id','!=',null);
        $getAllCustomers = $query->offset($data['last_id'])->where('deleted_at',null)->limit($data['limit'])->orderBy('id','desc')->get();
        // dd(DB::getQueryLog());;exit;
            //get base url 
            $base_url = URL('/');
            // echo "<pre>";print_r($getAllCustomers);exit;
        if(!empty($getAllCustomers)){
            // echo "<pre>";print_r($getAllCustomers);exit;
            foreach($getAllCustomers as $key => $customers){
                if(array_key_exists('currently_staying',$data)){
                    if($customers->checkout_date_time){
                        unset($getAllCustomers[$key]);
                    }
                }
                 if($customers->property_id && $customers->property_id  == $data['property_id']){
                $start_date = date('d-m-Y', strtotime($customers->checkin_date_time));
                $start_date =  \Carbon\Carbon::parse($start_date);
                
                $end_date = date('d-m-Y', strtotime($customers->checkout_date_time));
                $end_date =  \Carbon\Carbon::parse($end_date);
                
                //get room title
                $get_room_details = DB::table('rooms')->select('title')->where('id',$customers->room_id)->first();   
                if(!empty($get_room_details)){
                    $customers->room_id = $get_room_details->title;
                } else {
                    $customers->room_id = '';
                }
                 
                //customer profile image path
                 $customers->profile_image = $base_url.'/public/storage/uploads/hotel_admins/'.$customers->created_by.'/customer_documents'.'/'.$customers->customer_id.'/display_picture'.'/'.$customers->profile_image;
                
                //get property detial
                $property = Properties::find($customers->property_id);
                $customers->property_name ='';
                if(!empty($property)){
                    $customers->property_name = $property->name;
                }
                
                $customers->property_id = $customers->property_id;
        
                $customers->full_name = $customers->first_name.' '.$customers->last_name;
        
                $customers->gender = ($customers->gender == 1) ? 'Male':'Female';
                $customers->checkout_date_time = ($customers->checkout_date_time == "") ? '':'';

  
            }
        }
            return $getAllCustomers;
        } else {
            return false;
        }
    }

    //for customer details
    public static function getCustomersDetails($id){
  
        //check if hotel admin exists with above username/email
        $getCustomer = Customers::find($id);
       
        if(!empty($getCustomer)){
            if($getCustomer->country == ''){
                $getCustomer->country = '';
            }
            if($getCustomer->middle_name == ''){
                $getCustomer->middle_name = '';
            }
            if($getCustomer->nationality == ''){
                $getCustomer->nationality = '';
            }
            if($getCustomer->passport_expiry_date == ''){
                $getCustomer->passport_expiry_date = '';
            }
            if($getCustomer->passport_number == ''){
                $getCustomer->passport_number = '';
            }

            $getCustomer->full_name = $getCustomer->first_name.' '.$getCustomer->last_name;
 
            //get base url 
            $base_url = URL('/');
            //customer profile image path
            $getCustomer->profile_image = $base_url.'/public/storage/uploads/hotel_admins/'.$getCustomer->created_by.'/customer_documents'.'/'.$getCustomer->id.'/display_picture'.'/'.$getCustomer->profile_image;

            //get room title
            $get_room_details = DB::table('rooms')->select('title')->where('id',$getCustomer->room_id)->first();
            $getCustomer->room_id = $get_room_details->title;

            //get property detial
            $property_detail = Properties::find($getCustomer->property_id);
            $getCustomer->property_id = $property_detail->name;
        
            //get customers uploaded documents
            $getCustomer->documents = array();
            $docs = DB::table('customer_documents')->select('id as document_id','document_type','number','uploaded_document')
                    ->where('customer_id',$getCustomer->id)
                    ->where('deleted_at',null)
                    ->get();
            if($docs){
                $docs_array = $docs;
                foreach($docs_array as $doc){
                    // echo "<pre>";print_r($doc->document_type);exit;
                    $getDoctypeTitle  = IdProofTypes::find($doc->document_type);
                    
                    $path = $base_url.'/public/storage/uploads/hotel_admins/'.$getCustomer->created_by.'/'.'customer_documents/'.$getCustomer->id.'/'.$doc->uploaded_document;
                    $doc->uploaded_document= $path;
                    $doc->document_type = $getDoctypeTitle->title;
                }
            } else {
                $docs_array = array();
            }
            $getCustomer->documents  = $docs_array;

            $getCustomer->notes = array();
            //get all customer notes
            $customer_notes = DB::table('customer_notes')
                            ->select('id','date_time','note')
                            ->where('customer_id',$getCustomer->id)
                            ->orderBy('id','DESC')
                            ->get();
            $all_notes = array();
            if(!empty($customer_notes)){
                foreach($customer_notes as $note){
                    $all_notes[] = $note;
                }
            }
            $getCustomer->notes = $all_notes; 
        
        
            //remove unwanted columns from array
            unset($getCustomer->id_proof_document);
            unset($getCustomer->deleted_at);
            unset($getCustomer->created_at);
            unset($getCustomer->updated_at);

            return $getCustomer;
        } else {
            return false;
        }
    }

    //for all rooms
    public static function getRooms($data){
         //check if hotel admin exists with above username/email
        //  $getRooms = Room::where('created_by',$data->user_id)->get();  
            $getRooms = Room::where('property_id',$data->property_id)->where('deleted_at',null)->where('status',1)->get();  
        if(!empty($getRooms)){ 
            $room_array = array();
            foreach($getRooms as $room){
                //remove unwanted columns from array
                unset($room->deleted_at); 
                unset($room->created_at);
                unset($room->updated_at);

                $room_array[] = $room;
            }
            return $room_array;
        } else {
            return false;
        }
    }
    
    //for all document types
    public static function getAllDocTypes($data){
        //get all document types
        $getDocTypes  = IdProofTypes::all(); 
        if(!empty($getDocTypes)){ 
            $doctypes_array = array();
            foreach($getDocTypes as $types){
                //remove unwanted columns from array
               unset($types->deleted_at); 
               unset($types->created_at);
               unset($types->updated_at);
               $doctypes_array[] = $types;
           }
           return $doctypes_array;
        } else {
           return false;
        }
   }

   public static function getAllProperties($data){
        //get all document types
        
        if($data->is_staff){
            $allinfo = Staffs::where('main_user_id',$data->user_id)->first();
            $prop_user_id = $allinfo->id;
            $assigned_props = DB::table('staff_assigned_properties')->where('staff_id',$prop_user_id)->first();
            // echo "<pre>";print_R($assigned_props);exit;
            $getAllProperties  = Properties::where('id',$assigned_props->property_id)->where('status_id','1')->get(); 
         
        } else {
            $allinfo = HotelAdmin::where('main_user_id',$data->user_id)->first();
            $prop_user_id = $allinfo->main_user_id;
            $getAllProperties  = Properties::where('created_by',$prop_user_id)->where('status_id','1')->get(); 
        }
        //  echo "<pre>";print_r($allinfo->main_user_id);exit;
        // $getAllProperties  = Properties::where('created_by',$data->user_id)->get(); 
         
        if(!empty($getAllProperties)){ 
            $allProperties = array();
            foreach($getAllProperties as $property){
                //remove unwanted columns from array
                unset($property->deleted_at); 
                unset($property->created_at);
                unset($property->updated_at);
                $allProperties[] = $property;
            }
        return $allProperties;
        } else {
        return false;
        }
    }
   
    public static function getProperty($id){
        //get all document types
        $getAllProperties  = Properties::where('id',$id)->get();
        if(!empty($getAllProperties)){ 
            $allProperties = array();
            foreach($getAllProperties as $property){
                //remove unwanted columns from array
                unset($property->deleted_at); 
                unset($property->created_at);
                unset($property->updated_at);
                $allProperties[] = $property;
            }
            // echo "<pre>";print_R($allProperties);exit;
        return $allProperties;
        } else {
        return false;
        }
    }

    //add new customer 
    public static function addCustomer($request){
        //for basic info tab details
        $hotel_admin_id = $request->input('user_id');
        $customer = new Customers();
        // $customer->full_name    = $request->input('full_name');
        $customer->guest_code    = $request->input('guest_code');
        $customer->first_name    = $request->input('first_name');
        $customer->middle_name    = '';
        $customer->last_name    = $request->input('last_name');
        // $customer->email   =  $request->input('email');
        // $customer->mobile   =  $request->input('mobile');
        $customer->nationality   =  $request->input('nationality');
        $customer->date_of_birth   =  $request->input('date_of_birth');
        // $customer->gender   =  $request->input('gender');
        $customer->passport_number   =  $request->input('passport_number');
        $customer->passport_expiry_date   =  $request->input('passport_expiry_date');
        // $customer->country_of_issue   =  $request->input('country_of_issue');
        // $customer->room_id   =  $request->input('room_id');
        // $customer->property_id   =  $request->input('property_id');
        
        // $customer->checkin_date_time   =  $request->input('checkin_date').' '.$request->input('checkin_time');
        // $customer->checkout_date_time   =  NULL;
        $customer->confirm_checkin   =  0;

        // //for address tab details
        // // $customer->address_line_1    = $request->input('address_line_1');
        // // $customer->address_line_2    = $request->input('address_line_2');
        //  $customer->address    = $request->input('address_line_1');
        // $customer->city    = $request->input('city');
        // $customer->state   =  $request->input('state');
        // $customer->pin   =  $request->input('pin');
        // $customer->country   =  $request->input('country');

        $customer->emergency_contact_no   =  $request->input('emergency_contact_no');
        $customer->emergency_contact_name   =  $request->input('emergency_contact_name');
        $customer->emergency_contact_description   =  $request->input('emergency_contact_description');
        
        $customer->booking_type   =  $request->input('booking_type');
        $customer->booking_no   =  $request->input('booking_no');
        $customer->booking_description   =  $request->input('booking_description');
        $customer->guest_folio_id   =  $request->input('guest_folio_id');
        $customer->no_of_nights   =  $request->input('no_of_nights');
        $customer->tentative_checkout_date   =  $request->input('tentative_checkout_date');
        $customer->room_rate_info   =  $request->input('room_rate_info');
        $customer->no_of_guests   =  $request->input('no_of_guests');
        
        $customer->created_by = $request->input('user_id');
        // $response_arr = $customer;
        //  return $response_arr;
        $customer->save();
        $recent_cust_id = $customer->id;
        //get recently adde cust
        // $recent = Customers::where('email',$request->input('email'))->first();
        // $recent_cust_id = $recent->id;
            //for custoomer uploaded document
            //Create hotel admin folder if not exists
            $hotel_admin_path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id);
            if(!File::isDirectory($hotel_admin_path)){
                File::makeDirectory($hotel_admin_path, 0777, true, true);
                File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents', 0777, true, true);//create  customer_documents folder
            }
            
            // create or update file in directory if exists in hotel admin folder
            $path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$recent_cust_id);
            if(!File::isDirectory($path)){
                File::makeDirectory($path, 0777, true, true);
                File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$recent_cust_id.'/display_picture', 0777, true, true);
            }
     
        //for customer dp
        if ($request->hasFile('profile_pic')) {

            $filenameWithExt = $request->file('profile_pic')->getClientOriginalName ();
            // Get Filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $extension = $request->file('profile_pic')->getClientOriginalExtension();
            // Filename To store
            $fileNameToStore = $filename. '_'. time().'.'.$extension;
            // Upload Image$path = 
            $img = $request->file('profile_pic')->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents'.'/'.$recent_cust_id.'/display_picture', $fileNameToStore);
            $dp_array = array('profile_image'=>$fileNameToStore,);
            DB::table('customers')->where('id', $recent_cust_id)->update($dp_array);
        }
 
        if($recent_cust_id){
            $response_arr = array('customer_id'=>$recent_cust_id,);
        } else {
            $response_arr = array();
        }
        return $response_arr;
    }

    //update customer
    public static function updateCustomer($request,$id){
    
        //for basic info tab details
        $hotel_admin_id = $request->input('user_id');
        $customer = Customers::findOrFail($id);
        $customer->email   =  $request->input('email');
        $customer->mobile   =  $request->input('mobile');
        $customer->nationality   =  $request->input('nationality');
        $customer->date_of_birth   =  $request->input('date_of_birth');
        $customer->gender   =  $request->input('gender');
        $customer->passport_number   =  $request->input('passport_number');
        $customer->passport_expiry_date   =  $request->input('passport_expiry_date');
        $customer->country_of_issue   =  $request->input('country_of_issue');
        $customer->room_id   =  $request->input('room_id');
        $customer->property_id   =  $request->input('property_id');
        $customer->checkin_date_time   =  $request->input('checkin_date_time').' '.$request->input('checkin_time');
        $customer->checkout_date_time   =  $request->input('checkout_date_time').' '.$request->input('checkout_time');

        //for address tab details
        $customer->address   = $request->input('address');
        // $customer->address_line_1    = $request->input('address_line_1');
        // $customer->address_line_2    = $request->input('address_line_2');
        $customer->city    = $request->input('city');
        $customer->state   =  $request->input('state');
        $customer->pin   =  $request->input('pin');
        $customer->country   =  $request->input('country');

        //chnages 12-09-2023
        $customer->visa_number   =  $request->input('visa_number');
        $customer->visa_issue_date   =  $request->input('visa_issue_date');
        $customer->visa_expiry_date   =  $request->input('visa_expiry_date');
        $customer->other_id_type   =  $request->input('other_id_type');
        $customer->other_id_number   =  $request->input('other_id_number');
        $customer->other_id_expiry_date   =  $request->input('other_id_expiry_date');

        $customer->emergency_contact_no   =  $request->input('emergency_contact_no');
        $customer->emergency_contact_name   =  $request->input('emergency_contact_name');
        $customer->emergency_contact_description   =  $request->input('emergency_contact_description');
        
        $customer->booking_type   =  $request->input('booking_type');
        $customer->booking_no   =  $request->input('booking_no');
        $customer->booking_description   =  $request->input('booking_description');
        $customer->guest_folio_id   =  $request->input('guest_folio_id');
        
        $customer->no_of_nights   =  $request->input('no_of_nights');
        $customer->tentative_checkout_date   =  $request->input('tentative_checkout_date');
        $customer->room_rate_info   =  $request->input('room_rate_info');
        $customer->no_of_guests   =  $request->input('no_of_guests');
        
        // $customer->created_by = $request->input('user_id');
        $customer->save();
        

        $recent_cust_id = $id;
            //for custoomer uploaded document
            //Create hotel admin folder if not exists
            $hotel_admin_path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id);
            if(!File::isDirectory($hotel_admin_path)){
                File::makeDirectory($hotel_admin_path, 0777, true, true);
                File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents', 0777, true, true);//create  customer_documents folder
            }
            
            // create or update file in directory if exists in hotel admin folder
            $path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$recent_cust_id);
            if(!File::isDirectory($path)){
                File::makeDirectory($path, 0777, true, true);
                File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$recent_cust_id.'/display_picture', 0777, true, true);
            }

        //for customer dp
        if ($request->hasFile('profile_pic')) {

            $filenameWithExt = $request->file('profile_pic')->getClientOriginalName ();
            // Get Filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $extension = $request->file('profile_pic')->getClientOriginalExtension();
            // Filename To store
            $fileNameToStore = $filename. '_'. time().'.'.$extension;
            // Upload Image$path = 
            $img = $request->file('profile_pic')->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents'.'/'.$recent_cust_id.'/display_picture', $fileNameToStore);
            $dp_array = array('profile_image'=>$fileNameToStore,);
            DB::table('customers')->where('id', $recent_cust_id)->update($dp_array);
        }
        
        if(!empty($customer)){
            return array('customer_id'=>$id);
            // return true;
        } else {
            return false;
        }
    }

    //adding customer docs
    public static function addDocument($request){

        $customer_id = $request->input('customer_id');
        $hotel_admin_id =$request->input('user_id');
        // echo "<pre>";print_r($customer_id);exit;
        $customer = Customers::find($customer_id);

        //for custoomer uploaded document
        //Create hotel admin folder if not exists
        $hotel_admin_path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id);
        if(!File::isDirectory($hotel_admin_path)){
            File::makeDirectory($hotel_admin_path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents', 0777, true, true);//create  customer_documents folder
        }
        
        // create or update file in directory if exists in hotel admin folder
        $path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$customer_id);
        if(!File::isDirectory($path)){
            File::makeDirectory($path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$customer_id.'/display_picture', 0777, true, true);
        }

            $cust_docs_arr = array();
            //store uploaded docs
            if ($request->hasFile('uploaded_document')) {

                // Get filename with the extension
                $custDocsfilenameWithExt = $request->file('uploaded_document')->getClientOriginalName();
                // Get Filename
                $custDocfilename = pathinfo($custDocsfilenameWithExt, PATHINFO_FILENAME);
                // Get just Extension
                $custDocsextension = $request->file('uploaded_document')->getClientOriginalExtension();
                $custDocsfileNameToStore = $customer_id.'_'. time().'.'.$custDocsextension;
            
                $cust_doc = $request->file('uploaded_document')->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents'.'/'.$customer_id,$custDocsfileNameToStore);
            } else {
                $custDocsfileNameToStore = '';
                $cust_doc = '';
            }
        
            $cust_docs_arr = array(
                'customer_id'=>$customer_id,
                'document_type'=>$request->input('document_type'),
                'number'=>$request->input('number'),
                'uploaded_document'=>$custDocsfileNameToStore,
            );
            $insert_cust_docs = DB::table('customer_documents')->insertGetId($cust_docs_arr);
        
            //get documents list in descending order 
            $docs = DB::table('customer_documents')->where('customer_id',$customer_id)->where('deleted_at',null)->orderBy('id','desc')->get();
            $docs_array = array();
        //get base url 
        $base_url = URL('/');
            if($docs){
                $docs_array = $docs;
                foreach($docs_array as $doc){
                    $path = $base_url.'/public/storage/uploads/hotel_admins/'.$customer->created_by.'/'.'customer_documents/'.$customer->id.'/'.$doc->uploaded_document;
                    $doc->uploaded_document= $path;
                    unset($doc->deleted_at); 
                    unset($doc->created_at);
                    unset($doc->updated_at);
                }
            } else {
                $docs_array = array();
            }
        return $docs_array;
    }

    //removing customer docs
    public static function removeCustomerDocument($id){
        //here $id is primary id of document table
        $custDocs = CustomerDocuments::find($id);
        $curr_doc = $custDocs->uploaded_document;
        $customer_id = $custDocs->customer_id;
        $customer = Customers::find($customer_id);
        $custDocs->delete();
        // create or update file in directory if exists in hotel admin folder
        $path = public_path('storage/trash/hotel_admins/'.$customer->created_by.'/removed_customer_documents/'.$customer_id);
        if(!File::isDirectory($path)){
            File::makeDirectory($path, 0777, true, true);
        }

        $existing_file_path = public_path('storage/uploads/hotel_admins/'.$customer->created_by.'/'.'customer_documents/'.$customer_id.'/'.$curr_doc);
        $trash_file_path_dir = public_path('storage/trash/hotel_admins/'.$customer->created_by.'/'.'removed_customer_documents/'.$customer_id.'/'.$curr_doc);
      
        File::move($existing_file_path, $trash_file_path_dir);
        
        $getCustDocs = CustomerDocuments::find($id);
        if(empty($getCustDocs)){
            return true;
        } else {
            return false;
        }
    }

    //for all countries
    public static function getAllCountries(){
        //get all document types
        $getCountries  = Country::all(); 

        if(!empty($getCountries)){ 
            $countries_array = array();
            foreach($getCountries as $country){
                
                // $country_with_iso = DB::table('countries_new')->select('*')->where('code',$country->code)->first();
                // $dp_array = array();
                // if(!empty($country_with_iso)){
                //     $dp_array = array('iso_code'=>$country_with_iso->alpha3_code);
                //     echo "<pre>";print_r($dp_array);exit;
                //      DB::table('countries')->where('id', $country->id)->update($dp_array);
                // }
                // echo "<pre>";print_r($dp_array);exit;
                
                //remove unwanted columns from array
                unset($country->created_at);
                unset($country->updated_at);
                $countries_array[] = $country;
            }
            return $countries_array;
        } else {
            return false;
        }
    }

    //update user profile
    public static function updateMyProfile($request){
        //get user type and other info
        $user = User::find($request->user_id);
     
        //check if user type is hotel admin or hotel admin staff
        if($user->user_type == 3){
            //its hotel admin user
            $hoteladmin = HotelAdmin::where('main_user_id',$request->user_id)->first();
            // echo "<pre>";print_r($hoteladmin);exit;
            //Create hotel admin folder if not exists
            $hotel_admin_path = public_path('storage/uploads/hotel_admins/'.$hoteladmin->id);
            if(!File::isDirectory($hotel_admin_path)){
                File::makeDirectory($hotel_admin_path, 0777, true, true);
                File::makeDirectory('storage/uploads/hotel_admins/'.$hoteladmin->id.'/profile_picture', 0777, true, true);//create  customer_documents folder
            }

            //check if profile picture folder is exists or not
            $profile_picture_path= public_path('storage/uploads/hotel_admins/'.$hoteladmin->id.'/profile_picture');
            if(!File::isDirectory($profile_picture_path)){
                File::makeDirectory($profile_picture_path, 0777, true, true);
            }

            //for hotel admin profile picture
            if ($request->hasFile('profile_image')) {

                $filenameWithExt = $request->file('profile_image')->getClientOriginalName();
                // Get Filename
                $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
                // Get just Extension
                $extension = $request->file('profile_image')->getClientOriginalExtension();
                // Filename To store
                $fileNameToStore = $filename. '_'. time().'.'.$extension;
                $img = $request->file('profile_image')->storeAs('public/uploads/hotel_admins/'.$hoteladmin->id.'/profile_picture', $fileNameToStore);
            } else {
                $fileNameToStore = '';
            }
            
            //update other details 
            $hoteladmin->first_name     = $request->input('first_name');
            $hoteladmin->last_name     = $request->input('last_name');
            $hoteladmin->email   = $hoteladmin->email;
            if($request->input('password') == ''){
                $hoteladmin->password = $hoteladmin->password;
            } else {
                $hoteladmin->password = Hash::make($request->input('password'));
            }
            $hoteladmin->mobile = $request->input('mobile');
            $hoteladmin->expiry_date = $hoteladmin->expiry_date;
            $hoteladmin->profile_image = $fileNameToStore;
            // echo "<pre";print_r($hoteladmin);exit;
            $hoteladmin->save();
         $base_url = URL('/');
            //get updated hotel admin data
            $updated_hoteladmin = HotelAdmin::where('main_user_id',$request->user_id)->first();
            $updated_hoteladmin->profile_image = $base_url.'/storage/uploads/hotel_admins/'.$updated_hoteladmin->id.'/profile_picture/'.$updated_hoteladmin->profile_image;
            if($updated_hoteladmin->status_id == 1){
                $updated_hoteladmin->status_id = 'Active';
            } else {
                $updated_hoteladmin->status_id = 'In-Active';
            }
            unset($updated_hoteladmin->created_at);
            unset($updated_hoteladmin->updated_at);
            unset($updated_hoteladmin->deleted_at);

            return $updated_hoteladmin;
        } else {

            //its hotel admin staff user
             //its hotel admin user
             $hoteladminStaff = HotelAdminStaffs::where('main_user_id',$request->user_id)->first();

             //Create hotel admin folder if not exists
             $hotel_admin_path = public_path('storage/uploads/hotel_admins/hotel_admins_staff/'.$hoteladminStaff->id);
             if(!File::isDirectory($hotel_admin_path)){
                 File::makeDirectory($hotel_admin_path, 0777, true, true);
                 File::makeDirectory('storage/uploads/hotel_admins/hotel_admins_staff/'.$hoteladminStaff->id.'/profile_picture', 0777, true, true);//create  customer_documents folder
             }
 
             //check if profile picture folder is exists or not
             $profile_picture_staff_path= public_path('storage/uploads/hotel_admins/hotel_admins_staff/'.$hoteladminStaff->id.'/profile_picture');
             if(!File::isDirectory($profile_picture_staff_path)){
                 File::makeDirectory($profile_picture_staff_path, 0777, true, true);
             }

             //for hotel admin profile picture
            if ($request->hasFile('profile_image')) {
   
                $filenameWithExt = $request->file('profile_image')->getClientOriginalName();
                // Get Filename
                $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
                // Get just Extension
                $extension = $request->file('profile_image')->getClientOriginalExtension();
                // Filename To store
                $fileNameToStore = $filename. '_'. time().'.'.$extension;
                // Upload Image$path = 
                // echo "<pre>";print_r($fileNameToStore);exit;
                $img = $request->file('profile_image')->storeAs('public/uploads/hotel_admins/hotel_admin_staff/'.$hoteladminStaff->id.'/profile_picture', $fileNameToStore);
            } else {
                $fileNameToStore = '';
            }

            $hoteladminStaff->first_name     = $request->input('first_name');
            $hoteladminStaff->last_name     = $request->input('last_name');
            $hoteladminStaff->email   = $hoteladminStaff->email;
            if($request->input('password') == ''){
                $hoteladminStaff->password = $hoteladminStaff->password;
                $hoteladminStaff->org_password =$hoteladminStaff->org_password;
            } else {
                $hoteladminStaff->password = Hash::make($request->input('password'));
                $hoteladminStaff->org_password = $request->input('password');
            }
            $hoteladminStaff->mobile = $request->input('mobile');
            $hoteladminStaff->profile_image = $fileNameToStore;
            $hoteladminStaff->save();

            //get updated hotel admin staff details
            $updated_hoteladminStaff = HotelAdminStaffs::where('main_user_id',$request->user_id)->first();

            unset($updated_hoteladminStaff->created_at);
            unset($updated_hoteladminStaff->updated_at);
            unset($updated_hoteladminStaff->deleted_at);

            return $updated_hoteladminStaff;
        }
    }


    // for change password
    public static function changePassword($request){
        //get user infor password check
        $user = User::find($request->user_id);
        $data_array = array();
        if($request->input('old_password')){
            if(Hash::check($request->input('old_password'), $user->password)){
                //password matches and now check if password lengths are greater than 4 characters
                if(strlen($request->input('new_password')) >= 4 &&  strlen($request->input('new_password')) <= 8){
                    //now check new password and confirm password matches or not
                    if($request->input('new_password') == $request->input('confirm_password')){
                        //all ok with password validation now update password
                        
                       //check if user type is hotel admin or hotel admin staff
                        if($user->user_type == 3){

                            //change password for hotel admin
                            $hoteladmin = HotelAdmin::where('main_user_id',$request->user_id)->first();   
                            // create array to update in hotel admin table
                            $hotel_admin_password_array = array(
                                'password'=>Hash::make($request->input('new_password')),
                                'org_password'=>$request->input('new_password'),
                            );
                            DB::table('tbl_hotel_admins')->where('id', $hoteladmin->id)->update($hotel_admin_password_array);

                            //create array to update password in users table
                            $user_password_array = array(
                                'password'=>Hash::make($request->input('new_password')),
                            );
                            DB::table('users')->where('id', $request->user_id)->update($user_password_array);
                    
                        } else {
                            //change password for hotel admin staff
                            $hoteladmin_staff = HotelAdminStaffs::where('main_user_id',$request->user_id)->first();   
                            // create array to update in hotel admin table
                            $hotel_admin_staff_password_array = array(
                                'password'=>Hash::make($request->input('new_password')),
                                'org_password'=>$request->input('new_password'),
                            );
                            DB::table('tbl_hotel_admins')->where('id', $hoteladmin_staff->id)->update($hotel_admin_staff_password_array);

                            //create array to update password in users table
                            $user_password_array = array(
                                'password'=>Hash::make($request->input('new_password')),
                            );
                            DB::table('users')->where('id', $request->user_id)->update($user_password_array);
                            
                        }
                        //error for password length
                        $data_array = array("status"=> "true",'message'=>'Password updated successfully.');
                        return $data_array;
                    } else {
                        //error for password length
                        $data_array = array("status"=> "true",'message'=>'Password length must not be greater than 8 characters.');
                        return $data_array;
                    }
                } else {
                    //new and conf. password does not matches so thrwo error
                    $data_array = array("status"=> "flase",'message'=>'New password does not matches with confirm password.');
                    return $data_array;
                } 
            } else {
                //password does not matches so thrwo error
                $data_array = array("status"=> "false",'message'=>'Old password does not matches with our records.');
                return $data_array;
            }
        } else {
            //validation error
            $data_array = array("status"=> "false",'message'=>'Old password is required.');
            return $data_array;
        }
    }
    
    /*
      get error code msg from code
    */
    public static function getErrorCode($code_id){
        $getErrorMessage = DB::table('error_codes')->select('code','message')->where('code',$code_id)->first();
        return $getErrorMessage;
    }


    // get privileges
    public static function getPrivileges($group_id,$module_name){
        $getPrivileges = DB::table('staffs')
                    ->select('gp.view','gp.add','gp.edit','gp.delete')
                    ->join('groups_privileges as gp','gp.group_id','=','staffs.group_id')
                    ->join('modules as mo','mo.id','=','gp.module_id')
                    ->where('gp.group_id', $group_id)
                    ->where('mo.module_name', $module_name)
                    ->first(); 
        return $getPrivileges;
    }
    
        //get assigned properties to staff
    public static function getAssignedProperties($id){
          
       $allAssignedPropertiesData = DB::table('staff_assigned_properties as sp')
                ->select('pr.id','pr.name')
                ->join('properties as pr','pr.id', '=' ,'sp.property_id','left')
                ->join('staffs as st','st.id', '=' ,'sp.staff_id','left')
                ->where('st.main_user_id',$id)
                ->get();
        $assignedProperties = array();
        foreach($allAssignedPropertiesData as $prop){
            $assignedProperties[] = $prop;
        }
        return $assignedProperties;
    }


public static function getCustomerData($request){
        $result_arr = array();
        
        $result_arr['basic_info'] = array();
        $result_arr['background_check'] = array();
        $result_arr['room_details'] = array();
        $result_arr['documents'] = array();
        $result_arr['notes'] =  array();
        //get base url 
        $base_url = URL('/');
        
        //for basic info
        
        $customer_basic_data = DB::table('customers')
                        ->select('id','first_name','last_name','full_name','email','date_of_birth','gender','nationality','passport_number','passport_expiry_date','country_of_issue','profile_image','address','address_line_1','address_line_2','city','state','country','pin','checkin_date_time','checkout_date_time','room_id','property_id','visa_number','visa_issue_date','visa_expiry_date','other_id_type','other_id_number','other_id_expiry_date','created_by')
                        ->where('id',$request['customer_id'])
                        ->first();

        if($request['basic_info']){
            //for basic details
            $basic_array = Api::getCustomerBasicDetails($customer_basic_data);
        } else {
            $basic_array = array();
        }

$customer_basic_data->full_name = $customer_basic_data->first_name.' '.$customer_basic_data->last_name;
 
 
        if($request['background_check']){ 
            //for background check - complaints
            $complaint_array = Api::getComplaintsByCustomer($customer_basic_data->id);

            //for background check - criminal record
            $criminal_record_array = Api::getCriminalRecordByCustomer($customer_basic_data);
        } else {
            $complaint_array = array();
            $criminal_record_array = array();
        }

        if($request['rooms_details']){
            //for room details
            $room_array = Api::getRoomDetails($customer_basic_data);
        } else {
            $room_array = array();
        }

        if($request['documents']){
            //for documents details
            $docs_array = Api::getDocumentsDetails($customer_basic_data);
        } else {
            $docs_array = array();
        }

        if($request['all']){
            //for basic details
            $basic_array = Api::getCustomerBasicDetails($customer_basic_data);

            //for background check - complaints
            $complaint_array = Api::getComplaintsByCustomer($customer_basic_data->id);

            //for background check - criminal record
            $criminal_record_array = Api::getCriminalRecordByCustomer($customer_basic_data);

            //for room details
            $room_array = Api::getRoomDetails($customer_basic_data);

            //for documents details
            $docs_array = Api::getDocumentsDetails($customer_basic_data);
        }
        
        if(!empty($complaint_array)){
            $complaint_array = $complaint_array;
        } else {
            $complaint_array = array();
        }
        
        if(!empty($basic_array)){
            $basic_array = $basic_array;
        } else {
            $basic_array = (object)array();
        }
        
        if(!empty($room_array)){
            $room_array = $room_array;
        } else {
            $room_array = (object)array();
        }
        
        $result_arr['basic_info'] = $basic_array;

        $result_arr['background_check']['complaints'] = array();
        $result_arr['background_check']['complaints'] = $complaint_array;

        $result_arr['background_check']['criminal_records'] = array();
        $result_arr['background_check']['criminal_records'] = $criminal_record_array;

        $result_arr['room_details'] = $room_array;
        $result_arr['documents'] = $docs_array;


        //get all customer notes
        $customer_notes = DB::table('customer_notes')
                        ->select('id','date_time','note')
                        ->where('customer_id',$request['customer_id'])
                        ->orderBy('id','DESC')
                        ->get();
        $all_notes = array();
        if(!empty($customer_notes)){
            foreach($customer_notes as $note){
                $all_notes[] = $note;
            }
        }
        $result_arr['notes'] = $all_notes; 
        
        
        return $result_arr;
    }
    
    public static function getCustomerBasicDetails($customer_basic_data){
        //get base url 
        $base_url = URL('/');
 
        //customer profile image path
         $customer_basic_data->profile_image = $base_url.'/public/storage/uploads/hotel_admins/'.$customer_basic_data->created_by.'/customer_documents'.'/'.$customer_basic_data->id.'/display_picture'.'/'.$customer_basic_data->profile_image;
         
        //get property detial
        // $property = Properties::find($customer_basic_data->property_id);
        // $customer_basic_data->property_name = '';
        // $customer_basic_data->property_name = $property->name;
         
         
         //for nationality 
          $customer_basic_data->nationality =  '';
         $country_title = Country::find($customer_basic_data->nationality);
         if(!empty($country_title)){
            $customer_basic_data->nationality = $country_title->name;
         }
         //for country of issue 
         $customer_basic_data->country_of_issue = '';
         $country_title = Country::find($customer_basic_data->country_of_issue);
         if(!empty($country_title)){
            $customer_basic_data->country_of_issue = $country_title->name;
         }
        //for country 
         $country_title = Country::find($customer_basic_data->country);
         $customer_basic_data->country = '';
         if(!empty($country_title)){
             $customer_basic_data->country = $country_title->name;
         }
         
         
         //get gender 
         $customer_basic_data->gender = ($customer_basic_data->gender == 1) ? 'Male':'Female';
        return  $customer_basic_data;
    }

    public static function getComplaintsByCustomer($cust_id){
        //get base url 
        $base_url = URL('/');
        // echo "<pre>";print_r($cust_id);exit;
        $complaint_array_updated = array();
        $complaints_list = Complaints::where('complaint_against',$cust_id)->get();
       
        foreach($complaints_list as $complaint){
            if($complaint->complaint_status == '1'){//show in mobile app else hide
                $id = $complaint->id;
                //get complaint against
                $complaint_against = Customers::find($complaint->complaint_against);
                $complaint->complaint_against = $complaint_against->full_name;
                
                //get passport number 
                $complaint->passport_number = '';
                $complaint->passport_number = $complaint_against->passport_number;

                //get complaint from
                $hotel_admin_id = $complaint->complaint_from;
                // echo "<pre>";print_r($complaint->complaint_from);exit;
                $complaint_from = HotelAdmin::where('main_user_id',$complaint->complaint_from)->first();
            
                $complaint->complaint_from = $complaint_from->first_name.' '.$complaint_from->last_name;
                
                $complaint->document  = $base_url.'/storage/uploads/hotel_admins/'.$hotel_admin_id.'/complaints_doccument'.'/'.$complaint_against->id.'/'.$complaint->document;
                $complaint_array_updated[] = $complaint;
                unset($complaint->deleted_at);
            }
        }
        return $complaint_array_updated;
    }

    public static function getCriminalRecordByCustomer($customer_basic_data){
        //get base url 
        $base_url = URL('/');

        $criminal_array_updated = array();
        if($customer_basic_data){
            // echo "<pre>";print_R($customer_details);exit;
            $criminal_details = CriminalRecords::where('first_name',$customer_basic_data->full_name)->get();
        
            foreach($criminal_details as $criminal){
                $criminal->name = $criminal->first_name.' '.$criminal->last_name;

                $criminal->image  = $base_url.'/storage/uploads/criminal_records/'.$criminal->image;
                $criminal_array_updated[] = $criminal;
            }
        }
        return $criminal_array_updated;
    }

    public static function getRoomDetails($customer_basic_data){
        //get base url 
        $base_url = URL('/');

        //get property detial
        if($customer_basic_data->property_id){
            $property = Properties::find($customer_basic_data->property_id);
            $customer_basic_data->property_id = $property->name;
        } else {
            $customer_basic_data->property_id = '0';
        }
        
        //get room title
        $room_details = Room::find($customer_basic_data->room_id);
        $customer_basic_data->room_id =  '0';
        if( $room_details){
            $customer_basic_data->room_id =  $room_details->title;
        }
       
        $room_array = array(
            'property'=>$customer_basic_data->property_id ,
            'room'=>$customer_basic_data->room_id,
            'checkin_datetime'=>$customer_basic_data->checkin_date_time,
            'checkout_datetime'=>$customer_basic_data->checkout_date_time
        );
        return $room_array;
    }

    public static function getDocumentsDetails($customer_basic_data){
        //get base url 
        $base_url = URL('/');

        $docs = DB::table('customer_documents')->where('customer_id',$customer_basic_data->id)->where('deleted_at',null)->get();
        $docs_array_updated = array();
        if($docs){
            $docs_array = $docs;
            foreach($docs_array as $doc){
                $path = $base_url.'/storage/uploads/hotel_admins/'.$customer_basic_data->created_by.'/'.'customer_documents/'.$customer_basic_data->id.'/'.$doc->uploaded_document;
                $doc->uploaded_document= $path;

                //get doc type
                $types = IdProofTypes::find($doc->document_type);
                $doc->document_type = $types->title;
                $docs_array_updated[] = $doc;
                unset($doc->deleted_at);
                unset($doc->created_at);
                unset($doc->updated_at);
            }
        } else {
            $docs_array_updated = array();
        }
        return $docs;
    }
    
    //get logged in user account info
    public static function getAccountInfo($request){
        $result_arr = array();
         $user = User::find($request['user_id']);
        $info = array();
        if($request['is_staff']){
             $allinfo  = HotelAdminStaffs::where('main_user_id',$request['user_id'])->first();
            // $allinfo = DB::table('staffs')
            //             ->select('id','first_name','last_name','email','mobile','expiry_date','profile_image')
            //             ->where('id',$request['user_id'])
            //             ->first();
        } else {
             $allinfo = HotelAdmin::where('main_user_id',$request['user_id'])->first();
            // $allinfo = DB::table('tbl_hotel_admins')
            //             ->select('id','first_name','last_name','email','mobile','expiry_date','profile_image')
            //             ->where('id',$request['user_id'])
            //             ->first();
        }
        return $allinfo;
    }


    //get logged in user guest code
    public static function getguestcode($request){
        $result_arr = array();

        //create guest code
        $property = Properties::find($request['property_id']);
        $total_cnt_q = DB::table('customers')
            ->select('id')
            ->Where('property_id', $request['property_id'])
            ->get();
        $total_cnt = count($total_cnt_q);
        $total_cnt = $total_cnt + 1;
        $cust_code = sprintf("%'.04d\n", $total_cnt);
        $guest_code =   $property->code.'-'.date('d-m-Y').'-'.$cust_code;   
        $result_arr =  array('guest_code'=> trim($guest_code));
        return $result_arr;
        // echo "<pre>";print_r($request);exit;
        // return $allinfo;
    }
    
    //add notes
    public static function addNote($request){
        //for basic info tab details
        $hotel_admin_id = $request->input('user_id');
        $customer_id = $request->input('customer_id');
        $note = $request->input('note');
        $notes_array = array(
            'customer_id' => $customer_id,
             'note' => $note,
            );
        $insert_cust_docs = DB::table('customer_notes')->insertGetId($notes_array);
        if($insert_cust_docs){
             return true;
        } else {
              return false;
        }
    }
    
    
    

    
    
    //for all booking tyupes
    public static function getBookingTypes($data){
        $booking_types = BookingTypes::where('created_by',$data->user_id)->where('deleted_at',null)->get();    
        if(!empty($booking_types)){ 
            $booking_types_array = array();
            foreach($booking_types as $type){
                //remove unwanted columns from array
                unset($type->deleted_at); 
                unset($type->created_at);
                unset($type->updated_at);

                $booking_types_array[] = $type;
            }
            return $booking_types_array;
        } else {
            return false;
        }
    }


    
        
    //add notes
    public static function submitDigitalSign($request){
        //for basic info tab details
        $hotel_admin_id = $request->input('user_id');
        $customer_id = $request->input('customer_id');
        $digital_sign = $request->input('digital_sign');
        
        
        $hotel_admin_path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id);
            if(!File::isDirectory($hotel_admin_path)){
                File::makeDirectory($hotel_admin_path, 0777, true, true);
                File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents', 0777, true, true);//create  customer_documents folder
            }
            
        if ($request->hasFile('digital_sign')) {

            $filenameWithExt = $request->file('digital_sign')->getClientOriginalName ();
            // Get Filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $extension = $request->file('digital_sign')->getClientOriginalExtension();
            // Filename To store
            $fileNameToStore = $filename. '_'. time().'.'.$extension;
            // Upload Image$path = 
            $img = $request->file('digital_sign')->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents'.'/'.$customer_id.'/digital_sign', $fileNameToStore);
            $dp_array = array('digital_sign'=>$fileNameToStore,);
            DB::table('customers')->where('id', $customer_id)->update($dp_array);
            return true;
        } else {
            return false;
        }
    }
    
     //for all visitors 
    public static function getVisitors($data){
        $base_url = URL('/');
        if($data->visitor_id){
            $visitors = Visitors::where('created_by',$data->user_id)->where('id',$data->visitor_id)->where('deleted_at',null)->get(); 
        } else {
            $visitors = Visitors::where('created_by',$data->user_id)->where('deleted_at',null)->get(); 
        }
           
        if(!empty($visitors)){ 
            $visitor_array = array();
            foreach($visitors as $visitor){
                //remove unwanted columns from array
                unset($visitor->deleted_at); 
                unset($visitor->created_at);
                unset($visitor->updated_at);

                $images = DB::table('tbl_visitor_images')->select('id','image','created_at')->where('visitor_id',$data->visitor_id)->where('deleted_at',null)->get();
                $images_ar = array();
                foreach($images as $img){
                    $img->image = $base_url.'/public/storage/uploads/hotel_admins/'.$visitor->created_by.'/visitors'.'/'.$img->image;
                    $images_ar[] = $img;
                }
                $visitor->images = $images_ar;
                // $visitor->visitor_image = $base_url.'/storage/uploads/hotel_admins/'.$data->user_id.'/visitors/'.$visitor->visitor_image;
                //  $visitor->visitor_image = $base_url.'/public/storage/uploads/hotel_admins/'.$visitor->created_by.'/visitors'.'/'.$visitor->visitor_image;
                 
                $visitor_array[] = $visitor;
            }
            return $visitor_array;
        } else {
            return false;
        }
    }
    
    //add notes
    public static function addVisitor($request){
        //for basic info tab details
        $hotel_admin_id = $request->input('user_id');
        $customer_id = $request->input('customer_id');
        //for complaint document
        // if ($request->hasFile('visitor_image')) {

        //     $headerfilenameWithExt = $request->file('visitor_image')->getClientOriginalName ();
        //     // Get Filename
        //     $headerfilename = pathinfo($headerfilenameWithExt, PATHINFO_FILENAME);
        //     // Get just Extension
        //     $headerextension = $request->file('visitor_image')->getClientOriginalExtension();
        //     // Filename To store
        //     $headerfileNameToStore = 'Visitor_'.$headerfilename. '_'. time().'.'.$headerextension;
        //     // Upload Image$path = 
            
            
        //      $img = $request->file('visitor_image')->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/visitors', $headerfileNameToStore);
             
             
        // } else {
        //     $headerfileNameToStore = '';
        //     $headerimg = '';
        // }
        
         //insert new criminal record
        $record = new Visitors();
        $record->name    = $request->input('name');
        $record->title      = $request->input('title');
        $record->company     = $request->input('company');
        $record->property_id      = $request->input('property_id');
        $record->reason    = $request->input('reason');
        $record->visit_in_date    = $request->input('visit_in_date');
        $record->visit_in_time    = $request->input('visit_in_time');
        $record->visit_out_date    = $request->input('visit_out_date');
        $record->visit_out_time         = $request->input('visit_out_time');
        $record->remark	= $request->input('remark');
        $record->telephone            = $request->input('telephone');
        $record->visiting_whoom         = $request->input('visiting_whoom');
        $record->vehicle_no            = $request->input('vehicle_no');
        // $record->visitor_image   =  $headerfileNameToStore; 
        $record->created_by     = $request->input('user_id');
        // echo "<pre>";print_r($record);exit;
        $record->save();
        $visitor_id = $record->id;
        
        $img_ar = array();
        $headerfileNameToStore = '';
        $headerimg = '';
        
        $cnt = count($request->file('visitor_image'));
        // echo "<pre>";print_r($request->file('visitor_image')[0]);exit;
        
        for($i=0; $i <= $cnt;$i++){
            $headerfilenameWithExt = $request->file('visitor_image')[$i]->getClientOriginalName ();
            // Get Filename
            $headerfilename = pathinfo($headerfilenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $headerextension = $request->file('visitor_image')[$i]->getClientOriginalExtension();
            // Filename To store
            $headerfileNameToStore = 'Visitor_'.$headerfilename. '_'. time().'.'.$headerextension;
            // Upload Image$path = 
             $img = $request->file('visitor_image')[$i]->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/visitors', $headerfileNameToStore);
             
            $visitor_iamge = new VisitorImages();
            $visitor_iamge->visitor_id = $visitor_id;
            $visitor_iamge->image = $headerfileNameToStore;
            // echo "<pre>";print_r();exit;
            $visitor_iamge->save();
        }
        // foreach($request->file('visitor_image') as $key => $file){
        //      $headerfilenameWithExt = $file->getClientOriginalName ();
        //     // Get Filename
        //     $headerfilename = pathinfo($headerfilenameWithExt, PATHINFO_FILENAME);
        //     // Get just Extension
        //     $headerextension = $file->getClientOriginalExtension();
        //     // Filename To store
        //     $headerfileNameToStore = 'Visitor_'.$headerfilename. '_'. time().'.'.$headerextension;
        //     // Upload Image$path = 
        //      $img = $file->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/visitors', $headerfileNameToStore);
             
        //     $visitor_iamge = new VisitorImages();
        //     $visitor_iamge->visitor_id = $visitor_id;
        //     $visitor_iamge->image = $headerfileNameToStore;
        //     // echo "<pre>";print_r();exit;
        //     $visitor_iamge->save();
                     
        // }
        
        if($record){
             return true;
        } else {
              return false;
        }
    }
    
    //update visitor
    public static function updateVisitor($request,$id){
    
        //for basic info tab details
        $hotel_admin_id = $request->input('user_id');
        $visitor = Visitors::findOrFail($id);
        
        $visitor->name    = $request->input('name');
        $visitor->title      = $request->input('title');
        $visitor->company     = $request->input('company');
        $visitor->property_id      = $request->input('property_id');
        $visitor->reason    = $request->input('reason');
        $visitor->visit_in_date    = $request->input('visit_in_date');
        $visitor->visit_in_time    = $request->input('visit_in_time');
        $visitor->visit_out_date    = $request->input('visit_out_date');
        $visitor->visit_out_time         = $request->input('visit_out_time');
        $visitor->remark	= $request->input('remark');
        $visitor->telephone            = $request->input('telephone');
        $visitor->visiting_whoom         = $request->input('visiting_whoom');
        $visitor->vehicle_no = $request->input('vehicle_no');
                //for complaint document
        // if ($request->hasFile('visitor_image')) {

        //     $headerfilenameWithExt = $request->file('visitor_image')->getClientOriginalName ();
        //     // Get Filename
        //     $headerfilename = pathinfo($headerfilenameWithExt, PATHINFO_FILENAME);
        //     // Get just Extension
        //     $headerextension = $request->file('visitor_image')->getClientOriginalExtension();
        //     // Filename To store
        //     $headerfileNameToStore = 'Visitor_'.$headerfilename. '_'. time().'.'.$headerextension;
        //     // Upload Image$path = 
        //     $headerimg = $request->file('visitor_image')->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/visitors', $headerfileNameToStore);
             
        // } else {
        //     $headerfileNameToStore = '';
        //     $headerimg = '';
        // }
        
        // $visitor->visitor_image   =  $headerfileNameToStore; 
        $visitor->save();
        
         $img_ar = array();
        $headerfileNameToStore = '';
        $headerimg = '';
        
        if (!empty($request->hasFile('visitor_image'))) {
            VisitorImages::where('visitor_id', $id)->delete();
        }
            
        foreach($request->file('visitor_image') as $file){
             $headerfilenameWithExt = $file->getClientOriginalName ();
            // Get Filename
            $headerfilename = pathinfo($headerfilenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $headerextension = $file->getClientOriginalExtension();
            // Filename To store
            $headerfileNameToStore = 'Visitor_'.$headerfilename. '_'. time().'.'.$headerextension;
            // Upload Image$path = 
             $img = $file->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/visitors', $headerfileNameToStore);
             
            $visitor_iamge = new VisitorImages();
            $visitor_iamge->visitor_id = $id;
            $visitor_iamge->image = $headerfileNameToStore;
            $visitor_iamge->save();
                     
        }
        
        if(!empty($visitor)){
            return array('visitor_id'=>$id);
            // return true;
        } else {
            return false;
        }
    }
    
    //for all room call info 
    public static function getRoomCallInfo($data){
        $getRoomInfo = DB::table('rooms')->where('title',$data->room_no)->whereNull('deleted_at')->get()->first();; 
        $ext = $getRoomInfo->extension;
        $getExtInfo = DB::table('pbx_extensions')->where('id',$ext)->whereNull('deleted_at')->get()->first();
        if(!empty($getRoomInfo)){
            if($data->access_token != $getRoomInfo->access_token){
                return 5;
            }
        }
        $call_array = array();
        if(!empty($getRoomInfo)){
            
            $getGuestInfo = DB::table('customers')->where('room_id',$getRoomInfo->id)->whereNull('deleted_at')->whereNull('checkout_date_time')->orderBy('id','desc')->get()->first();
            $call_array['room_no'] = $data->room_no;
            $call_array['room_id'] = $getRoomInfo->id;
            $getPropertyInfo = DB::table('properties')->where('id',$getRoomInfo->property_id)->get()->first(); 
            $call_array['property_id'] = $getPropertyInfo->id;
            $call_array['receiver_id'] = $getRoomInfo->created_by;
            
            $call_array['default_msg'] = '';
            $call_array['pos_service_url'] = '';
            $call_array['room_service_url'] = '';
            $call_array['sender_id'] = '';
            $call_array['guest_name'] =  '';
            $call_array['checkin_date_time'] =  '';
            $call_array['room_guest_name'] =  '';
            $call_array['checkout_date_time'] = '';
            $call_array['wifi_qr_code'] = '';
            $call_array['room_qr_code'] = '';
            $call_array['room_pos_url'] = '';
            if(!empty($getGuestInfo)){
                $call_array['sender_id'] = $getGuestInfo->id;
                
                $guestname = '';
                if($getPropertyInfo->show_guest_name ==1){
                    $guestname = $getGuestInfo->first_name.' '.$getGuestInfo->last_name;
                }
                $call_array['room_guest_name'] = $guestname;
                $call_array['guest_name'] = $guestname;
               
                $base_url = URL('/');
                $wifi_path = Storage::url('app/public/uploads/hotel_admins/'.$getRoomInfo->created_by.'/rooms/'.$getRoomInfo->id.'/wifi_qr/'.$getRoomInfo->wifi_qr_code);
            
                $room_path = Storage::url('app/public/uploads/hotel_admins/'.$getRoomInfo->created_by.'/rooms/'.$getRoomInfo->id.'/room_qr/'.$getRoomInfo->room_service_qr_code);
                                
                // $call_array['wifi_qr_code'] = $base_url.$wifi_path;
                // $call_array['room_qr_code'] = $base_url.$room_path;
                $call_array['wifi_qr_code'] = '';
                if($getRoomInfo->wifi_qr_code){
                    $call_array['wifi_qr_code'] = $base_url.$wifi_path;
                }
                
                $call_array['room_qr_code'] = '';
                if($getRoomInfo->room_service_qr_code){
                    $call_array['room_qr_code'] = $base_url.$room_path;
                }
                
                // $call_array['guest_name'] = $getGuestInfo->first_name.' '.$getGuestInfo->last_name;
                $call_array['checkin_date_time'] = $getGuestInfo->checkin_date_time;
                if(!$getGuestInfo->checkout_date_time){
                    $call_array['checkout_date_time'] = '';
                } else {
                    $call_array['checkout_date_time'] = $getGuestInfo->checkout_date_time;
                }
                $call_array['default_msg'] = $getRoomInfo->welcome_msg;
                // $call_array['room_guest_name'] = $getRoomInfo->guest_name;
                // $call_array['room_service_url'] = $getPropertyInfo->service_url;
                // $call_array['room_service_url'] = $getRoomInfo->room_service_url;
                //  $call_array['hotel_service_url'] = $getPropertyInfo->service_url;
                // $call_array['pos_service_url'] = $getPropertyInfo->pos_service_url;
                $call_array['room_pos_url'] = $getRoomInfo->room_service_url;
                $call_array['hotel_service_url'] = $getPropertyInfo->service_url;
                
            }
                $getAssignedPbxExtension = DB::table('pbx_extensions as pe')
                                            ->select('pe.title','pe.extension','pe.password','pe.local_sip_extension','pe.yeastar_login_sign')
                                            ->join('rooms as ro','ro.extension','=','pe.id')
                                            ->join('yeastar_access_info as ya','ya.extension_id','=','pe.id')
                                            ->where('ro.id',$getRoomInfo->id)
                                            ->whereNull('ro.deleted_at')
                                            ->get(); 
                
                $assigned_ar = array();
                $room_password = '';
                // $yeastar_local_ip ='epenhtestpbx.thycm.yeastarcloud.com';
                
                //for remote pbx
                // $yeastar_local_ip ='somahotel.ras.yeastar.com';
                $yeastar_local_ip ='192.168.7.221';
            
                foreach($getAssignedPbxExtension as $ext){
                    $ext->yeastar_username ='';
                    $ext->yeastar_username = $ext->local_sip_extension;
                    $ext->yeastar_local_ip =$yeastar_local_ip;
                    unset($ext->local_sip_extension);
                    unset($ext->title);
                    unset($ext->password);
                    $assigned_ar[] = $ext;
                }
    
                $call_array['login_code'] = $room_password;
                $getUnassignedPbxExtensions = DB::table('pbx_extensions as pe')
                                            ->select('pe.title','pe.extension','pe.password','pe.local_sip_extension','pe.yeastar_login_sign')
                                            ->leftJoin('rooms as ro', 'ro.extension', '=', 'pe.id')
                                            ->leftJoin('yeastar_access_info as ya','ya.extension_id','=','pe.id')
                                            ->where(function($query) use         ($getRoomInfo) {
                                            $query->whereNull('ro.id')
                                                  ->orWhere('ro.id', '!=',     $getRoomInfo->id);
                                        })
                                            ->whereNull('pe.deleted_at') // skip soft-deleted pbx_extensions
                                            ->get();
                $unassigned_ar = array();
                foreach($getUnassignedPbxExtensions as $ext){
                    $ext->yeastar_username ='';
                    $ext->yeastar_username =$ext->local_sip_extension;
                    $ext->yeastar_local_ip =$yeastar_local_ip;
                    unset($ext->local_sip_extension);
                    unset($ext->title);
                    unset($ext->password);
                    $unassigned_ar[] = $ext;
                }
                $call_array['local_sip_extension'] = $getExtInfo->local_sip_extension;
                $call_array['assigned_ext'] = $assigned_ar;
                $call_array['unassigned_ext'] = $unassigned_ar;
                $call_array['access_token'] = $getRoomInfo->access_token;
                return $call_array;
        } else {
            return array();
        }
    }
    
     //for all room call info 
    public static function roomLogin($data){
        $getRoomInfo = DB::table('rooms')->where('title',$data->room_no)->whereNull('deleted_at')->get()->first(); 
        if(empty($getRoomInfo)){
            return array();
        }
        // echo "<pre>";print_r($getRoomInfo);exit;
        $ext = $getRoomInfo->extension;
        $getExtInfo = DB::table('pbx_extensions')->where('id',$ext)->whereNull('deleted_at')->get()->first();
        // echo "<pre>";print_r($getExtInfo->password.' '.$data->password);exit;
        $call_array = array();
        if(!empty($getRoomInfo) && $getExtInfo->password == $data->password){
            $call_array['room_id'] = $getRoomInfo->id;
            $call_array['room_no'] =  $data->room_no;
            $getPropertyInfo = DB::table('properties')->where('id',$getRoomInfo->property_id)->get()->first(); 
            $call_array['property_id'] = $getPropertyInfo->id;
            
            // $call_array['default_msg'] = $getPropertyInfo->welcome_msg;
            
            $call_array['receiver_id'] = $getRoomInfo->created_by;
            
            $call_array['pos_service_url'] = '';
            $call_array['room_service_url'] = '';
            $call_array['default_msg'] = '';
            $call_array['sender_id'] = '';
            $call_array['guest_name'] =  '';
            $call_array['checkin_date_time'] =  '';
            $call_array['checkout_date_time'] = '';
            $call_array['room_guest_name'] =  '';
            $call_array['wifi_qr_code'] = '';
            $call_array['room_qr_code'] = '';
            $call_array['room_pos_url'] = '';
            $getGuestInfo = DB::table('customers')->where('room_id',$getRoomInfo->id)->whereNull('deleted_at')->orderBy('id','desc')->get()->first(); 
            if(!empty($getGuestInfo) && !$getGuestInfo->checkout_date_time){
                $call_array['default_msg'] = $getRoomInfo->welcome_msg;
             
                // $call_array['room_service_url'] = $getPropertyInfo->service_url;
                // $call_array['room_service_url'] = $getRoomInfo->room_service_url;
                // $call_array['hotel_service_url'] = $getPropertyInfo->service_url;
                
                // $call_array['pos_service_url'] = $getPropertyInfo->pos_service_url;
                $call_array['room_pos_url'] = $getRoomInfo->room_service_url;
                $call_array['hotel_service_url'] = $getPropertyInfo->service_url;
                
              
                $call_array['sender_id'] = $getGuestInfo->id;

                $guestname = '';
                // echo $getPropertyInfo->show_guest_name;exit;
                if($getPropertyInfo->show_guest_name == 1){
                    $guestname = $getGuestInfo->first_name.' '.$getGuestInfo->last_name;
                }
                $call_array['room_guest_name'] = $guestname;
                $call_array['guest_name'] = $guestname;
               
                
                $base_url = URL('/');
                $wifi_path = Storage::url('app/public/uploads/hotel_admins/'.$getRoomInfo->created_by.'/rooms/'.$getRoomInfo->id.'/wifi_qr/'.$getRoomInfo->wifi_qr_code);
            
                $room_path = Storage::url('app/public/uploads/hotel_admins/'.$getRoomInfo->created_by.'/rooms/'.$getRoomInfo->id.'/room_qr/'.$getRoomInfo->room_service_qr_code);
                $call_array['wifi_qr_code'] = '';
                if($getRoomInfo->wifi_qr_code){
                    $call_array['wifi_qr_code'] = $base_url.$wifi_path;
                }
                
                $call_array['room_qr_code'] = '';
                if($getRoomInfo->room_service_qr_code){
                    $call_array['room_qr_code'] = $base_url.$room_path;
                }
                
                
                // $call_array['room_qr_code'] = $base_url.$room_path;
               
                $call_array['checkin_date_time'] = $getGuestInfo->checkin_date_time;
                if(!$getGuestInfo->checkout_date_time){
                    $call_array['checkout_date_time'] = '';
                } else {
                    $call_array['checkout_date_time'] = $getGuestInfo->checkout_date_time;
                }
            }

            $getAssignedPbxExtension = DB::table('pbx_extensions as pe')
                                        ->select('pe.title','pe.extension','pe.password','pe.local_sip_extension','pe.yeastar_login_sign')
                                        ->join('rooms as ro','ro.extension','=','pe.id')
                                        ->join('yeastar_access_info as ya','ya.extension_id','=','pe.id')
                                        ->where('ro.id',$getRoomInfo->id)
                                        ->whereNull('ro.deleted_at')
                                        ->get(); 
            
            $assigned_ar = array();
            $room_password = '';
            
            // $yeastar_local_ip ='epenhtestpbx.thycm.yeastarcloud.com';
            
            //for remote pbx
            // $yeastar_local_ip ='somahotel.ras.yeastar.com';
            $yeastar_local_ip ='192.168.7.221';
            foreach($getAssignedPbxExtension as $ext){
                $ext->yeastar_username ='';
                $ext->yeastar_username =$ext->local_sip_extension;
                $ext->yeastar_local_ip =$yeastar_local_ip;
                unset($ext->local_sip_extension);
                unset($ext->title);
                unset($ext->password);
                $assigned_ar[] = $ext;
            }

            $call_array['login_code'] = $room_password;
            $getUnassignedPbxExtensions = DB::table('pbx_extensions as pe')
                                        ->select('pe.title','pe.extension','pe.password','pe.local_sip_extension','pe.yeastar_login_sign')
                                        ->leftJoin('rooms as ro', 'ro.extension', '=', 'pe.id')
                                        ->leftJoin('yeastar_access_info as ya','ya.extension_id','=','pe.id')
                                         ->where(function($query) use         ($getRoomInfo) {
                                            $query->whereNull('ro.id')
                                                  ->orWhere('ro.id', '!=',     $getRoomInfo->id);
                                        })
                                        ->whereNull('pe.deleted_at') // skip soft-deleted pbx_extensions
                                        ->get();
            $unassigned_ar = array();
           
            foreach($getUnassignedPbxExtensions as $ext){
                $ext->yeastar_username ='';
                $ext->yeastar_username =$ext->local_sip_extension;
                $ext->yeastar_local_ip =$yeastar_local_ip;
                unset($ext->local_sip_extension);
                unset($ext->title);
                unset($ext->password);
                $unassigned_ar[] = $ext;
            }
            
            $call_array['assigned_ext'] = $assigned_ar;
            $call_array['unassigned_ext'] = $unassigned_ar;
            // echo "<pre>";print_r($call_array);exit;
                
            $access_token = Str::random(30);
            $update_device_token = array(
                'device_token' => $data->device_token,
                'access_token' => $access_token
            );
            DB::table('rooms')->where('id',$getRoomInfo->id)->update($update_device_token);
             $call_array['access_token'] = $access_token;
           
            return $call_array;
        } else {
            return array();
        }
    }
    
    public static function roomLogout($data){
         $update_device_token = array(
                'device_token' => NULL,
                'access_token' => NULL
            );
        DB::table('rooms')->where('id',$data->room_id)->update($update_device_token);
        return true;
    }
}

