<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use App\Models\Staffs;
use App\Models\GovAdmin;
use App\Models\MyProfile;
use App\Models\PBXSettings;

use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use DataTables;
use File;
use Illuminate\Support\Facades\Auth;

class SettingsController extends Controller
{

   public function pbxSettinglist(){
        $id  = Auth::user()->id;
        $pbx = PBXSettings::where('user_id',$id)->first();
      
        // Optional: make sure $pbx is at least an empty object
        if (!$pbx) {
            $pbx = new \stdClass();
        }
        return view('dashboard.pbxSettings.pbx', [ 'pbx' => $pbx ]);
   }

     public function submitPbxSettings(Request $request){
        $id  = Auth::user()->id;
        $pbx = PBXSettings::where('user_id',$id)->first();
        
        if(!empty($pbx)){
            $pbx =  PBXSettings::find($pbx->id);
        } else {
            $pbx = new PBXSettings();
        }
        $pbx->user_id = $id;
        $pbx->ip_or_url = $request->input('ip_or_url');
        $pbx->extension = $request->input('extension');
        $pbx->password = $request->input('password');
        $pbx->created_by = $id;
        $pbx->save();
        $request->session()->flash('message', 'PBX Settings updated Successfully.');
       
        $pbx = PBXSettings::where('user_id',$id)->first();
        return view('dashboard.pbxSettings.pbx', [ 'pbx' => $pbx ]);
   }
   

   public function index(){

        $id  = Auth::user()->id;
        $mainUser = User::find($id);
        //check if logged in user type
        if($mainUser->user_type == 3){ //hotel admin
            $user = HotelAdmin::where('main_user_id',$mainUser->id)->first();
            $user->profile_image = 'public/storage/uploads/hotel_admins/'.$user->id.'/profile_picture/'.$user->profile_image;
        } else if($mainUser->user_type == 4){ //hotel admin staff
            $user = Staffs::where('main_user_id',$mainUser->id)->first();
            $user->profile_image = 'public/storage/uploads/hotel_admins/'.$user->created_by.'/hotel_admin_staffs/'.$user->id.'/profile_picture/'.$user->profile_image;
        } else if($mainUser->user_type == 5){ //govt admin
            $user = GovAdmin::where('main_user_id',$mainUser->id)->first();
            $user->profile_image = 'public/storage/uploads/govt_admins/'.$user->id.'/profile_picture/'.$user->profile_image;
           
        } else { //govt dmin staff
            $user = Staffs::where('main_user_id',$mainUser->id)->first();
            $user->profile_image = 'public/storage/uploads/govt_admins/'.$user->created_by.'/govt_admin_staffs/'.$user->id.'/profile_picture/'.$user->profile_image;
        } 
        return view('dashboard.profilesettings.create', [ 'user' => $user ]);
   }

   public function update(Request $request, $id){
        $this->validate($request, [
            'old_password' => 'required',
            'new_password' => 'required|min:4|max:8|different:old_password',
            'confirm_password' => 'required|min:4|max:8|same:new_password',
        ]);

        //get user info from main table
        $id = Auth::user()->id;
        $user = MyProfile::find($id);

        // create array to update in hotel admin table
        $sub_password_array = array(
            'password'=>Hash::make($request->input('password')),
            'org_password'=>$request->input('password'),
        );

         //get updted user
         if($user->user_type == 3){ //hotel admin
        
            // $updted_user = HotelAdmin::find($user->id);
            $updted_user = HotelAdmin::where('main_user_id',$user->id)->first();
            //  echo "<pre>";print_r($updted_user);exit;
            DB::table('tbl_hotel_admins')->where('id', $updted_user->id)->update($sub_password_array);

        } else if($user->user_type == 4){//hotel admin staff
            $updted_user = Staffs::find($user->id); 
            DB::table('staffs')->where('id', $updted_user->id)->update($sub_password_array);

        } else if($user->user_type == 5){//govt admin
            $updted_user = GovAdmin::find($user->id);
            DB::table('gov_admins')->where('id', $updted_user->id)->update($sub_password_array);

        } else { //govt admin staff
            $updted_user = Staffs::find($sub_user->id);
            DB::table('staffs')->where('id', $updted_user->id)->update($sub_password_array);
        }
        
        //create array to update password in users table
        $user_password_array = array(
            'password'=>Hash::make($request->input('password')),
        );
        DB::table('users')->where('id', $user->id)->update($user_password_array);

        return view('dashboard.profilesettings.create', [ 'user' => $updted_user ]);
   }

   public function update_old(Request $request, $id){
        $this->validate($request, [
            'old_password' => 'required',
            'new_password' => 'required|min:4|max:8|different:old_password',
            'confirm_password' => 'required|min:4|max:8|same:new_password',
        ]);
        $hotel_admin_id  = Auth::user()->id;

        $hoteladmin = HotelAdmin::find($hotel_admin_id);
        
        // create array to update in hotel admin table
        $hotel_admin_password_array = array(
            'password'=>Hash::make($request->input('password')),
            'org_password'=>$request->input('password'),
        );
        DB::table('tbl_hotel_admins')->where('id', $hotel_admin_id->id)->update($hotel_admin_password_array);

        //create array to update password in users table
        $user_password_array = array(
            'password'=>Hash::make($request->input('password')),
        );
        DB::table('users')->where('id', $hotel_admin_id->main_user_id)->update($user_password_array);
    
        //get updated hotel admin details
        $updated_hoteladmins = DB::table('tbl_hotel_admins')->where('main_user_id',$hoteladmin->id)->first();
        return view('dashboard.profilesettings.create', [ 'hoteladmin' => $updated_hoteladmins ]);
    }
}
