<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use App\Models\Properties;
use App\Models\Room;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use App\Models\Staffs;
use App\Models\RoomTypes;
use Illuminate\Validation\Rule;
use DataTables;
use File;

class RoomController extends Controller
{
    public function index(Request $request){
        $datas = $request->all();
        $main_id = '';
        if(Auth::user()->user_type == 3){
            $main_id = Auth::user()->id;
        } else if(Auth::user()->user_type == 4){
            $staff_info = Staffs::where('email',Auth::user()->email)->first();
            $staff_property_info = DB::table('staff_assigned_properties')->where('staff_id',$staff_info->id)->get();
            // echo "<pre>";print_r($staff_property_info);exit;
        }
        
        if(Auth::user()->user_type == 4 || Auth::user()->user_type == 6){//4 = hotel admin staff , 6=govt admin staff ){//4 = hotel admin staff

            //get staff info for group 
            $getGroup = DB::table('staffs')->select('group_id')->where('main_user_id', Auth::user()->id)->first();
            
            //get groups and privileges
            $getPrivileges = DB::table('groups_privileges')->where('group_id', $getGroup->group_id)->where('module_id','4')->first();//module_id = 5(Only customer module)

        } else {
            $getPrivileges = array();
        }

        if ($request->ajax()) {
            if($main_id){
                $dataq = DB::table('rooms')->select('rooms.*','room_types.title as type','properties.name as property_name')->where('rooms.created_by',$main_id)->where('rooms.deleted_at',null)->orderBy('rooms.id','desc');
                $dataq->join('room_types','room_types.id','=','rooms.room_type','left');
                $dataq->join('properties','properties.id','=','rooms.property_id','left');

            } else {
                $data = DB::table('rooms')->select('rooms.*','room_types.title as type','properties.name as property_name')->where('rooms.property_id',$staff_property_info[0]->property_id)->where('rooms.deleted_at',null)->orderBy('rooms.id','desc');
                $dataq->join('room_types','room_types.id','=','rooms.room_type','left');
                $dataq->join('properties','properties.id','=','rooms.property_id','left');

            }
            // if($main_id){
            //      $dataq = DB::table('rooms')->select('rooms.*','room_types.title as type')->where('rooms.created_by',$main_id)->orderBy('rooms.id','desc');
            //      $dataq->join('room_types','room_types.id','=','rooms.room_type','left');

            // } else {
            //      $data = DB::table('rooms')->select('rooms.*','room_types.title as type')->where('rooms.property_id',$staff_property_info[0]->property_id)->where('rooms.deleted_at',null)->orderBy('rooms.id','desc');
            //      $dataq->join('room_types','room_types.id','=','rooms.room_type','left');
     
            // }


            $data = $dataq->get();
           
                foreach($data as $room){
                    $id = $room->id;
                    if($room->status == 1){
                        $room->status = 'Active';
                    } else {
                        $room->status = 'In-Active';
                    }
                }

                if(!empty($getPrivileges)){
                    if($getPrivileges->edit ==1 && $getPrivileges->delete ==1){ //allow delete and edit access
                        $action =  '<a href="/rooms/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="cil-pencil" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="cil-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
                    } else if($getPrivileges->edit ==1 && $getPrivileges->delete !=1){//allow edit access
                        $action = '<a href="/rooms/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="cil-pencil" style="font-size: 20px;"></i></a>';
                    } else if($getPrivileges->delete == 1 && $getPrivileges->edit != 1){
                        $action = '<button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="cil-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
                    } else {
                        $action =  '';
                    }
                } else {
                    $action =  '<a href="/rooms/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="cil-pencil" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="cil-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
                }

                return Datatables::of($data)
                        ->addColumn('action', $action)
                        // ->addColumn('action', '<a href="/rooms/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>')
                        ->rawColumns(['action'])
                        ->make(true);
        }
        return view('dashboard.rooms.roomsList',['privileges'=>$getPrivileges]);
    }

     /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        // $statuses = Status::all();
        $main_id = Auth::user()->id ;
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        // $pbx_extensions = DB::table('pbx_extensions')->select('*')->orderBy('id','desc')->whereNull('deleted_at')->where('created_by',Auth::user()->id)->get();

        // Get all extensions
        $pbx_extensions = DB::table('pbx_extensions')
            ->leftJoin('rooms', 'pbx_extensions.id', '=', 'rooms.extension')
            ->select(
                'pbx_extensions.id',
                'pbx_extensions.extension',
                'pbx_extensions.title',
                'rooms.id as room_id',
                'rooms.title as room_title',
                'rooms.deleted_at'
            )
            ->whereNull('pbx_extensions.deleted_at')
            ->where('pbx_extensions.created_by', Auth::user()->id)
            ->orderBy('pbx_extensions.id','ASC')
            ->get();
            
        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();    
        $room_type = RoomTypes::where('created_by',Auth::user()->id)->get();    
        
        return view('dashboard.rooms.create',['properties'=>$properties,'room_type'=>$room_type,'pbx_extensions'=>$pbx_extensions]);
    }

   /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'title'      => 'required|min:1|max:64',
            'property_id'      => 'required',
            'description'       => 'required|min:1|max:64',
            'room_type'       => 'required',
            // 'extension' => 'required',
            'extension'      => ['required',
                Rule::unique('rooms')->whereNull('deleted_at')
            ],
        ]);

        //remove if extension is asigned to another rrom
        DB::table('rooms')
        ->where('extension', $request->input('extension'))
        ->whereNull('deleted_at')
        ->where('created_by',Auth::user()->id)
        ->update(['extension' => null]);

        //insert new room
        $room = new Room();
        $room->title    = $request->input('title');
        $room->property_id    = $request->input('property_id');
        $room->description   =  $request->input('description');
        $room->room_type   =  $request->input('room_type');
        $room->status   =  $request->input('status');
        $room->remark   =  $request->input('remark');
        $room->extension   =  $request->input('extension');
        $room->welcome_msg   =  $request->input('welcome_msg');
        $room->room_service_url   =  $request->input('room_service_url');
        if( $room->status == 1){
        } else {
            $room->reason_for_inactive =  $request->input('reason_for_inactive');
        }
        $room->created_by   = Auth::user()->id;
        $room->save();
        $room_id = $room->id;

        $hotel_admin_id = Auth::user()->id;
        $topath = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id.'/rooms/'.$room_id);
        if(!File::isDirectory($topath)){
            File::makeDirectory($topath, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/rooms/'.$room_id.'/wifi_qr', 0777, true, true);
             File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/rooms/'.$room_id.'/room_qr', 0777, true, true);
        }
        $wifiqrfileNameToStore = '';
        $roomqrfileNameToStore = '';
        if ($request->hasFile('wifi_qr_code')) {
            // Get filename with the extension
            $wifiqrfilenameWithExt = $request->file('wifi_qr_code')->getClientOriginalName();
            // Get Filename
            $custDocfilename = pathinfo($wifiqrfilenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $wifiqrextension = $request->file('wifi_qr_code')->getClientOriginalExtension();
            $wifiqrfileNameToStore = 'Wifi_qr_'. time().'.'.$wifiqrextension;
            $wifiqr = $request->file('wifi_qr_code')->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/rooms'.'/'.$room_id.'/wifi_qr',$wifiqrfileNameToStore);
        }
        if ($request->hasFile('room_service_qr_code')) {
            // Get filename with the extension
            $roomqrfilenameWithExt = $request->file('room_service_qr_code')->getClientOriginalName();
            // Get Filename
            $custDocfilename = pathinfo($roomqrfilenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $roomqrextension = $request->file('room_service_qr_code')->getClientOriginalExtension();
            $roomqrfileNameToStore = 'room_qr_'. time().'.'.$roomqrextension;
            $roomqr = $request->file('room_service_qr_code')->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/rooms'.'/'.$room_id.'/room_qr',$roomqrfileNameToStore);
        }
        $qr_arr = array(
            'wifi_qr_code'=>$wifiqrfileNameToStore,
            'room_service_qr_code' => $roomqrfileNameToStore
        );
        // echo "<pre>";print_r($cust_docs_arr);exit;
        $uploadqr = DB::table('rooms')->where('id',$room_id)->update($qr_arr);
   
        $request->session()->flash('message', 'Room Created Successfully.');
        return redirect()->route('rooms.index');
    }

    //for editing hotel admin
    public function edit($id)
    {
        $room = Room::find($id);
        $main_id = Auth::user()->id ;
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();

        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();    
        $room_type = RoomTypes::where('created_by',Auth::user()->id)->get();    
        // $pbx_extensions = DB::table('pbx_extensions')->select('*')->orderBy('id','desc')->where('created_by',Auth::user()->id)->whereNull('deleted_at')->get();
        // $pbx_extensions = DB::table('pbx_extensions')
        //     ->leftJoin('rooms', 'pbx_extensions.extension', '=', 'rooms.extension')
        //     ->select('pbx_extensions.*')
        //     ->whereNull('pbx_extensions.deleted_at')
        //      ->whereNotExists(function ($query) use ($id) {
        //         $query->select(DB::raw(1))
        //           ->from('rooms')
        //           ->whereColumn('rooms.extension', 'pbx_extensions.id')
        //           ->whereNull('rooms.deleted_at') // Only consider rooms that are not deleted
        //           ->where('id','!=',$id);
        //         })
        //     ->where('pbx_extensions.created_by', Auth::user()->id)
        //     ->orderBy('pbx_extensions.id', 'desc')
        //     ->get();

        // Get all extensions
        $pbx_extensions = DB::table('pbx_extensions')
            ->leftJoin('rooms', 'pbx_extensions.id', '=', 'rooms.extension')
            ->select(
                'pbx_extensions.id',
                'pbx_extensions.extension',
                'pbx_extensions.title',
                'rooms.id as room_id',
                'rooms.title as room_title',
                'rooms.deleted_at'
            )
            ->whereNull('pbx_extensions.deleted_at')
            ->where('pbx_extensions.created_by', Auth::user()->id)
            ->orderBy('pbx_extensions.id','ASC')
            ->get();
            
        return view('dashboard.rooms.edit', ['properties'=>$properties, 'room' => $room ,'room_type'=>$room_type,'pbx_extensions'=>$pbx_extensions]);
    }

   /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'title'      => 'required|min:1|max:64',
            'property_id'      => 'required',
            'description'       => 'required|min:1|max:64',
            'room_type'       => 'required',
            // 'extension'   => 'required',
             'extension'      => ['required',
                Rule::unique('rooms')->whereNull('deleted_at')
                ->ignore($id),
            ],
        ]);
        
          //remove if extension is asigned to another rrom
        DB::table('rooms')
        ->where('id','!=',$id)
        ->where('extension', $request->input('extension'))
        ->whereNull('deleted_at')
        ->where('created_by',Auth::user()->id)
        ->update(['extension' => null]);

    //   echo "<pre>";print_r($request->all());exit;

        //insert new room
        $room = Room::find($id);
        $room->title    = $request->input('title');
        $room->property_id    = $request->input('property_id');
        $room->description   =  $request->input('description');
        $room->room_type   =  $request->input('room_type');
        $room->status   =  $request->input('status');
        $room->remark   =  $request->input('remark');
        $room->extension   =  $request->input('extension');
        $room->welcome_msg   =  $request->input('welcome_msg');
        if( $room->status == 1){
        } else {
            $room->reason_for_inactive =  $request->input('reason_for_inactive');
        }
        
        $room->room_service_url   =  $request->input('room_service_url');
        
        $hotel_admin_id = Auth::user()->id;
        $topath = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id.'/rooms/'.$id);
        if(!File::isDirectory($topath)){
            File::makeDirectory($topath, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/rooms/'.$id.'/wifi_qr', 0777, true, true);
             File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/rooms/'.$id.'/room_qr', 0777, true, true);
        }
        $wifiqrfileNameToStore = '';
        $roomqrfileNameToStore = '';
        if ($request->hasFile('wifi_qr_code')) {
            // Get filename with the extension
            $wifiqrfilenameWithExt = $request->file('wifi_qr_code')->getClientOriginalName();
            // Get Filename
            $custDocfilename = pathinfo($wifiqrfilenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $wifiqrextension = $request->file('wifi_qr_code')->getClientOriginalExtension();
            $wifiqrfileNameToStore = 'Wifi_qr_'. time().'.'.$wifiqrextension;
            $wifiqr = $request->file('wifi_qr_code')->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/rooms'.'/'.$id.'/wifi_qr',$wifiqrfileNameToStore);
            $room->wifi_qr_code   =  $wifiqrfileNameToStore;
        
        }
       
        if($request->hasFile('room_service_qr_code')) {
            // Get filename with the extension
            $roomqrfilenameWithExt = $request->file('room_service_qr_code')->getClientOriginalName();
            // Get Filename
            $custDocfilename = pathinfo($roomqrfilenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $roomqrextension = $request->file('room_service_qr_code')->getClientOriginalExtension();
            $roomqrfileNameToStore = 'room_qr_'. time().'.'.$roomqrextension;
            $roomqr = $request->file('room_service_qr_code')->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/rooms'.'/'.$id.'/room_qr',$roomqrfileNameToStore);
            $room->room_service_qr_code   =  $roomqrfileNameToStore;
        
        }
        $room->save();

        $request->session()->flash('message', 'Room Updated Successfully');
        return redirect()->route('rooms.index');
    }

        /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $room = Room::find($id);
        if($room){
            $room->delete();
        }
        return redirect()->route('rooms.index');
    }
    
}

