<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use App\Models\Properties;
use App\Models\Room;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use App\Models\Staffs;
use App\Models\Country;
use App\Models\PaymentMethod;
use DataTables;

class ReportsController extends Controller
{
    public function checkinreport(Request $request){ 
    
        $datas = $request->all();
        // echo "<pre>";print_r($datas);exit;
        $main_id = '';
        $main_id = Auth::user()->id;
        if(empty($datas)){
            $currdate = date('Y-m-d');
        } else {
            $currdate = $datas['from_date'];
        }
        if ($request->ajax()) {
            $dataq = DB::table('customers')->select('customers.property_id', 'customers.id','customers.full_name','customers.first_name','customers.last_name','customers.guest_code','customers.nationality','customers.checkin_date_time','customers.checkout_date_time','customers.room_id','countries.name as country_name','rooms.title as room_title')->orderBy('customers.id','desc')->where('customers.deleted_at',null);
                $dataq->join('rooms','rooms.id','=','customers.room_id','left');
                $dataq->join('countries','countries.id','=','customers.nationality','left');
                $dataq->where('customers.checkin_date_time', 'like', '%' . $currdate . '%');
            if(Auth::user()->user_type != '1'){
                $dataq->where('customers.created_by',Auth::user()->id);
            }
            $data = $dataq->get();
            $final_customer = array();
            foreach($data as $customer){
                $id = $customer->id;
    
                $customer->full_name =  $customer->first_name.' '.$customer->last_name;
                $room_details = Room::find($customer->room_id);
                
                if($customer->room_id){
                    $customer->room_id =  $room_details->title;
                } else {
                    $customer->room_id =  '';
                }
                $customer->nationality = $customer->country_name;
                $final_customer[] =  $customer;
            }
            return Datatables::of($data)
                ->rawColumns(['action'])
                ->make(true);
        }
        return view('dashboard.reports.checkinreport');
    }

    public function inhousereport(Request $request){ 
    
        $datas = $request->all();
        // echo "<pre>";print_r($datas);exit;
        $main_id = '';
        $main_id = Auth::user()->id;
        if(empty($datas)){
            $currdate = date('Y-m-d');
        } else {
            $currdate = $datas['from_date'];
        }
        if ($request->ajax()) {
            $dataq = DB::table('customers')->select('customers.property_id', 'customers.id','customers.full_name','customers.first_name','customers.last_name','customers.guest_code','customers.nationality','customers.checkin_date_time','customers.checkout_date_time','customers.room_id','countries.name as country_name','rooms.title as room_title')->orderBy('customers.id','desc')->where('customers.deleted_at',null);
                $dataq->join('rooms','rooms.id','=','customers.room_id','left');
                $dataq->join('countries','countries.id','=','customers.nationality','left');
                $dataq->where('customers.checkin_date_time', 'like', '%' . $currdate . '%');
            if(Auth::user()->user_type != '1'){
                $dataq->where('customers.created_by',Auth::user()->id);
            }
            $data = $dataq->get();
            $final_customer = array();
            foreach($data as $customer){
                $id = $customer->id;
    
                $customer->full_name =  $customer->first_name.' '.$customer->last_name;
                $room_details = Room::find($customer->room_id);
                
                if($customer->room_id){
                    $customer->room_id =  $room_details->title;
                } else {
                    $customer->room_id =  '';
                }
                $customer->nationality = $customer->country_name;
                $final_customer[] =  $customer;
            }
            return Datatables::of($data)
                ->rawColumns(['action'])
                ->make(true);
        }
        return view('dashboard.reports.inhousereport');
    }

    /* load the customers document info */
    public function show(Request $request)
    {
        $data = $request->all();
        if(!empty($data)  &&  $data['type'] == 'checkinreportexport'){ //for customers export
            $export_file =  $this->checkinreportexport($data);
            return $export_file;
        } else if(!empty($data)  &&  $data['type'] == 'inhouseguestreportexport'){ //for customers export
            $export_file =  $this->inhouseguestreportexport($data);
            return $export_file;
        } else if(!empty($data)  &&  $data['type'] == 'checkoutguestreportexport'){ //for customers export
            $export_file =  $this->checkoutguestreportexport($data);
            return $export_file;
        }
    }

    public function checkinreportexport($data){
        $headers = [                 
            'Cache-Control'       => 'must-revalidate, post-check=0, pre-check=0',
            'Content-type'        => 'text/x-csv',
            'Content-Disposition' => 'attachment; filename=galleries.csv',
            'Expires'             => '0',
            'Pragma'              => 'public',
        ];

        $main_id = '';
        $main_id = Auth::user()->id;
        if(empty($data)){
            $currdate = date('Y-m-d');
        } else {
            $currdate = $data['from_date'];
        }
        $dataq = DB::table('customers')->select('customers.last_name','customers.visa_expiry_date', 'customers.other_id_type', 'customers.other_id_number', 'customers.other_id_expiry_date', 'customers.confirm_checkin' ,'customers.visa_issue_date', 'customers.visa_number','customers.id','customers.full_name','customers.guest_code','customers.nationality','customers.checkin_date_time','customers.checkout_date_time','customers.room_id','countries.name as country_name','rooms.title as room_title')->orderBy('customers.id','desc')->where('customers.deleted_at',null);

        // $dataq = DB::table('customers')->select('customers.property_id', 'customers.id','customers.full_name','customers.first_name','customers.last_name','customers.guest_code','customers.nationality','customers.checkin_date_time','customers.checkout_date_time','customers.room_id','countries.name as country_name','rooms.title as room_title')->orderBy('customers.id','desc')->where('customers.deleted_at',null);
            $dataq->join('rooms','rooms.id','=','customers.room_id','left');
            $dataq->join('countries','countries.id','=','customers.nationality','left');
            $dataq->where('customers.checkin_date_time', 'like', '%' . $currdate . '%');
        if(Auth::user()->user_type != '1'){
            $dataq->where('customers.created_by',Auth::user()->id);
        }
        $data = $dataq->get();
        // echo "<pre>";print_r($data);exit;       
        foreach($data as $customer){
            //create full name 
            $customer->first_name =  $customer->full_name;
            $customer->full_name =  $customer->first_name.' '.$customer->last_name;
            //get room title
            $room_details = Room::find($customer->room_id);
            $customer->room_id =  $room_details->title;

            //get country title
            $country_title = Country::find($customer->nationality);
            $customer->nationality = $country_title->name;
            
            //get customer id
            $id = $customer->id;
        }
        
        $columns = array('Name','Guest Code', 'Room', 'Nationality', 'CheckIn DateTime', 'CheckoutDateTime','Visa Number','Visa Issue Date','visa Expiry Date','Other ID Type','Other ID NUmber','Other ID Expiry Date','Confirmed Checkin');
        $callback = function() use ($data, $columns)
        {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);
                                            
            foreach($data as $cust) { 
                $name = $cust->full_name;
                fputcsv($file, array($name,$cust->guest_code, $cust->room_id, $cust->nationality, $cust->checkin_date_time, $cust->checkout_date_time,$cust->visa_number,$cust->visa_issue_date,$cust->visa_expiry_date,$cust->other_id_type,$cust->other_id_number,$cust->other_id_expiry_date,$cust->confirm_checkin));
            }
            fclose($file);
        };
        return response()->streamDownload($callback, 'Check in Guests Report-' . date('d-m-Y-H:i:s').'.csv', $headers);
    }

    public function inhouseguestreport(Request $request){ 
    
        $datas = $request->all();
        // echo "<pre>";print_r($datas);exit;
        $main_id = '';
        $main_id = Auth::user()->id;
        if(empty($datas)){
            $fromdate = date('Y-m-d');
            $todate = date('Y-m-d');
        } else {
            $fromdate = $datas['from_date'];
            $todate = $datas['to_date'];
        }

        if ($request->ajax()) {
            $dataq = DB::table('customers')->select('customers.property_id', 'customers.id','customers.full_name','customers.first_name','customers.last_name','customers.guest_code','customers.nationality','customers.checkin_date_time','customers.checkout_date_time','customers.room_id','countries.name as country_name','rooms.title as room_title')->orderBy('customers.id','desc')->where('customers.deleted_at',null);
                $dataq->join('rooms','rooms.id','=','customers.room_id','left');
                $dataq->join('countries','countries.id','=','customers.nationality','left');
                $dataq->where('customers.checkin_date_time', 'like', '%' . $fromdate . '%');

                $dataq->where('customers.checkin_date_time','!=','')->where('customers.checkout_date_time','')->orWhere('customers.checkout_date_time','=',NULL);

                $fromd = date('Y-m-d',strtotime($fromdate));
                $post_start_date =  \Carbon\Carbon::parse($fromd);
                 
                $tod = date('Y-m-d',strtotime($todate));
                $post_end_date =  \Carbon\Carbon::parse($todate);

                $dataq->where('customers.checkin_date_time','!=','')->whereBetween('customers.checkin_date_time', [$post_start_date, $post_end_date]);

            if(Auth::user()->user_type != '1'){
                $dataq->where('customers.created_by',Auth::user()->id);
            }
            $data = $dataq->get();
            $final_customer = array();
            foreach($data as $customer){
                $id = $customer->id;
    
                $customer->full_name =  $customer->first_name.' '.$customer->last_name;
                $room_details = Room::find($customer->room_id);
                
                if($customer->room_id){
                    $customer->room_id =  $room_details->title;
                } else {
                    $customer->room_id =  '';
                }
                $customer->nationality = $customer->country_name;
                $final_customer[] =  $customer;
            }
            return Datatables::of($data)
                ->rawColumns(['action'])
                ->make(true);
        }
        return view('dashboard.reports.inhouseguestreport');
    }
    
    public function inhouseguestreportexport($data){
        $headers = [                 
            'Cache-Control'       => 'must-revalidate, post-check=0, pre-check=0',
            'Content-type'        => 'text/x-csv',
            'Content-Disposition' => 'attachment; filename=galleries.csv',
            'Expires'             => '0',
            'Pragma'              => 'public',
        ];

        $main_id = '';
        $main_id = Auth::user()->id;

        $fromdate = $data['from_date'];
        $todate = $data['to_date'];
      
        $dataq = DB::table('customers')->select('customers.last_name','customers.visa_expiry_date', 'customers.other_id_type', 'customers.other_id_number', 'customers.other_id_expiry_date', 'customers.confirm_checkin' ,'customers.visa_issue_date', 'customers.visa_number','customers.id','customers.full_name','customers.guest_code','customers.nationality','customers.checkin_date_time','customers.checkout_date_time','customers.room_id','countries.name as country_name','rooms.title as room_title')->orderBy('customers.id','desc')->where('customers.deleted_at',null);
        $dataq->join('rooms','rooms.id','=','customers.room_id','left');
        $dataq->join('countries','countries.id','=','customers.nationality','left');
        $dataq->where('customers.checkin_date_time', 'like', '%' . $fromdate . '%');

        $dataq->where('customers.checkin_date_time','!=','')->where('customers.checkout_date_time','')->orWhere('customers.checkout_date_time','=',NULL);

        $fromd = date('Y-m-d',strtotime($fromdate));
        $post_start_date =  \Carbon\Carbon::parse($fromd);
         
        $tod = date('Y-m-d',strtotime($todate));
        $post_end_date =  \Carbon\Carbon::parse($todate);

        $dataq->where('customers.checkin_date_time','!=','')->whereBetween('customers.checkin_date_time', [$post_start_date, $post_end_date]);

        if(Auth::user()->user_type != '1'){
            $dataq->where('customers.created_by',Auth::user()->id);
        }
        $data = $dataq->get();
        // echo "<pre>";print_r($data);exit;       
        foreach($data as $customer){
            //create full name 
            $customer->first_name =  $customer->full_name;
            $customer->full_name =  $customer->first_name.' '.$customer->last_name;
            //get room title
            $room_details = Room::find($customer->room_id);
            $customer->room_id =  $room_details->title;

            //get country title
            $country_title = Country::find($customer->nationality);
            $customer->nationality = $country_title->name;
            
            //get customer id
            $id = $customer->id;
        }
        
        $columns = array('Name','Guest Code', 'Room', 'Nationality', 'CheckIn DateTime', 'CheckoutDateTime','Visa Number','Visa Issue Date','visa Expiry Date','Other ID Type','Other ID NUmber','Other ID Expiry Date','Confirmed Checkin');
        $callback = function() use ($data, $columns)
        {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);
                                            
            foreach($data as $cust) { 
                $name = $cust->full_name;
                fputcsv($file, array($name,$cust->guest_code, $cust->room_id, $cust->nationality, $cust->checkin_date_time, $cust->checkout_date_time,$cust->visa_number,$cust->visa_issue_date,$cust->visa_expiry_date,$cust->other_id_type,$cust->other_id_number,$cust->other_id_expiry_date,$cust->confirm_checkin));
            }
            fclose($file);
        };
        return response()->streamDownload($callback, 'In House Guests Report-' . date('d-m-Y-H:i:s').'.csv', $headers);
    }

    public function checkoutguestsreport(Request $request){ 
    
        $datas = $request->all();
        // echo "<pre>";print_r($datas);exit;
        DB::enableQueryLog();

// and then you can get query log
        $main_id = '';
        $main_id = Auth::user()->id;
        if(empty($datas)){
            $fromdate = date('Y-m-d'); 
            $todate = date('Y-m-d');
            $todays= '1';
        } else {
            $fromdate = $datas['from_date'];
            $todate = $datas['to_date'];
            $todays = '0';
        }
        // echo "<pre>";print_r($fromdate.' - '.$todate);exit;

        if ($request->ajax()) {
            $dataq = DB::table('customers')->select('customers.id','customers.first_name','customers.last_name','customers.guest_code','customers.nationality','customers.checkin_date_time','customers.checkout_date_time','customers.room_id','countries.name as country_name','rooms.title as room_title','properties.name as property_name')->orderBy('customers.id','desc')->where('customers.deleted_at',null);
                $dataq->join('rooms','rooms.id','=','customers.room_id','left');
                $dataq->join('countries','countries.id','=','customers.nationality','left');
                $dataq->join('properties','properties.id','=','customers.property_id','left');

                $dataq->where('customers.checkout_date_time','!=','')->orWhere('customers.checkout_date_time','!=',NULL);

                $fromd = date('Y-m-d',strtotime($fromdate));
                $post_start_date =  \Carbon\Carbon::parse($fromd);
                 
                $tod = date('Y-m-d',strtotime($todate));
                $post_end_date =  \Carbon\Carbon::parse($todate);

                if($fromdate == date('Y-m-d')){ 
                    $dataq->where('customers.checkout_date_time', 'like', '%' .$post_start_date . '%');
                } else {
                    $dataq->whereBetween('customers.checkout_date_time', [$post_start_date, $post_end_date]);
                }

            if(Auth::user()->user_type != '1'){
                $dataq->where('customers.created_by',Auth::user()->id);
            }
            $data = $dataq->get();
// dd(DB::getQueryLog());exit;

            $final_customer = array();
            foreach($data as $key => $customer){
                $id = $customer->id;
    
                $customer->full_name =  $customer->first_name.' '.$customer->last_name;
                $room_details = Room::find($customer->room_id);
                
                if($customer->room_id){
                    $customer->room_id =  $room_details->title;
                } else {
                    $customer->room_id =  '';
                }
                $customer->nationality = $customer->country_name;

                // echo $customer->checkout_date_time.' = '.$post_start_date.' = '.$customer->checkout_date_time.' = '.$post_end_date;exit;;
                
                if($customer->checkout_date_time >= $post_start_date && $customer->checkout_date_time <= $post_end_date){
                   
                } else {
                    unset($data[$key]);
                }
            }
            return Datatables::of($data)
                ->rawColumns(['action'])
                ->make(true);
        }
        return view('dashboard.reports.checkoutguestsreport');
    }
    
    public function checkoutguestreportexport($data){
        $headers = [                 
            'Cache-Control'       => 'must-revalidate, post-check=0, pre-check=0',
            'Content-type'        => 'text/x-csv',
            'Content-Disposition' => 'attachment; filename=galleries.csv',
            'Expires'             => '0',
            'Pragma'              => 'public',
        ];

        $main_id = '';
        $main_id = Auth::user()->id;
     
        $fromdate = $data['from_date'];
        $todate = $data['to_date'];
      
        $dataq = DB::table('customers')->select('customers.last_name','customers.visa_expiry_date', 'customers.other_id_type', 'customers.other_id_number', 'customers.other_id_expiry_date', 'customers.confirm_checkin' ,'customers.visa_issue_date', 'customers.visa_number','customers.id','customers.full_name','customers.guest_code','customers.nationality','customers.checkin_date_time','customers.checkout_date_time','customers.room_id','countries.name as country_name','rooms.title as room_title','properties.name as property_name')->orderBy('customers.id','desc')->where('customers.deleted_at',null);
        $dataq->join('rooms','rooms.id','=','customers.room_id','left');
            $dataq->join('countries','countries.id','=','customers.nationality','left');
            $dataq->join('properties','properties.id','=','customers.property_id','left');
            $dataq->where('customers.checkout_date_time','!=','')->orWhere('customers.checkout_date_time','!=',NULL);

            $fromd = date('Y-m-d',strtotime($fromdate));
            $post_start_date =  \Carbon\Carbon::parse($fromd);
                
            $tod = date('Y-m-d',strtotime($todate));
            $post_end_date =  \Carbon\Carbon::parse($todate);

            $dataq->where('customers.checkout_date_time','!=','')->whereBetween('customers.checkout_date_time', [$post_start_date, $post_end_date]);

        if(Auth::user()->user_type != '1'){
            $dataq->where('customers.created_by',Auth::user()->id);
        }
        $data = $dataq->get();
        // echo "<pre>";print_r($data);exit;       
        foreach($data as $key => $customer){
            //create full name 
            $customer->first_name =  $customer->full_name;
            $customer->full_name =  $customer->first_name.' '.$customer->last_name;
            //get room title
            $room_details = Room::find($customer->room_id);
            $customer->room_id =  $room_details->title;

            //get country title
            $country_title = Country::find($customer->nationality);
            $customer->nationality = $country_title->name;
            
            //get customer id
            $id = $customer->id;

            if($customer->checkout_date_time >= $post_start_date && $customer->checkout_date_time <= $post_end_date){
                   
            } else {
                unset($data[$key]);
            }
        }
        
        $columns = array('Name','Guest Code','Property', 'Room', 'Nationality', 'CheckIn DateTime', 'CheckoutDateTime','Visa Number','Visa Issue Date','visa Expiry Date','Other ID Type','Other ID NUmber','Other ID Expiry Date','Confirmed Checkin');
        $callback = function() use ($data, $columns)
        {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);
                                            
            foreach($data as $cust) { 
                $name = $cust->full_name;
                fputcsv($file, array($name,$cust->guest_code, $cust->property_name, $cust->room_id, $cust->nationality, $cust->checkin_date_time, $cust->checkout_date_time,$cust->visa_number,$cust->visa_issue_date,$cust->visa_expiry_date,$cust->other_id_type,$cust->other_id_number,$cust->other_id_expiry_date,$cust->confirm_checkin));
            }
            fclose($file);
        };
        return response()->streamDownload($callback, 'Check Out Guests Report-' . date('d-m-Y-H:i:s').'.csv', $headers);
    }

    public function collectionreport(Request $request){ 
        $datas = $request->all();
        // echo "<pre>";print_r($datas);exit;
        $main_id = '';
        $main_id = Auth::user()->id;
        $paymentmethods = PaymentMethod::select('id','title')->where('created_by', Auth::user()->id)->where('deleted_at',null)->get();

        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();
        return view('dashboard.reports.collectionreport',['properties'=>$properties,'paymentmethods' => $paymentmethods]);
    }


    public function collectionsummaryreport(Request $request){ 
        $datas = $request->all();
        // echo "<pre>";print_r($datas);exit;
        $main_id = '';
        $main_id = Auth::user()->id;
        $paymentmethods = PaymentMethod::select('id','title')->where('created_by', Auth::user()->id)->where('deleted_at',null)->get();

        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();
        return view('dashboard.reports.collectionsummaryreport',['properties'=>$properties,'paymentmethods' => $paymentmethods]);
    }

    public function commercialcollectionreport(Request $request){ 
        $datas = $request->all();
        // echo "<pre>";print_r($datas);exit;
        $main_id = '';
        $main_id = Auth::user()->id;
        $paymentmethods = PaymentMethod::select('id','title')->where('created_by', Auth::user()->id)->where('deleted_at',null)->get();

        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();
        return view('dashboard.reports.commercialcollectionreport',['properties'=>$properties,'paymentmethods' => $paymentmethods]);
    }


    public function commercialcollectionsummaryreport(Request $request){ 
        $datas = $request->all();
        // echo "<pre>";print_r($datas);exit;
        $main_id = '';
        $main_id = Auth::user()->id;
        $paymentmethods = PaymentMethod::select('id','title')->where('created_by', Auth::user()->id)->where('deleted_at',null)->get();

        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();
        return view('dashboard.reports.commercialcollectionsummaryreport',['properties'=>$properties,'paymentmethods' => $paymentmethods]);
    }
}

