<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use App\Models\Groups;
use App\Models\Modules;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use DataTables;

class PrivilegesController extends Controller
{
    //for editing groups
    public function edit($id)
    {   
        $group = Groups::find($id);
        $modules = Modules::all()->where('created_by','!=','1');
        return view('dashboard.groups.editPrivileges', [ 'group' => $group,'modules'=>$modules]);
    }
    
    /*
      update the privilages of groups
    */
    public function update(Request $request, $id)
    {   

        $group = Groups::find($id);
        $modules = Modules::all(); 
        $all_data = $request->all();  
        if(array_key_exists('all',$all_data)){
            unset($all_data['all']);
        } 
        DB::table('groups_privileges')->where('group_id', $id)->delete();
        // $reversed = array_reverse($request->all(), true);
        foreach($all_data as $key => $mod){  
            if($key == '_token'){
              //do nothing
            } else if($key == '_method'){
             //do nothing
            } else if($key == 'check_all'){
             //do nothing
            } else if($key == 'all'){
                //do nothing
            } else {
                
                // echo "<pre>";print_r($request->all());exit;
                $data = $request->all();
                $privilege_array = array();
                
                if(strpos($key,'_') !== false){ 
                    $new_key = str_replace('_', ' ', $key);
                    $key = $new_key;
                }
                 
                $module_id_arr = Modules::select('id')->where('module_name','=',$key)->first();
                
                $module_id = $module_id_arr->id;
                $group_id = $id;
                $privilege_array['group_id'] = $id;
                $privilege_array['module_id'] = $module_id;
                /*
                   for every modile id here 
                   value 1 = VIEW PRIVILEGE
                   value 2 = ADD PRIVILEGE
                   value 3 = EDIT PRIVILEGE
                   value 4 = DELETE PRIVILEGE
                */
                $privilege ='';
                foreach($mod as $val){
                    if($val == 1){
                        $privilege_array['view'] = 1;
                    } else if($val == 2){
                        $privilege_array['add'] = 1;
                    }else if($val == 3){
                        $privilege_array['edit'] = 1;
                    } else if($val == 4) {
                        $privilege_array['delete'] = 1;
                    }  
                }
                 
                if(array_key_exists('add',$all_data)){
                    $add_key = 1;
                } else {
                    $add_key = 0;
                }
                if(array_key_exists('edit',$all_data)){
                    $edit_key = 1;
                } else {
                    $edit_key = 0;
                }
                if(array_key_exists('delete',$all_data)){
                    $delete_key = 1;
                } else {
                    $delete_key = 0;
                }
                
                if($privilege_array['view']==1 && $add_key && $edit_key && $delete_key){
                    $privilege_array['allow_all'] = 1;
                }
                // echo "<pre>";print_r($privilege_array);exit;
                // if()
                //check if row present for same group and module and edit accordingly
                $get_if_exists = DB::table('groups_privileges')
                                  ->select('id')
                                  ->where('group_id','=',$id)
                                  ->where('module_id','=',$module_id)
                                  ->orderBy('id','desc')
                                  ->first();
                                //   echo "<pre>";print_r($privilege_array);exit;
                //insert row
                
                DB::table('groups_privileges')->insert($privilege_array);

                // if(!empty($get_if_exists)){
                //     //edit row
                //     DB::table('groups_privileges')->where('id', $get_if_exists->id)->update($privilege_array);
                // } else {
                //     //insert row
                //     DB::table('groups_privileges')->insert($privilege_array);
                // }
            }
        }
        $request->session()->flash('message', 'Group Updated Successfully');
       return redirect()->route('groups.index');
    }
   
}
