<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use App\Models\PbxExtension;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use DataTables;
use Illuminate\Support\Facades\Http;
use App\Models\YeastarAccessInfo;

class PbxExtensionsController extends Controller
{
    public function index(Request $request){
        $main_id = Auth::user()->id;
  

        if ($request->ajax()) {
            $data = DB::table('pbx_extensions')->select('*')->orderBy('id','desc')->where('created_by',$main_id)->whereNull('deleted_at')->get();

            // $data = IdProofTypes::where('created_by',$main_id)->orderBy('id','desc')->get();
     
                foreach($data as $type){
                    $id = $type->id;
                }
                $action = '<a href="/pbxextensions/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="cil-pencil" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="cil-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';

                return Datatables::of($data)
                        ->addColumn('action',$action) 
                        ->rawColumns(['action'])
                        ->make(true);
        }
        return view('dashboard.pbxextensions.pbxextensionslist');
    }

    public function show(Request $request)
    {
        return view('dashboard.pbxextensions.create');
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
    */
    public function create()
    {
        return view('dashboard.pbxextensions.create');
    }
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'ip'      => 'required',
            'local_sip_extension'      => [
            'required',
                Rule::unique('pbx_extensions')->whereNull('deleted_at'),
            ],
            'title'      => 'required',
            'extension' => [
            'required',
                Rule::unique('pbx_extensions')->whereNull('deleted_at'),
            ],
            'password'       => 'required',
        ]);

        //insert new type
        $extension = new PbxExtension();
        $extension->ip   =  $request->input('ip');
        $extension->title    = $request->input('title');
        $extension->extension   =  $request->input('extension');
        $extension->password   =  $request->input('password');
        $extension->local_sip_extension   =  $request->input('local_sip_extension');
        $extension->created_by   = Auth::user()->id;
        $extension->save();
        $extension_id = $extension->id;
        
        //get accesss token and login sign for calling via yeastar
        $yeaster_access_and_refresh_tokens = self::getYeastarAccessToken($extension_id);
       
        if($yeaster_access_and_refresh_tokens){
            DB::table('yeastar_access_info')->insert($yeaster_access_and_refresh_tokens);
            // echo "<pre>";print_r($yeaster_access_and_refresh_tokens['access_token']);exit;
        
            $access_token = $yeaster_access_and_refresh_tokens['access_token'];
            $username = $extension->local_sip_extension;
            $login_sign = self::getYeastarLoginSign($extension_id,$access_token,$username);
            DB::table('pbx_extensions')->where('id',$extension_id)->update(['yeastar_login_sign'=> $login_sign]);
        }
        
        $request->session()->flash('message', 'PBX Extension Created Successfully.');
        return redirect()->route('pbxextensions.index');
    }
     
    //for editing hotel admin
    public function edit($id)
    {
        $extension = PbxExtension::find($id);
        return view('dashboard.pbxextensions.edit', [ 'extension' => $extension ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'ip'      => 'required',
            'local_sip_extension'      => ['required',
                Rule::unique('pbx_extensions')->whereNull('deleted_at')
                ->ignore($id),
            ],
            'title'      => 'required',
            'extension' => [
            'required',
                Rule::unique('pbx_extensions')
                    ->whereNull('deleted_at')
                    ->ignore($id), // Ignore current record
            ],
            'password'       => 'required',
        ]);

        //insert new type
        $extension = PbxExtension::find($id);
        $extension->ip   =  $request->input('ip');
        $extension->title    = $request->input('title');
        $extension->extension   =  $request->input('extension');
        $extension->password   =  $request->input('password');
        $extension->local_sip_extension   =  $request->input('local_sip_extension');
        $extension->save();
        
        $yeaster_access_and_refresh_tokens = self::getValidYeastarToken($id);
        //  echo "<pre>";print_r($yeaster_access_and_refresh_tokens);exit;
        //get accesss token and login sign for calling via yeastar
        // $yeaster_access_and_refresh_tokens = self::getYeastarAccessToken($id);
        // $yeaster_access_and_refresh_tokens = 1;
        if($yeaster_access_and_refresh_tokens){
            // DB::table('yeastar_access_info')->insert($yeaster_access_and_refresh_tokens);
            
            // $access_token = $yeaster_access_and_refresh_tokens['access_token'];
            // $access_token = 'hwj8XnrJqMKwRWaxm8cdBhRiRPqD1Hrz';
            $username = $extension->local_sip_extension;
           

            $login_sign = self::getYeastarLoginSign($id,$yeaster_access_and_refresh_tokens,$username);
            DB::table('pbx_extensions')->where('id',$id)->update(['yeastar_login_sign'=> $login_sign]);
            //  echo "<pre>";print_r($login_sign);exit;
        
        }
        $request->session()->flash('message', 'PBX Extension Updated Successfully');
        return redirect()->route('pbxextensions.index');
    }
    
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $extension = PbxExtension::find($id);
        if($extension){
            $extension->delete();
        }
        return redirect()->route('pbxextensions.index');
    }

    //get login sign for yeastar calling
    public function getYeastarAccessToken($extension_id){
        
        // $url = 'https://epenhtestpbx.thycm.yeastarcloud.com/openapi/v1.0/get_token';
        // $data = [
        //     'username' => 'Fvk1K5OS8uDv62h5ilTTDSYaBaS3Fvae',
        //     'password' => '2v6zoxqAFQ6igkrOfqY4WMJiNfWqZArd',
        //      'user_agent' => 'my_php_auth_script'
        // ];
        
        // Remote pbx
        $url = 'https://192.168.7.221:8088/openapi/v1.0/get_token';
        $data = [
            'username' => 'ywZ2Koh2Vo46lc89f7mwKXUr9EOsNapm',
            'password' => 'jWdhkmoBRYRlsAQ6r9TrI0PAhPNTpJTr',
             'user_agent' => 'my_php_auth_script'
        ];
        
        $ch = curl_init($url);
        
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'User-Agent: my_php_auth_script'
        ]);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        
        $response = curl_exec($ch);
        $accessToken = '';
        $refreshToken = '';
        // echo '<pre>';print_R($response);exit;
        if (curl_errno($ch)) {
            echo 'Curl error: ' . curl_error($ch);exit;
            return 0;
        } else {
            $decoded = json_decode($response, true);
            // echo "<pre>";print_r($decoded);exit;
            $accessToken = $decoded['access_token'];
            $refreshToken = $decoded['refresh_token'];
            return array(
                'access_token' => $accessToken,
                'refresh_token' => $refreshToken,
                'extension_id' => $extension_id
                );
            // echo 'Response: ' . $response;
        }
        curl_close($ch);
    }
    
    //get login sign for yeastar calling
    public function getYeastarLoginSign($extension_id,$access_token,$username){
     
        // $url = 'https://epenhtestpbx.thycm.yeastarcloud.com/openapi/v1.0/sign/create?access_token=' . $access_token;
        //  echo "<pre>";print_r($username);exit;
        //for remote pbx 
        $url = 'https://192.168.7.221:8088/openapi/v1.0/sign/create?access_token=' . $access_token;
        $data = [
            'username'    => $username,
            'sign_type'   => 'sdk',
            'expire_time' => 0,
        ];
        
        $ch = curl_init($url);
        
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
        ]);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        
        $response = curl_exec($ch);
        
        if (curl_errno($ch)) {
            // echo 'Curl error: ' . curl_error($ch);
            return 0;
        } else {
            $decoded = json_decode($response, true);
            //  echo "<pre>";print_r($decoded);exit;
            if (isset($decoded['errcode']) && $decoded['errcode'] === 0) {
                $sign = $decoded['data']['sign'];
                return $sign;
            } else {
                // echo "API Error: " . $decoded['errmsg'];
                return 0;
            }
        }
        curl_close($ch);
    }
    
    //check ext valid tokens 
    public function checkAllExtValidToken(Request $request){
        //add room login
        $data = $request->all();
        $getRoomInfo = DB::table('rooms')->where('id',$data['room_id'])->whereNull('deleted_at')->get()->first(); 
        
        $getAllExtension = DB::table('pbx_extensions as pe')
                            ->select('pe.id')
                            ->leftjoin('rooms as ro','ro.extension','pe.id')
                            ->where('pe.created_by',$getRoomInfo->created_by)
                            ->where('pe.id','<',8)
                            ->whereNull('ro.deleted_at')
                            ->get(); 
    
        foreach ($getAllExtension as $ext) {
            $token = self::getValidYeastarToken($ext->id); // Always gives a valid token
            $sign = self::generateLoginSign($token, $ext->id);
            DB::table('pbx_extensions')->where('id',$ext->id)->update(['yeastar_login_sign'  => $sign]);
        }
        return 1;
    }

    public function getValidYeastarToken($extension_id)
    {
        $tokenRecord = DB::table('yeastar_access_info')->where('extension_id', $extension_id)->first();
       if ($tokenRecord) {
            $created = strtotime($tokenRecord->created_at);
            $now = time();
            $expiresIn = $tokenRecord->access_token_expiry ?? 1800;
           
            // if (($created + $expiresIn - 300) > $now) {
            //     return $tokenRecord->access_token;
            // }
            // Try to refresh token
            $refreshData = self::refreshYeastarToken($tokenRecord->refresh_token);
            
            if (!empty($refreshData['access_token'])) {
                //   echo "<pre>";print_r($tokenRecord);exit;
      
                DB::table('yeastar_access_info')->where('extension_id', $extension_id)->update([
                    'access_token'        => $refreshData['access_token'],
                    'refresh_token'       => $refreshData['refresh_token'],
                    'access_token_expiry' => $refreshData['access_token_expire_time'],
                    'updated_at'          => now(),
                ]);
                // $tokenRecord->update([
                //     'access_token'        => $refreshData['access_token'],
                //     'refresh_token'       => $refreshData['refresh_token'],
                //     'access_token_expiry' => $refreshData['access_token_expire_time'],
                //     'updated_at'          => now(),
                //     'created_at'          => now(),
                // ]);
    
                return $refreshData['access_token'];
            }
        }
    
        // Fall back to login
        $newData = self::loginYeastarAccount($extension_id);
    
        return $newData['access_token'] ?? null;
    }

        public function refreshYeastarToken($refreshToken)
    {
        // $response = Http::withHeaders([
        //     'Content-Type' => 'application/json',
        //     'User-Agent'   => 'my_php_auth_script',
        // ])->post('https://epenhtestpbx.thycm.yeastarcloud.com/openapi/v1.0/get_token', [
        //     'refresh_token' => $refreshToken,
        //     'user_agent'    => 'my_php_auth_script',
        // ]);
        
        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
            'User-Agent'   => 'my_php_auth_script',
        ])->post('https://192.168.7.221:8088/openapi/v1.0/get_token', [
            'refresh_token' => $refreshToken,
            'user_agent'    => 'my_php_auth_script',
        ]);
        
        return $response->json();
    }
    
    
    public function generateLoginSign($accessToken, $extension)
    {
        $pbx_de = DB::table('pbx_extensions')->where('id',$extension)->get()->first();
        
        //  echo "<pre>";print_R($pbx_de->local_sip_extension);exit;
        // $response = Http::withHeaders([
        //     'Content-Type' => 'application/json',
        // ])->post("https://epenhtestpbx.thycm.yeastarcloud.com/openapi/v1.0/sign/create?access_token=$accessToken", [
        //     'username'   => $pbx_de->local_sip_extension,
        //     'sign_type'  => 'sdk',
        //     'expire_time'=> 0
        // ]);
        
         $response = Http::withHeaders([
            'Content-Type' => 'application/json',
        ])->post("https://192.168.7.221:8088/openapi/v1.0/sign/create?access_token=$accessToken", [
            'username'   => $pbx_de->local_sip_extension,
            'sign_type'  => 'sdk',
            'expire_time'=> 0
        ]);
        
        $data = $response->json();
       
        return $data['data']['sign'] ?? null;
    }
    
        public function loginYeastarAccount($extension_id)
    {
        // $response = Http::withHeaders([
        //     'Content-Type' => 'application/json',
        //     'User-Agent'   => 'my_php_auth_script',
        // ])->post('https://epenhtestpbx.thycm.yeastarcloud.com/openapi/v1.0/get_token', [
        //     'username'    => 'Fvk1K5OS8uDv62h5ilTTDSYaBaS3Fvae',
        //     'password'    => '2v6zoxqAFQ6igkrOfqY4WMJiNfWqZArd',
        //     'user_agent'  => 'my_php_auth_script',
        // ]);
        
        //for remote pbx 
        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
            'User-Agent'   => 'my_php_auth_script',
        ])->post('https://192.168.7.221:8088/openapi/v1.0/get_token', [
            'username'    => 'ywZ2Koh2Vo46lc89f7mwKXUr9EOsNapm',
            'password'    => 'jWdhkmoBRYRlsAQ6r9TrI0PAhPNTpJTr',
            'user_agent'  => 'my_php_auth_script',
        ]);
    
        $data = $response->json();
   
        if (!empty($data['access_token'])) {
            YeastarAccessInfo::updateOrCreate(
                ['extension_id' => $extension_id],
                [
                    'access_token'        => $data['access_token'],
                    'refresh_token'       => $data['refresh_token'],
                    'access_token_expiry' => $data['access_token_expire_time'],
                    'created_at'          => now(),
                    'updated_at'          => now(),
                ]
            );
        }
        return $data;
    }

}