<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use App\Models\Notifications;
use App\Models\Room;
use App\Models\Customers;
use App\Models\IdProofTypes;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use App\Models\Properties;
use Illuminate\Support\Facades\Storage;
use Google\Client as GoogleClient;
use DataTables;

class NotificationsController extends Controller
{
    public function index(Request $request)
    {
        $admin_id = auth()->id();
        $guest_id = $request->get('guest_id') ?? null; // optional
        $main_id = Auth::user()->id ;
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();

        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();    
    
        return view('dashboard.notifications.index', compact('properties', 'admin_id', 'guest_id'));
    }

    public function chatUI($property_id, $admin_id, $guest_id)
    {
        return view('chat', compact('property_id', 'admin_id', 'guest_id'));
    }

    public function getRoomsByPropertyId($property_id){
        
        $admin_id =  Auth::user()->id;
        // $hotelAdmin_id = HotelAdmin::where('main_user_id',$admin_id)->first();
        // echo "<pre>";print_r( $admin_id);exit;

        $rooms = Room::where('property_id', $property_id)
        ->orderBy('id','desc')->get(['id', 'title']);
      
        
        $roomsList = $rooms->map(function ($room) {
        $ar = array(1,$room->id);
        $admin_id =  Auth::user()->id;
        $custinfo = Customers::where('room_id',$room->id)->whereNull('checkout_date_time')->whereNull('deleted_at')->first();
            if(!empty($custinfo)){
                $title = $room->title.' ('.$custinfo->first_name.'  '.$custinfo->last_name.')';
            } else {
                $title = $room->title.' (No Guest)';
            }
            return [
                'id' => $room->id,
                'title' =>$title
            ];
        });
        return response()->json(['rooms' => $roomsList]);
    }

    public function getNotificationsByRoom(Request $request){
        $admin_id = auth()->id(); // or fixed value for now if not authenticated
        $hotelAdmin = HotelAdmin::where('main_user_id', $admin_id)->first();

        if (!$hotelAdmin) {
            return response()->json(['error' => 'Hotel Admin not found'], 404);
        }

        $adminDbId = $hotelAdmin->id;
        $customerId = $request->input('customer_id');
        $propertyId = $request->input('property_id');

        $messages = Notifications::where('property_id', $propertyId)
            ->where(function ($query) use ($adminDbId, $customerId) {
                $query->where(function ($q) use ($adminDbId, $customerId) {
                    $q->where('sender_id', $adminDbId)
                    ->where('receiver_id', $customerId)
                    ->where('sender_type', 'admin')
                    ->where('receiver_type', 'guest');
                })
                ->orWhere(function ($q) use ($adminDbId, $customerId) {
                    $q->where('sender_id', $customerId)
                    ->where('receiver_id', $adminDbId)
                    ->where('sender_type', 'guest')
                    ->where('receiver_type', 'admin');
                });
            })
            ->orderBy('created_at', 'asc')
            ->get();

        return response()->json(['messages' => $messages]);
    }

    public function notificationHistory(Request $request)
    {
        $request->validate([
            'property_id' => 'required|integer',
            'room_Id' =>'required',
            'user1' => 'required|integer',
            'user2' => 'required|integer'
        ]);
       $notifications = Notifications::where('property_id', $request->property_id)->where('room_id', $request->room_Id)->whereNull('deleted_at')
            ->orderBy('id')
            ->get();
    //    echo "<pre>";print_r($notifications);exit;
        return response()->json(['notifications' => $notifications]);
    }

    public function send(Request $request)
    {
        $data = $request->validate([
            'property_id' => 'required|integer',
            'room_id' => 'required|integer',
            'sender_id' => 'required|integer',
            'receiver_id' => 'required|integer',
            'sender_type' => 'required|in:admin,guest',
            'notification' => 'required',
        ]);
        
        $notification = Notifications::create($data);
        // echo "<pre>";print_r($notification);exit;
        // broadcast(new NewChatMessage($chat))->toOthers();
        $title = "Here is the notification for you";
        $body = $data['notification'];
        self::sendNotification($data['room_id'],$title,$body);

        return response()->json(['success' => true]);
    }

    public static function sendNotification($room_id,$title,$body)
    {
        $url = 'https://fcm.googleapis.com/v1/projects/hotel-call-938c4/messages:send';

        $credentialsFilePath = Storage::path('json/hotel-call-938c4-firebase-adminsdk-fbsvc-32eb89ecac.json');
        $client = new GoogleClient();
        $client->setAuthConfig($credentialsFilePath);
        $client->addScope('https://www.googleapis.com/auth/firebase.messaging');
        $client->refreshTokenWithAssertion();
        $token = $client->getAccessToken();
		$access_token = $token['access_token'];

        $notify = array('title'=>$title,'body'=>$body);

        //check notificaion log for duplicates
        $file_data = '';
        $file_data .="\n-------------\n";
        $file_data .="\Notified at \n".date('Y-m-d H:i:s');
        $file_data .="\n-------------\n";
        Storage::disk('local')->append('notification_check.txt', $file_data);    
        
        $firebaseToken = DB::table('rooms')->select('device_token')->where('id',$room_id)->first();
        // echo "<pre>HERE ";print_r( $firebaseToken->device_token);exit;
        $data = [
            "message" => [
                "token" => $firebaseToken->device_token,
                "notification" =>$notify,
                'data' =>array(
                    'title'=>$title,
                    'body'=>$body,
                    "room_id"=>(string) $room_id,
                    "timestamp"=>date('Y-m-d H:i s'),
                    "mutable-content"=>"1",
                    'subtitle' => 'room_notify'
                ),
            ]
        ];

        $headers = [
            "Authorization: Bearer $access_token",
            'Content-Type: application/json'
        ];

 
        // $url = 'https://fcm.googleapis.com/fcm/send';
        $ch = curl_init($url);
        curl_setopt_array($ch, array(
            CURLOPT_POST => true,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_TIMEOUT => 60
        ));
        $result = curl_exec($ch);
        $responseData = json_decode($result, true);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        // echo "<pre>";print_r( json_encode($data));exit;
        $error = curl_error($ch);
        //  echo "<pre>HERE ";print_r( $responseData);exit;
        curl_close($ch);
       
        return 1;
    }

}