<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\CriminalRecords;
use App\Models\Country;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use DataTables;
use File;

class MostWantedController extends Controller
{
    public function index(Request $request){
        $datas = $request->all();
        $main_id = Auth::user()->id;
        $data = CriminalRecords::orderBy('id','desc')->where('most_wanted','=',1)->get();
        foreach($data as $criminal){
            $criminal->name = $criminal->first_name.' '.$criminal->last_name;

            $nationality = Country::find($criminal->nationality);
            $criminal->nationality = '';
            $criminal->nationality = $nationality->name;
        }
        if ($request->ajax()) {
            $action =  '<button type="button" class="view_record"  data-record-id={{$id}} style="padding: 0;border: none;background: none;" data-toggle="tooltip" data-placement="top" title="View Record details" ><i class="fa fa-eye" style="font-size: 20px;"></i></button>';

            // $action =  '<a href="/criminalrecords/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
            return Datatables::of($data)
                ->addColumn('action', $action)
                ->rawColumns(['action'])
                ->make(true);
        }
        return view('dashboard.criminalrecords.mostWantedList');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $countries = Country::all(); 
        return view('dashboard.criminalrecords.create',['countries'=>$countries]);
    }

       /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'first_name'          => 'required|min:1|max:64',
            'description'   => 'required|min:1|max:64',
            'file_number'   => 'required|min:1|max:64|unique:criminal_records',
            'record_id'     => 'required|min:1|max:64|unique:criminal_records',
            'image'         => 'mimes:jpeg,png,jpg|min:1|max:1000',
        ]);

        //for criminal image
        if ($request->hasFile('image')) {

            $filenameWithExt = $request->file('image')->getClientOriginalName ();
            // Get Filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $extension = $request->file('image')->getClientOriginalExtension();
            // Filename To store
            $fileNameToStore = $request->input('file_number'). '_'. time().'.'.$extension;
            // Upload Image$path = 
            $img = $request->file('image')->storeAs('public/uploads/criminal_records', $fileNameToStore);    
        } else {
            $fileNameToStore = '';
            $img = '';
        }

        //insert new criminal record
        $record = new CriminalRecords();
        $record->file_number    = $request->input('file_number');
        $record->record_id      = $request->input('record_id');
        $record->first_name     = $request->input('first_name');
        $record->last_name      = $request->input('last_name');
        $record->description    = $request->input('description');
        $record->nationality    = $request->input('nationality');
        $record->gender         = $request->input('gender');
        $record->date_of_birth	= $request->input('date_of_birth');
        $record->age            = $request->input('age');
        $record->height         = $request->input('height');
        $record->eye_color      = $request->input('eye_color');
        $record->hair_color     = $request->input('hair_color');
        $record->image          = $fileNameToStore;
        $record->institution    = $request->input('institution');
        $record->passport_no    = $request->input('passport_no');
        $record->case_no    = $request->input('case_no');
        $record->law_instructions    = $request->input('law_instructions');
        $record->status    = $request->input('status');
        $record->most_wanted    = $request->input('most_wanted');
        
        $record->created_by     = Auth::user()->id;
        $record->save();

        //get recent record details
        $recent_record = CriminalRecords::where('file_number',$request->input('file_number'))->first();
        
        $request->session()->flash('message', 'Record Created Successfully.');
        return redirect()->route('criminalrecords.index');
    }

    //for editing criminal record
    public function edit($id)
    {
        $record = CriminalRecords::find($id);
        $baseUrl = url('/');
        $record->image = $baseUrl.'/public/storage/uploads/criminal_records/'. $record->image;
        $countries = Country::all(); 
        return view('dashboard.criminalrecords.edit', [ 'record' => $record ,'countries'=>$countries]);
    }
    
 /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'first_name'    => 'required|min:1|max:64',
            'last_name'     => 'required|min:1|max:64',
            'description'   => 'required|min:1|max:64',
            'image'         => 'mimes:jpeg,png,jpg|min:1|max:1000',
        ]);

         // create or update file in directory if exists 
         $path = public_path('storage/uploads/hotel_admins/criminal_records');
         if(!File::isDirectory($path)){
             File::makeDirectory($path, 0777, true, true);
         }
         
        //get requested rcord id
        $record = CriminalRecords::find($id);
        //for criminal image
        if ($request->hasFile('image')) {

            $filenameWithExt = $request->file('image')->getClientOriginalName ();
            // Get Filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $extension = $request->file('image')->getClientOriginalExtension();
            // Filename To store
            $fileNameToStore = $request->input('file_number'). '_'. time().'.'.$extension;
            // Upload Image$path =
            // echo  $fileNameToStore;exit;
            $img = $request->file('image')->storeAs('public/uploads/criminal_records', $fileNameToStore);    
        } else {
            $fileNameToStore = $record->image;
            $img = '';
        }

        //edit criminal recrd
        $record->file_number    = $request->input('file_number');
        $record->record_id      = $request->input('record_id');
        $record->first_name     = $request->input('first_name');
        $record->last_name      = $request->input('last_name');
        $record->description    = $request->input('description');
        $record->nationality    = $request->input('nationality');
        $record->gender         = $request->input('gender');
        $record->date_of_birth	= $request->input('date_of_birth');
        $record->age            = $request->input('age');
        $record->height         = $request->input('height');
        $record->eye_color      = $request->input('eye_color');
        $record->hair_color     = $request->input('hair_color');
        $record->image          = $fileNameToStore;
        $record->institution    = $request->input('institution');
        $record->passport_no    = $request->input('passport_no');
        $record->case_no    = $request->input('case_no');
        $record->law_instructions    = $request->input('law_instructions');
        $record->status    = $request->input('status');
        $record->most_wanted    = $request->input('most_wanted');
        
        // $record->created_by     = Auth::user()->id;
        $record->save();

        $request->session()->flash('message', 'Record Updated Successfully');
        return redirect()->route('criminalrecords.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $record = CriminalRecords::find($id);
        if($record){
            $existing_file_path = public_path('storage/uploads/criminal_records/'.$record->image);
            $trash_file_path_dir = public_path('storage/trash/criminal_records/'.$record->image);
            File::move($existing_file_path, $trash_file_path_dir);
            $record->delete();
        }
        return redirect()->route('criminalrecords.index');
    }

}
