<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use App\Models\IdProofTypes;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use App\Models\Properties;
use DataTables;

class MessageController extends Controller
{
    public function index(Request $request)
    {
        $admin_id = auth()->id();
        $guest_id = $request->get('guest_id') ?? null; // optional
        $main_id = Auth::user()->id ;
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();

        // $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();  
        
        
        // Subquery to get latest chat time per property
        $latestChats = DB::table('chats')
        ->select('property_id', DB::raw('MAX(created_at) as latest_chat_at'))
        ->groupBy('property_id');
        
        // Join properties with latest chats and order by latest_chat_at
        $properties = DB::table('properties')
            ->joinSub($latestChats, 'latest_chats', function ($join) {
                $join->on('properties.id', '=', 'latest_chats.property_id');
            })
        ->where('properties.status_id', '1')
        ->where('properties.owner', $hotelAdmin_id->id)
        ->select('properties.*', 'latest_chats.latest_chat_at')
        ->orderByDesc('latest_chats.latest_chat_at')
        ->get();
        return view('dashboard.messages.index', compact('properties', 'admin_id', 'guest_id'));
    }

    public function chatUI($property_id, $admin_id, $guest_id)
    {
        return view('chat', compact('property_id', 'admin_id', 'guest_id'));
    }
}