<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\CriminalRecords;
use App\Models\Country;
use App\Models\HotelAdmin;
use App\Models\Visitors;
use App\Models\Properties;
use App\Models\Customers;
use App\Models\Tax;
use App\Models\TaxDetails;
use App\Models\TaxInvoiceItems;
use App\Models\TaxSettingsItems;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use DataTables;
use File;
use PDF;


class GenerateTaxInvoiceController extends Controller
{
    public function show(Request $request)
    {   
        $datas = $request->all();

        if(array_key_exists('is_get_cust',$datas) == true){
            return  $this->getCustomersListByProperty($datas);
        }
        
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();
        return view('dashboard.taxsettings.generatetaxinvoice',['properties'=>$properties]);
    }
    
    public function getCustomersListByProperty(Request $request)
    {   
        $data = $request->all();
        $custs = DB::table('customers')->select('*')
       ->where('deleted_at',NULL)
        ->where('property_id',$data['property_id'])->get();

        $html = "<option value='0'>Select Guest</option>";
        if(!empty($custs)){
            foreach($custs  as $cust){
                $html .= "<option value='".$cust->id."'>".$cust->first_name.' '.$cust->last_name.' ('.$cust->guest_code.")</option>";
            }
        } else {
            $html = "<option value='0'>Customer not available.</option>";
        }
        return response()->json(array('success'=>true, 'html'=>$html));

    }

    public function generate(Request $request)
    {   
        $data = $request->all();
        $cust_id = $data['customer_id'];
        $customer = Customers::find($cust_id);
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();

        $taxsettings = Tax::where('property_id',$customer->property_id)->orderBy('id','desc')->first();
        $taxsettingsItems = TaxSettingsItems::where('tax_settings_id',$taxsettings->id)->get();

        $taxsettintax_details_exists = DB::table('tbl_customers_tax_invoice_details')->where('property_id',$customer->property_id)->orderBy('id','desc')->first();
        if(empty($taxsettintax_details_exists)){
            $tx_inv_no = date('Y').'-00001';
        } else {
            $existing_inv_no_ar =  explode('-',$taxsettintax_details_exists->invoice_no);
            $inv_no_suffix = $existing_inv_no_ar[1];
            $curr_seq_no = $inv_no_suffix + 1;
            $final_seq_no = str_pad($curr_seq_no, 5, '0', STR_PAD_LEFT);

            $tx_inv_no = date('Y').'-'.$final_seq_no;
        // echo "<pre>";print_r($tx_inv_no);exit; 

        }
        // echo "<pre>";print_r($tx_inv_no);exit; 

        $curr_time = date('H:i');
        // echo "<pre>";print_r($taxsettingsItems);exit; 
        
        return view('dashboard.taxsettings.taxinvoicepreview', ['customer' => $customer,'taxsettings'=>$taxsettings,'taxsettingsItems' => $taxsettingsItems,'tx_inv_no'=>$tx_inv_no,'curr_time' => $curr_time]);
   
    }
    
    
}
?>