<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\GeneralUser;
use App\Models\Complaints;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use DataTables;
use File;
use App\Models\ComplaintTypes;
use App\Models\Customers;
use Illuminate\Support\Facades\Auth;

class GeneralUserCompController extends Controller
{
    public function create(Request $request)
    {
        $data = $request->all(); 
        $complaint_types = ComplaintTypes::all();
        $customer = Customers::all();
        $cust = array();
        return view('dashboard.complaints.addcomplaintByGeneralUser', ['customers'=>$customer,'complaint_types'=> $complaint_types]);
    }

        /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'complaint_type' => 'required',
            'complaint_rating' => 'required',
            'title'      => 'required|min:1',
            'description'=> 'required|min:1|max:64',
            'document' => 'mimes:jpeg,png,jpg,pdf|min:1|max:1000',
        ]);
        $complaint_against = $request->input('complaint_against');
        $user_id = Auth::user()->id;
        
        // create or update file in directory if exists in hotel admin folder
        $path = public_path('storage/uploads/general_isers/'.$user_id.'/complaints_doccument/'.$complaint_against);
        if(!File::isDirectory($path)){
            File::makeDirectory($path, 0777, true, true);
        }

        //for complaint document
        if ($request->hasFile('document')) {

            $filenameWithExt = $request->file('document')->getClientOriginalName ();
            // Get Filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $extension = $request->file('document')->getClientOriginalExtension();
            // Filename To store
            $fileNameToStore = $filename. '_'. time().'.'.$extension;
            // Upload Image$path = 
            $img = $request->file('document')->storeAs('public/uploads/general_isers/'.$user_id.'/complaints_doccument'.'/'.$complaint_against, $fileNameToStore);    
        } else {
            $fileNameToStore = '';
            $img = '';
        }

        //insert new complaint
        $complaint = new Complaints();
        $complaint->title    = $request->input('title');
        $complaint->description   =  $request->input('description');
        $complaint->complaint_against   =  $complaint_against;
        $complaint->complaint_from   =  $user_id;
        $complaint->document   = $fileNameToStore;
        $complaint->complaint_type   =  $request->input('complaint_type');
        $complaint->complaint_rating   =  $request->input('complaint_rating');
        $complaint->complaint_status = '1';
        $complaint->created_by   = $user_id;
        $complaint->save();

        $request->session()->flash('message', 'Complaint Created Successfully.');

        return redirect()->route('complaints.index');
    }


}