<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Customers;
use App\Models\Complaints;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use App\Models\ComplaintTypes;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use DataTables;
use File;


class ComplaintsController extends Controller
{

    /**
     * Show all complaints from hotel admin logged in
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {   
        if ($request->ajax()) {
            if(Auth::user()->id == '1'){
                //its super admin and show all complaint
                $data = Complaints::orderBy('id','desc')->get();
            } else {
                $data_q = Complaints::where('complaint_status','1')->where('created_by',Auth::user()->id);
                if(Auth::user()->id == '7'){//for general user
                    $data_q->where('status','1')->orderBy('status','desc');
                } else {
                    $data_q->orderBy('id','desc');
                }
                $data = $data_q->get();
            }
                foreach($data as $complaint){
                    $id = $complaint->id;
                    $complaint_against = Customers::find($complaint->complaint_against);
                    // echo $complaint->complaint_against.' - ';
                    if($complaint->complaint_against){
                        $complaint->complaint_against = $complaint_against->first_name.' '. $complaint_against->last_name;
                    } else {
                        $complaint->complaint_against = ''; 
                    }
                }

                $action =  '<button type="button" class="view_compliant"  data-record-id={{$id}} style="padding: 0;border: none;background: none;" data-toggle="tooltip" data-placement="top" title="View complaint details" ><i class="cil-envelope-open" style="font-size: 20px;"></i></button>';
                if(Auth::user()->id == '1'){
                    $action .=  '<a href="/complaints/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="cil-pencil" style="font-size: 20px;"></i></a>';
                }
                return Datatables::of($data)
                        ->addColumn('action', $action)
                        ->rawColumns(['action'])
                        ->make(true);
        }
        return view('dashboard.complaints.complaintsList');
    }

    


        
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $data = $request->all(); 
        $customer = Customers::find($data['id']);
        $complaint_types = ComplaintTypes::all();

        $cust = array();
        return view('dashboard.customers.addcomplaint', [ 'customer' => $customer,'complaint_types'=> $complaint_types]);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'complaint_type' => 'required',
            'complaint_rating' => 'required',
            'title'      => 'required|min:1',
            'description'=> 'required|min:1|max:64',
            'document' => 'mimes:jpeg,png,jpg,pdf|min:1|max:1000',
        ]);
        $complaint_against = $request->input('complaint_against');
        $hotel_admin_id = Auth::user()->id;
        
        // create or update file in directory if exists in hotel admin folder
        $path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id.'/complaints_doccument/'.$complaint_against);
        if(!File::isDirectory($path)){
            File::makeDirectory($path, 0777, true, true);
        }

        //for complaint document
        if ($request->hasFile('document')) {

            $filenameWithExt = $request->file('document')->getClientOriginalName ();
            // Get Filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $extension = $request->file('document')->getClientOriginalExtension();
            // Filename To store
            $fileNameToStore = $filename. '_'. time().'.'.$extension;
            // Upload Image$path = 
            $img = $request->file('document')->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/complaints_doccument'.'/'.$complaint_against, $fileNameToStore);    
        } else {
            $fileNameToStore = '';
            $img = '';
        }

        //insert new complaint
        $complaint = new Complaints();
        $complaint->title    = $request->input('title');
        $complaint->description   =  $request->input('description');
        $complaint->complaint_against   =  $complaint_against;
        $complaint->complaint_from   =  $hotel_admin_id;
        $complaint->document   = $fileNameToStore;
        $complaint->complaint_type   =  $request->input('complaint_type');
        $complaint->complaint_rating   =  $request->input('complaint_rating');
        $complaint->complaint_status = '1';
        if(Auth::user()->id == '1'){
            $complaint->status =  $request->input('status');
        } else {
            $complaint->status =  '2';
        }
        $complaint->created_by   = $hotel_admin_id;

        $complaint->save();

        $request->session()->flash('message', 'Complaint Created Successfully.');

        return redirect()->route('customers.index');
    }

    public function show(Request $request)
    {
        $data = $request->all();
        if(array_key_exists('type',$data) != false){
            return  $this->getComplaintDetails($data);
        }
    }
    public function getComplaintDetails($data)
    { 
        $datas = Complaints::find($data['id']);
            $baseUrl = url('/');
            $id = $datas->id;
            $complaint_against = Customers::find($datas->complaint_against);
            $datas->complaint_against = $complaint_against->first_name.' '.$complaint_against->last_name;
            
            $complaint_type = ComplaintTypes::find($datas->complaint_type);
            $datas->complaint_type = $complaint_type->title;
            
            $complaint_rating = '';
            if($datas->complaint_rating == '5' ){
                $complaint_rating = 'Very Serious';
            } else if($datas->complaint_rating == '4' ){
                $complaint_rating = 'Serious';
            } else if($datas->complaint_rating == '3' ){
                $complaint_rating = 'Major';
            } else if($datas->complaint_rating == '2' ){
                $complaint_rating = 'Minor';
            } else {//else 1 = very minor
                $complaint_rating = 'Very Minor';
            } 
            $datas->complaint_rating = $complaint_rating;
           
            if($datas->complaint_status == '1' ){
                $datas->complaint_status = 'Show';
            } else {
                $datas->complaint_status = 'Hide';
            } 

            if($datas->document){
                $datas->document  = $baseUrl.'/public/storage/uploads/hotel_admins/'.$datas->complaint_from.'/complaints_doccument'.'/'.$complaint_against->id.'/'.$datas->document;
            } else {
                $datas->document  = '--';
            }
            
            if($datas->action_taken){
                $datas->action_taken = $datas->action_taken;
            } else {
                $datas->action_taken = '--';
            }

            
            // $datas->document = '<a href="{{$document}}"  target="_blank">View Document</a>';
        return response()->json( $datas);
    }
    //for editing hotel admin
    public function edit($id)
    {
        $complaint = Complaints::find($id);

        $complaint_against = Customers::find($complaint->complaint_against);
        $complaint->complaint_against_name = $complaint_against->full_name;

        $complaint_types = ComplaintTypes::all();
        return view('dashboard.complaints.edit', [ 'complaint' => $complaint,'complaint_types'=>$complaint_types ]);
    }

    
    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'complaint_type' => 'required',
            'complaint_rating' => 'required',
            'title'      => 'required|min:1',
            'description'=> 'required|min:1|max:64',
            // 'document' => 'mimes:jpeg,png,jpg,pdf|min:1|max:1000',
        ]);
        $complaint_against = $request->input('complaint_against');
        $hotel_admin_id = Auth::user()->id;
        
        // create or update file in directory if exists in hotel admin folder
        $path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id.'/complaints_doccument/'.$complaint_against);
        if(!File::isDirectory($path)){
            File::makeDirectory($path, 0777, true, true);
        }

        //for complaint document
        if ($request->hasFile('document')) {

            $filenameWithExt = $request->file('document')->getClientOriginalName ();
            // Get Filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $extension = $request->file('document')->getClientOriginalExtension();
            // Filename To store
            $fileNameToStore = $filename. '_'. time().'.'.$extension;
            // Upload Image$path = 
            $img = $request->file('document')->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/complaints_doccument'.'/'.$complaint_against, $fileNameToStore);    
        } else {
            $fileNameToStore = '';
            $img = '';
        }

        //insert new complaint
        $complaint = Complaints::find($id);
        $complaint->title    = $request->input('title');
        $complaint->description   =  $request->input('description');
        // $complaint->complaint_from   =  $hotel_admin_id;
        $complaint->document   = $fileNameToStore;
        $complaint->complaint_type   =  $request->input('complaint_type');
        $complaint->complaint_rating   =  $request->input('complaint_rating');
        $complaint->complaint_status = $request->input('complaint_status');
        $complaint->action_taken =  $request->input('action_taken');

        if(Auth::user()->id == '1'){
            $complaint->status =  $request->input('status');
        } else {
            $complaint->status =  '2';
        }

        $complaint->save();

        $request->session()->flash('message', 'Complaint Updated Successfully.');

        return redirect()->route('complaints.index');
    }


}
