<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\CriminalRecords;
use App\Models\Country;
use App\Models\HotelAdmin;
use App\Models\Visitors;
use App\Models\Properties;
use App\Models\Customers;
use App\Models\CommercialTax;
use App\Models\CommercialTaxDetails;
use App\Models\CommercialSettingsItems;
use App\Models\CommercialInvoiceItems;
use App\Models\ReceiptSettings;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use DataTables;
use File;
use PDF;


class CommercialTaxController extends Controller
{
    public function index(Request $request){
        $datas = $request->all();
        $main_id = Auth::user()->id;
        $dataq = DB::table('tbl_commercial_tax_settings as tx')->select('tx.id','tx.property_id','pr.name');
        $dataq->join('properties as pr','pr.id','=','tx.property_id','left');
        $data = $dataq->orderBy('tx.id','desc')->where('tx.created_by',$main_id)->get();
        if ($request->ajax()) {
            $action =  '<a href="/commercialtaxsettings/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
           return Datatables::of($data)
                ->addColumn('action', $action)
                ->rawColumns(['action'])
                ->make(true);
        }
        return view('dashboard.commercialtaxsettings.commercialtaxsettingsList');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $countries = Country::all(); 
        $main_id = Auth::user()->id ;
        $curr_year = date('Y');
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();
        $tax_seq_no = '00001';   
        return view('dashboard.commercialtaxsettings.create',['curr_year'=>$curr_year,'properties'=>$properties,'tax_seq_no'=>$tax_seq_no]);
    }

       /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'property_id'          => 'required',
            'tax_seq_no'   => 'required',
        ]);

        $data = $request->all();
        //for tax header
        if ($request->hasFile('header_logo')) {

            $headerfilenameWithExt = $request->file('header_logo')->getClientOriginalName ();
            // Get Filename
            $headerfilename = pathinfo($headerfilenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $headerextension = $request->file('header_logo')->getClientOriginalExtension();
            // Filename To store
            $headerfileNameToStore = 'commercial_tax_header_'.$headerfilename. '_'. time().'.'.$headerextension;
            // Upload Image$path = 
            $headerimg = $request->file('header_logo')->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/commercial_tax_settings', $headerfileNameToStore);    
        } else {
            $headerfileNameToStore = '';
            $headerimg = '';
        }

        //for tax footer
        if ($request->hasFile('footer_logo')) {

            $footerfilenameWithExt = $request->file('footer_logo')->getClientOriginalName ();
            // Get Filename
            $footerfilename = pathinfo($footerfilenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $footerextension = $request->file('footer_logo')->getClientOriginalExtension();
            // Filename To store
            $footerfileNameToStore = 'commercial_tax_footer_'.$footerfilename. '_'. time().'.'.$footerextension;
            // Upload Image$path = 
            $footerimg = $request->file('footer_logo')->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/commercial_tax_settings', $footerfileNameToStore);    
        } else {
            $footerfileNameToStore = '';
            $footerimg = '';
        }

        //insert new criminal record
        $record = new CommercialTax();
        $record->property_id      = $request->input('property_id');
        $record->tax_seq_no    =  $request->input('tax_seq_no');
        $record->exchange_rate    = $request->input('exchange_rate');
        $record->header_logo   =  $headerfileNameToStore; 
        $record->footer_logo   =  $footerfileNameToStore; 
        $record->footer_text_1    = $request->input('footer_text_1');
        $record->footer_text_2    = $request->input('footer_text_2');
        $record->created_by     = Auth::user()->id;
        $record->save();
        $commercial_settings_id = $record->id;
        $seq = 0;
        //echo "<pre>";print_r($tax_detail_id);exit; 

        foreach( $data['tax_item_charge_type'] as $seqkey => $seqk){
            $invoiceitems = new CommercialSettingsItems();
            $invoiceitems->commercial_settings_id = $commercial_settings_id;
            $invoiceitems->tax_item_charge_type =  $data['tax_item_charge_type'][$seq];
            $invoiceitems->amount =  0;
            $invoiceitems->save();
            $seq++;
        }
        //echo "<pre>";print_r($tax_detail_id);exit; 

        
        $request->session()->flash('message', 'Record Created Successfully.');
        return redirect()->route('commercialtaxsettings.index');
    }

    //for editing criminal record
    public function edit($id)
    {
        $tax = CommercialTax::find($id);
        $curr_year = date('Y');
        $main_id = Auth::user()->id ;
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();    
        $commercialsettingsItems = CommercialSettingsItems::where('commercial_settings_id',$id)->get();

        $baseUrl = url('/');
        // $visitor->visitor_image = $baseUrl.'/public/storage/uploads/visitors/'. $visitor->visitor_image;
        return view('dashboard.commercialtaxsettings.edit', [ 'tax' => $tax,'properties' => $properties,'curr_year'=> $curr_year,'commercialsettingsItems'=>$commercialsettingsItems]);
    }
    
 /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'property_id'          => 'required',
            'tax_seq_no'   => 'required',
        ]);

         // create or update file in directory if exists 
         $path = public_path('storage/uploads/hotel_admins/commercial_tax_settings');
         if(!File::isDirectory($path)){
             File::makeDirectory($path, 0777, true, true);
         }
         
        //get requested rcord id
        $record = CommercialTax::find($id);
        $data = $request->all();
        //for tax header
        if ($request->hasFile('header_logo')) {

            $headerfilenameWithExt = $request->file('header_logo')->getClientOriginalName ();
            // Get Filename
            $headerfilename = pathinfo($headerfilenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $headerextension = $request->file('header_logo')->getClientOriginalExtension();
            // Filename To store
            $headerfileNameToStore = 'commercial_tax_header_'.$headerfilename. '_'. time().'.'.$headerextension;
            // Upload Image$path = 
            $headerimg = $request->file('header_logo')->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/commercial_tax_settings', $headerfileNameToStore);    
        } else {
            $headerfileNameToStore = '';
            $headerimg = '';
        }

        //for tax footer
        if ($request->hasFile('footer_logo')) {

            $footerfilenameWithExt = $request->file('footer_logo')->getClientOriginalName ();
            // Get Filename
            $footerfilename = pathinfo($footerfilenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $footerextension = $request->file('footer_logo')->getClientOriginalExtension();
            // Filename To store
            $footerfileNameToStore = 'commercial_tax_footer_'.$footerfilename. '_'. time().'.'.$footerextension;
            // Upload Image$path = 
            $footerimg = $request->file('footer_logo')->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/commercial_tax_settings', $footerfileNameToStore);    
        } else {
            $footerfileNameToStore = '';
            $footerimg = '';
        }

        $record->property_id      = $request->input('property_id');
        $record->tax_seq_no    = $request->input('tax_seq_no');
        $record->exchange_rate    = $request->input('exchange_rate');
        $record->header_logo   =  $headerfileNameToStore; 
        $record->footer_logo   =  $footerfileNameToStore; 
        $record->footer_text_1    = $request->input('footer_text_1');
        $record->footer_text_2    = $request->input('footer_text_2');
        $record->updated_by     = Auth::user()->id;
        $record->save();

        $taxitemsdel = DB::table('tbl_commercial_settings_items')->where('commercial_settings_id', $id)->delete(); 
        $seq = 0;
        foreach( $data['tax_item_charge_type'] as $seqkey => $seqk){
            $invoiceitems = new CommercialSettingsItems();
            $invoiceitems->commercial_settings_id = $id;
            $invoiceitems->tax_item_charge_type =  $data['tax_item_charge_type'][$seq];
            $invoiceitems->amount =  0;
            $invoiceitems->save();
            $seq++;
        }

        $request->session()->flash('message', 'Record Updated Successfully');
        return redirect()->route('commercialtaxsettings.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $record = CommercialTax::find($id);
        if($record){
            $record->delete();
        }
        return redirect()->route('commercialtaxsettings.index');
    }

    public function show(Request $request)
    {   
       $data = $request->all();
        if(array_key_exists('is_commercial_tax_invoice',$data) == true){
            return  $this->generateCommercialTaxInvoice($data);
        }

        if(array_key_exists('is_commercial_invoice_receipt',$data) == true){
            return  $this->generateCommercialInvoiceReceipt($data);
        }
    }

    public function generateCommercialTaxInvoice($data)
    { 
        $cust_id = base64_decode($data['cust_id']);
        $customer = Customers::find($cust_id);
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();

        $taxsettings = CommercialTax::where('property_id',$customer->property_id)->orderBy('id','desc')->first();
       
            $tx_inv_no = date('Y-m-d').'-00001';
      
        $curr_time = date('H:i');
        
        return view('dashboard.commercialtaxsettings.commercialtaxinvoicepreview', ['customer' => $customer,'taxsettings'=>$taxsettings,'tx_inv_no'=>$tx_inv_no,'curr_time' => $curr_time]);
    }
    
    public function customer_commercial_tax_invoice(Request $request)
    {
        ini_set('max_execution_time', 180); //3 minutes
        $data = $request->all();
    
        $tax_set = CommercialTax::find($data['tax_row_id']);
        // echo "<pre>";print_r($data['customer_id']);exit;
        $taxsettintax_details_exists = DB::table('tbl_customers_commercial_tax_invoice_details')->where('customer_id',$data['customer_id'])->first();
        if(!empty($taxsettintax_details_exists)){
            $tax_record = CommercialTaxDetails::find($taxsettintax_details_exists->id);
        } else { 
            $tax_record = new CommercialTaxDetails();
            $tax_record->created_by = Auth::user()->id;
        }

        $tax_record->customer_id = $data['customer_id'];
        $tax_record->property_id = $tax_set->property_id;
        $tax_record->commercial_row_id = $data['tax_row_id'];
        $tax_record->company_name = $data['company_name'];
        $tax_record->invoice_no = $data['invoice_no'];
        $tax_record->guest_name = $data['guest_name'];
        $tax_record->exchange_rate = $data['exchange_rate'];
        $tax_record->invoice_date = $data['invoice_date'];
        $tax_record->guest_code = $data['guest_code'];
        $tax_record->guest_address = $data['guest_address'];
        $tax_record->guest_checkindate_time = $data['checkout_date'].' '.$data['checkin_time'];
        $tax_record->guest_mobile = $data['guest_mobile'];
        $tax_record->guest_checkoutdate_time = $data['checkout_date'].' '.$data['checkout_time'];
        $tax_record->guest_vat_tin_no = $data['guest_vat_tin_no'];

        $tax_record->total_amount_usd = $data['total_amount_usd'];
        $tax_record->total_amount_kh = $data['total_amount_kh'];

        $tax_record->total_amt_usd = $data['total_amt_usd'];    
        $tax_record->total_amt_kh = $data['total_amt_kh'];
        // echo "<pre>";print_r($tax_record);exit; 

        $tax_record->save();
        if(!empty($taxsettintax_details_exists)){
            $tax_detail_id = $taxsettintax_details_exists->id;
        } else {
            $tax_detail_id = $tax_record->id;
        }

        $taxitemsdel = DB::table('tbl_customers_commercial_invoice_items')->where('commercial_detail_id', $tax_detail_id)->delete(); 
        $seq = 0;
    //    echo "<pre>";print_r($tax_detail_id);exit; 

        foreach( $data['tax_item_seq_no'] as $seqkey => $seqk){

            $item_str_ar = explode('-',$data['tax_item_charge_type'][$seq]);
            $taxsettingsItems = CommercialSettingsItems::where('id',$item_str_ar[0])->first();

            $invoiceitems = new CommercialInvoiceItems();
            $invoiceitems->commercial_detail_id = $tax_detail_id;
            $invoiceitems->tax_customer_id = $data['customer_id'];;
            $invoiceitems->tax_item_seq_no =  $data['tax_item_seq_no'][$seq];
            // $invoiceitems->tax_item_guest_id =  $data['tax_item_guest_id'][$seq];
            $invoiceitems->tax_item_charge_type =  $item_str_ar[0];
            $invoiceitems->tax_item_charge_type_name =  $taxsettingsItems->tax_item_charge_type;
            $invoiceitems->tax_item_charge_description =  $data['tax_item_charge_description'][$seq];
            $invoiceitems->tax_item_quantity =  $data['tax_item_quantity'][$seq];
            $invoiceitems->tax_item_unit_price =  $data['tax_item_unit_price'][$seq];
            $invoiceitems->tax_amount =  0;
            $invoiceitems->tax_item_amount =  $data['tax_item_amount'][$seq];
            $invoiceitems->save();
            $seq++;
        }


    //    echo "<pre>";print_r($tax_detail_id);exit; 


        $filename = "commercial_invoice";
        $ar['commercialtaxsettings'] = CommercialTax::find($data['tax_row_id']);
        $ar['commercialtaxDetails'] = CommercialTaxDetails::find($tax_detail_id);
        // echo "<pre>";print_r($ar['taxInvoiceItems']);exit; 
        $request->session()->flash('message', 'Record Updated Successfully');
        return redirect()->route('commercialtaxinvoicelist.commercial_tax_invoice_list');

        // $pdf = PDF::loadView('dashboard.taxsettings.invoice',$ar);
        // return $pdf->download('disney.pdf');
        echo "<pre>";print_r($data);exit; 
    }

    public function commercial_tax_invoice_list(Request $request){ echo "ddddd";exit;
        $datas = $request->all();
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();
        return view('dashboard.commercialtaxsettings.commercialtaxinvoicelist',['properties'=>$properties]);
    }
    

    
    public function generateCommercialInvoiceReceipt($data)
    { 
        $cust_id = base64_decode($data['cust_id']);
        $customer = Customers::find($cust_id);
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        $taxsettings = ReceiptSettings::where('property_id',$customer->property_id)->orderBy('id','desc')->first();
        echo "<pre>";print_r($taxsettings);exit; 
        return view('dashboard.receiptSettings.invoicereceipt', ['customer' => $customer,'ReceiptSettings'=>$ReceiptSettings]);
    }
}
