
@extends('dashboard.base')

@section('css')

@endsection

@section('content')

<style>
 #property_details{
    background-color: white;
    width: 877px;
    border: 1px solid black;
    padding: 13px;
    margin: 20px;
    border-radius:13px;
 }

 #profile_image{
    height: 77px;
    width: 74px;
    float:right;
    border-radius: 50px;    
    border: 1px solid black;
 }
</style>

<?php   $baseUrl = url('/'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-header"><h4>Details for {{$customer->first_name}} {{$customer->middle_name}}  {{$customer->last_name}} </h4></div>
                    <div class="card-body">
                        <!-- for customer profile pic -->
                        <div class="row">
                            <div class ="col-md-6"></div>
                            <div class ="col-md-5">
                                <img src="<?php echo asset($customer->profile_image);?>" id="profile_image" style="">
                            </div>
                            <div class ="col-md-1"></div>
                        </div>
                        <!-- show property details -->
                        <h6>Property Details:</h6>
                        <div id="property_details">
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="property name"><b>Name</b></label> : {{$customer->property_id}}
                                </div>
                                <div class="col-md-4">
                                    <label for="property name"><b>Organization Name</b></label> : {{$customer->org_name}}
                                </div>
                                <div class="col-md-4">
                                    <label for="property name"><b>Email</b> : {{$property->email}}
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="property name"><b>Mobile</b></label> : {{$property->mobile}}
                                </div>
                                <div class="col-md-4">
                                    <label for="property name"><b>Address</b></label> :{{$property->address}}, {{$property->city}}, {{$property->pin}}, {{$property->country}}
                                </div>
                                <div class="col-md-4">
                                    <label for="property name"><b>Phone</b></label> : {{$property->phone_1 }} / {{ $property->phone_2}}
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="property name"><b>Owner</b></label> : {{$property->owner}}
                                </div>
                            </div>
                        </div><hr/>
                        <!-- show property details end -->

                        <!-- show Basic details -->
                        <h6>Basic Details:</h6>
                        <table class="footable-details table table-striped table-hover toggle-circle">
                            <tbody>
                                <tr>
                                    <th>Full Name :</th>
                                    <td style="display: table-cell;">{{$customer->first_name}} {{$customer->middle_name}} {{$customer->last_name}}</td>
                                </tr>

                                <tr>
                                    <th>Email :</th>
                                    <td style="display: table-cell;">{{$customer->email}}</td>
                                </tr>

                                <tr>
                                    <th>Mobile :</th>
                                    <td style="display: table-cell;">{{$customer->mobile}}</td>
                                </tr>

                                <tr>
                                    <th>Date Of Birth :</th>
                                    <td style="display: table-cell;">{{$customer->date_of_birth}}</td>
                                </tr>

                                <tr>
                                    <th>Gender :</th>
                                    <td style="display: table-cell;">{{$customer->gender}}</td>
                                </tr>
                                <tr>
                                    <th>Nationality :</th>
                                    <td style="display: table-cell;">{{$customer->nationality}}</td>
                                </tr>

                                <tr>
                                    <th>Passport Number :</th>
                                    <td style="display: table-cell;">{{$customer->passport_number}}</td>
                                </tr>

                                <tr>
                                    <th>Passport Expiry Date :</th>
                                    <td style="display: table-cell;">{{$customer->passport_expiry_date}}</td>
                                </tr>

                                <tr>
                                    <th>Country of Issue :</th>
                                    <td style="display: table-cell;">{{$customer->country_of_issue}}</td>
                                </tr>

                                <tr>
                                    <th>CheckIn DateTime :</th>
                                    <td style="display: table-cell;">{{$customer->checkin_date_time}}</td>
                                </tr>

                                <tr>
                                    <th>CheckOut DateTime :</th>
                                    <td style="display: table-cell;">{{$customer->checkout_date_time}}</td>
                                </tr>
                            </tbody>
                        </table><hr/>
                        <!-- show Basic details end-->

                        <!-- for customer documents -->
                        <h6>Documents:</h6>
                        <table class='table table-striped table-bordered datatable docs'>
                            <thead>
                                <tr>
                                    <th>Document Type</th>
                                    <th>Number</th>
                                    <th>Uploaded File</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if(count($docs) > 0)
                                    @foreach($docs as $doc)
                                        <tr>
                                            <td>{{$doc->document_type}}</td>
                                            <td>{{$doc->number}}</td> 
                                            <td><img src="<?php echo asset($doc->uploaded_document);?>" style="width: 50px;"></td>
                                            <td>
                                                <a data-toggle='tooltip' data-placement='top' title='View Document' href='{{$doc->uploaded_document}}' target='_blank' style='color: black;'><i class='fa fa-eye' aria-hidden='true' id='doc_{{$doc->id}}'></i></a>             
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr><td>No documents found</td>
                                    <td></td>
                                    <td></td>
                                    <td></td></tr>
                                @endif
                            </tbody>
                        </table>
                        <!-- for customer documents end--> 
                        <a href="{{ route('customers.index') }}" class="btn btn-primary">Back</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>





@endsection

@section('javascript')

@endsection

